/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.dialect.api10.model;

//$Id: JAXBMessage.java 1802 2008-08-02 12:51:38Z thomas.diesler@jboss.com $

import java.util.ArrayList;
import java.util.List;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

/**
 * A Message, which is used in the definition of attributes for a @{link StartEvent},
 * 
 * @{EndEvent , @{IntermediateEvent}, @{Task}, and @{MessageFlow}
 * 
 * @author thomas.diesler@jboss.com
 * @since 08-Jul-2008
 */
@XmlType(name = "Message", propOrder = { "fromRef", "toRef", "properties"})
public class JAXBMessage extends JAXBSupportingElement
{
  private String name;
  private String fromRef;
  private String toRef;
  private List<JAXBProperty> properties = new ArrayList<JAXBProperty>();

  public String getName()
  {
    return name;
  }

  @XmlAttribute
  public void setName(String name)
  {
    this.name = name;
  }

  public String getFromRef()
  {
    return fromRef;
  }

  @XmlElement(name = "from")
  public void setFromRef(String fromRef)
  {
    this.fromRef = fromRef;
  }

  public String getToRef()
  {
    return toRef;
  }

  @XmlElement(name = "to")
  public void setToRef(String toRef)
  {
    this.toRef = toRef;
  }

  @XmlElement(name = "property")
  public List<JAXBProperty> getProperties()
  {
    return properties;
  }
}