/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.dialect.api10.model;

//$Id: JAXBProperty.java 1794 2008-07-31 16:15:38Z thomas.diesler@jboss.com $

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

/**
 * A Property, which is used in the definition of attributes for a Process and common activity attributes
 * 
 * @author thomas.diesler@jboss.com
 * @since 08-Jul-2008
 */
@XmlType(name = "Property", propOrder = {"name", "value"})
public class JAXBProperty extends JAXBSupportingElement
{
  private String name;
  private String value;
  private Boolean isCorrelation;

  public String getName()
  {
    return name;
  }

  @XmlElement
  public void setName(String name)
  {
    this.name = name;
  }

  public String getValue()
  {
    return value;
  }

  @XmlElement
  public void setValue(String value)
  {
    this.value = value;
  }

  public Boolean isCorrelation()
  {
    return isCorrelation;
  }

  @XmlAttribute
  public void setCorrelation(Boolean isCorrelation)
  {
    this.isCorrelation = isCorrelation;
  }
}