/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.dialect.api10.model;

//$Id: JAXBSignal.java 1889 2008-08-14 13:29:28Z thomas.diesler@jboss.com $

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

import org.jboss.bpm.model.Signal.SignalType;

/**
 * The base of all supported event details
 * 
 * @author thomas.diesler@jboss.com
 * @since 08-Jul-2008
 */
@XmlType(name = "Signal")
public class JAXBSignal
{
  private SignalType type;
  private String message;

  public JAXBSignal()
  {
  }

  public JAXBSignal(SignalType type, String message)
  {
    this.type = type;
    this.message = message;
  }

  public SignalType getType()
  {
    return type;
  }

  @XmlAttribute(required = true)
  public void setType(SignalType type)
  {
    this.type = type;
  }

  public String getMessage()
  {
    return message;
  }

  @XmlElement
  public void setMessage(String message)
  {
    this.message = message;
  }
}