/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.dialect.api10.model;

//$Id: JAXBSubProcess.java 1796 2008-07-31 23:27:17Z thomas.diesler@jboss.com $

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;

/**
 * A Sub-Process is Process that is included within another Process.
 * 
 * @author thomas.diesler@jboss.com
 * @since 08-Jul-2008
 */
@XmlType(name = "SubProcess")
public class JAXBSubProcess extends JAXBActivity
{
  private JAXBExecutionHandler executionHandler;
  private JAXBFlowHandler flowHandler;
  private JAXBSignalHandler signalHandler;

  @XmlElements( { 
    @XmlElement(name = "seqflow", type = JAXBSequenceFlow.class), 
    @XmlElement(name = "msgflow", type = JAXBMessageFlow.class) })
  private JAXBFlow outFlow;

  public JAXBFlow getOutFlow()
  {
    return outFlow;
  }

  @XmlTransient
  public void setOutFlow(JAXBFlow outFlow)
  {
    this.outFlow = outFlow;
  }

  /**
   * Get the ExecutionHandler for this Event
   */
  public JAXBExecutionHandler getExecutionHandler()
  {
    return executionHandler;
  }

  /**
   * Set the ExecutionHandler for this Event
   */
  @XmlElement(name = "execution-handler", required = false)
  public void setExecutionHandler(JAXBExecutionHandler executionHandler)
  {
    this.executionHandler = executionHandler;
  }

  /**
   * Get the FlowHandler for this Event
   */
  public JAXBFlowHandler getFlowHandler()
  {
    return flowHandler;
  }

  /**
   * Set the FlowHandler for this Event
   */
  @XmlElement(name = "flow-handler", required = false)
  public void setFlowHandler(JAXBFlowHandler flowHandler)
  {
    this.flowHandler = flowHandler;
  }

  /**
   * Get the SignalHandler for this Event
   */
  public JAXBSignalHandler getSignalHandler()
  {
    return signalHandler;
  }

  /**
   * Set the SignalHandler for this Event
   */
  @XmlElement(name = "signal-handler", required = false)
  public void setSignalHandler(JAXBSignalHandler signalHandler)
  {
    this.signalHandler = signalHandler;
  }
}