/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.dialect.api10.model;

import java.util.ArrayList;
import java.util.List;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;

import org.jboss.bpm.model.Message;
import org.jboss.bpm.model.Task;
import org.jboss.bpm.model.Message.Implementation;

//$Id: JAXBTask.java 1930 2008-08-19 11:04:43Z thomas.diesler@jboss.com $

/**
 * A Task is an Atomic Activity that is included within a Process.
 * 
 * A Task is used when the work in the Process is not broken down to a finer level of Process Model detail. Generally,
 * an end-user and/or an application are used to perform the Task when it is executed.
 * 
 * @author thomas.diesler@jboss.com
 * @since 08-Jul-2008
 */
@XmlType(name = "Task", propOrder = { "outFlow", "implementation", "executionHandler", "flowHandler", "signalHandler",
    "messageRef", "inputSets", "outputSets" })
public class JAXBTask extends JAXBActivity
{
  private Task.TaskType taskType;
  private Implementation implementation;
  private List<JAXBInputSet> inputSets = new ArrayList<JAXBInputSet>();
  private List<JAXBOutputSet> outputSets = new ArrayList<JAXBOutputSet>();

  private JAXBExecutionHandler executionHandler;
  private JAXBFlowHandler flowHandler;
  private JAXBSignalHandler signalHandler;

  @XmlElements( { 
    @XmlElement(name = "seqflow", type = JAXBSequenceFlow.class),
    @XmlElement(name = "msgflow", type = JAXBMessageFlow.class) })
  private JAXBFlow outFlow;

  private JAXBMessageRef messageRef;
  
  public JAXBFlow getOutFlow()
  {
    return outFlow;
  }

  @XmlTransient
  public void setOutFlow(JAXBFlow outFlow)
  {
    this.outFlow = outFlow;
  }

  public Task.TaskType getTaskType()
  {
    return taskType;
  }

  @XmlAttribute
  public void setTaskType(Task.TaskType taskType)
  {
    this.taskType = taskType;
  }

  public Message.Implementation getImplementation()
  {
    return implementation;
  }

  public void setImplementation(Message.Implementation implementation)
  {
    this.implementation = implementation;
  }

  public JAXBMessageRef getMessageRef()
  {
    return messageRef;
  }

  @XmlElement(name = "msgref")
  public void setMessageRef(JAXBMessageRef messageRef)
  {
    this.messageRef = messageRef;
  }

  public List<JAXBInputSet> getInputSets()
  {
    return inputSets;
  }

  @XmlElement(name = "input-set")
  public void setInputSets(List<JAXBInputSet> inputSets)
  {
    this.inputSets = inputSets;
  }

  public List<JAXBOutputSet> getOutputSets()
  {
    return outputSets;
  }

  @XmlElement(name = "output-set")
  public void setOutputSets(List<JAXBOutputSet> outputSets)
  {
    this.outputSets = outputSets;
  }

  public JAXBExecutionHandler getExecutionHandler()
  {
    return executionHandler;
  }

  @XmlElement(name = "execution-handler", required = false)
  public void setExecutionHandler(JAXBExecutionHandler executionHandler)
  {
    this.executionHandler = executionHandler;
  }

  public JAXBFlowHandler getFlowHandler()
  {
    return flowHandler;
  }

  @XmlElement(name = "flow-handler", required = false)
  public void setFlowHandler(JAXBFlowHandler flowHandler)
  {
    this.flowHandler = flowHandler;
  }

  public JAXBSignalHandler getSignalHandler()
  {
    return signalHandler;
  }

  @XmlElement(name = "signal-handler", required = false)
  public void setSignalHandler(JAXBSignalHandler signalHandler)
  {
    this.signalHandler = signalHandler;
  }
}