/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.dialect.api10;

import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import javax.management.ObjectName;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.jboss.bpm.InvalidProcessException;
import org.jboss.bpm.NotImplementedException;
import org.jboss.bpm.client.DialectHandler;
import org.jboss.bpm.client.ProcessManager;
import org.jboss.bpm.dialect.api10.model.JAXBAssignment;
import org.jboss.bpm.dialect.api10.model.JAXBCancelEventDetail;
import org.jboss.bpm.dialect.api10.model.JAXBCompensationEventDetail;
import org.jboss.bpm.dialect.api10.model.JAXBComplexGateway;
import org.jboss.bpm.dialect.api10.model.JAXBConditionalEventDetail;
import org.jboss.bpm.dialect.api10.model.JAXBEndEvent;
import org.jboss.bpm.dialect.api10.model.JAXBErrorEventDetail;
import org.jboss.bpm.dialect.api10.model.JAXBEvent;
import org.jboss.bpm.dialect.api10.model.JAXBEventDetail;
import org.jboss.bpm.dialect.api10.model.JAXBExclusiveGateway;
import org.jboss.bpm.dialect.api10.model.JAXBExpression;
import org.jboss.bpm.dialect.api10.model.JAXBFlow;
import org.jboss.bpm.dialect.api10.model.JAXBFlowObject;
import org.jboss.bpm.dialect.api10.model.JAXBGateway;
import org.jboss.bpm.dialect.api10.model.JAXBHandler;
import org.jboss.bpm.dialect.api10.model.JAXBInclude;
import org.jboss.bpm.dialect.api10.model.JAXBInclusiveGateway;
import org.jboss.bpm.dialect.api10.model.JAXBInputSet;
import org.jboss.bpm.dialect.api10.model.JAXBIntermediateEvent;
import org.jboss.bpm.dialect.api10.model.JAXBMessage;
import org.jboss.bpm.dialect.api10.model.JAXBMessageEventDetail;
import org.jboss.bpm.dialect.api10.model.JAXBMessageFlow;
import org.jboss.bpm.dialect.api10.model.JAXBMessageRef;
import org.jboss.bpm.dialect.api10.model.JAXBOutputSet;
import org.jboss.bpm.dialect.api10.model.JAXBParallelGateway;
import org.jboss.bpm.dialect.api10.model.JAXBProcess;
import org.jboss.bpm.dialect.api10.model.JAXBProperty;
import org.jboss.bpm.dialect.api10.model.JAXBSequenceFlow;
import org.jboss.bpm.dialect.api10.model.JAXBSignal;
import org.jboss.bpm.dialect.api10.model.JAXBSignalEventDetail;
import org.jboss.bpm.dialect.api10.model.JAXBStartEvent;
import org.jboss.bpm.dialect.api10.model.JAXBTask;
import org.jboss.bpm.dialect.api10.model.JAXBTerminateEventDetail;
import org.jboss.bpm.dialect.api10.model.JAXBTimerEventDetail;
import org.jboss.bpm.dialect.api10.model.ObjectFactory;
import org.jboss.bpm.model.EventBuilder;
import org.jboss.bpm.model.EventDetail;
import org.jboss.bpm.model.Gateway;
import org.jboss.bpm.model.GatewayBuilder;
import org.jboss.bpm.model.MessageBuilder;
import org.jboss.bpm.model.ObjectNameFactory;
import org.jboss.bpm.model.Process;
import org.jboss.bpm.model.ProcessBuilder;
import org.jboss.bpm.model.ProcessBuilderFactory;
import org.jboss.bpm.model.SequenceFlow;
import org.jboss.bpm.model.TaskBuilder;
import org.jboss.bpm.runtime.Handler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessUnmarshaller {
    public Process unmarshallProcess(Reader xml, boolean isInclude) throws JAXBException, IOException {
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ObjectFactory.class});
        Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
        unmarshaller.setProperty("com.sun.xml.bind.ObjectFactory", (Object)new ObjectFactory());
        JAXBProcess jaxbProc = (JAXBProcess)unmarshaller.unmarshal(xml);
        Process proc = this.adaptProcess(jaxbProc, isInclude);
        return proc;
    }

    private Process adaptProcess(JAXBProcess jaxbProc, boolean isInclude) throws IOException {
        ProcessBuilder procBuilder = ProcessBuilderFactory.newInstance().newProcessBuilder();
        procBuilder.addProcess(jaxbProc.getName());
        this.processIncludes(procBuilder, jaxbProc);
        for (JAXBMessage jaxb : jaxbProc.getMessages()) {
            MessageBuilder msgBuilder = procBuilder.addMessage(jaxb.getName());
            this.adaptJAXBMessage(msgBuilder, jaxb);
        }
        for (JAXBProperty jaxbProp : jaxbProc.getProperties()) {
            procBuilder.addProperty(jaxbProp.getName(), jaxbProp.getValue());
        }
        for (JAXBAssignment jaxbAss : jaxbProc.getAssignments()) {
            JAXBExpression jaxbFrom = jaxbAss.getFrom();
            String jaxbTo = jaxbAss.getTo();
            procBuilder.addAssignment(jaxbAss.getAssignTime(), jaxbFrom.getLang(), jaxbFrom.getBody(), jaxbTo);
        }
        for (JAXBFlowObject jaxbFlowObject : jaxbProc.getFlowObjects()) {
            if (jaxbFlowObject instanceof JAXBEvent) {
                this.adaptJAXBEvent(procBuilder, jaxbProc, (JAXBEvent)jaxbFlowObject);
            } else if (jaxbFlowObject instanceof JAXBTask) {
                this.adaptTask(procBuilder, jaxbProc, (JAXBTask)jaxbFlowObject);
            } else if (jaxbFlowObject instanceof JAXBGateway) {
                this.adaptJAXBGateway(procBuilder, jaxbProc, (JAXBGateway)jaxbFlowObject);
            } else {
                throw new IllegalStateException("Unsupported flow object: " + jaxbFlowObject);
            }
            for (JAXBAssignment jaxbAss : jaxbFlowObject.getAssignments()) {
                JAXBExpression jaxbFrom = jaxbAss.getFrom();
                String jaxbTo = jaxbAss.getTo();
                procBuilder.addAssignment(jaxbAss.getAssignTime(), jaxbFrom.getLang(), jaxbFrom.getBody(), jaxbTo);
            }
        }
        Process proc = isInclude ? procBuilder.getProcessForInclude() : procBuilder.getProcess();
        return proc;
    }

    private void processIncludes(ProcessBuilder procBuilder, JAXBProcess jaxbProc) throws IOException {
        for (JAXBInclude incl : jaxbProc.getIncludes()) {
            URL procURL;
            String nsURI = incl.getNamespace();
            String location = incl.getLocation();
            try {
                procURL = new URL(location);
            }
            catch (MalformedURLException ex) {
                ClassLoader ctxLoader = Thread.currentThread().getContextClassLoader();
                procURL = ctxLoader.getResource(location);
            }
            if (procURL == null) {
                throw new InvalidProcessException("Cannot find process include: " + location);
            }
            ProcessManager pm = ProcessManager.locateProcessManager();
            DialectHandler dh = pm.getDialectHandler(nsURI);
            Process procIncl = dh.createProcess(procURL, true);
            StringWriter strwr = new StringWriter();
            DialectHandler dhapi = pm.getDialectHandler("urn:bpm.jboss:pdl-0.1");
            dhapi.marshallProcess(procIncl, (Writer)strwr);
            procBuilder.addProcess(procIncl);
        }
    }

    private void adaptJAXBMessage(MessageBuilder msgBuilder, JAXBMessage jaxbMsg) {
        String toRef;
        String fromRef = jaxbMsg.getFromRef();
        if (fromRef != null) {
            msgBuilder.addFromRef(this.getObjectName(fromRef));
        }
        if ((toRef = jaxbMsg.getToRef()) != null) {
            msgBuilder.addToRef(this.getObjectName(toRef));
        }
        for (JAXBProperty jaxbProp : jaxbMsg.getProperties()) {
            boolean isCorrelation = jaxbProp.isCorrelation() != null ? jaxbProp.isCorrelation() : false;
            msgBuilder.addProperty(jaxbProp.getName(), (Object)jaxbProp.getValue(), isCorrelation);
        }
    }

    private ObjectName getObjectName(String objName) {
        return ObjectNameFactory.create((String)objName);
    }

    private void adaptJAXBEvent(ProcessBuilder procBuilder, JAXBProcess jaxbProc, JAXBEvent jaxb) {
        if (jaxb instanceof JAXBStartEvent) {
            JAXBStartEvent jaxbStart = (JAXBStartEvent)jaxb;
            EventBuilder eventBuilder = procBuilder.addStartEvent(jaxbStart.getName());
            this.addOutFlow(procBuilder, jaxbStart.getOutFlow());
            if (jaxbStart.getTrigger().size() > 1) {
                throw new NotImplementedException("JBPM-1660", "StartTrigger Multiple");
            }
            for (JAXBEventDetail jaxbTrigger : jaxbStart.getTrigger()) {
                if (jaxbTrigger instanceof JAXBMessageEventDetail) {
                    throw new NotImplementedException("JBPM-1657", "StartTrigger Message");
                }
                if (jaxbTrigger instanceof JAXBTimerEventDetail) {
                    throw new NotImplementedException("JBPM-1658", "StartTrigger Timer");
                }
                if (jaxbTrigger instanceof JAXBConditionalEventDetail) {
                    throw new NotImplementedException("JBPM-1659", "StartTrigger Conditional");
                }
                if (jaxbTrigger instanceof JAXBSignalEventDetail) {
                    JAXBSignalEventDetail jaxbSignalTrigger = (JAXBSignalEventDetail)jaxbTrigger;
                    JAXBSignal jaxbSignal = jaxbSignalTrigger.getSignal();
                    eventBuilder.addEventDetail(EventDetail.EventDetailType.Signal).addSignalRef(jaxbSignal.getType(), jaxbSignal.getMessage());
                    continue;
                }
                throw new IllegalStateException("Unsupported start trigger: " + jaxbTrigger);
            }
        } else {
            if (jaxb instanceof JAXBIntermediateEvent) {
                throw new NotImplementedException("JBPM-1661", "IntermediateEvent");
            }
            if (jaxb instanceof JAXBEndEvent) {
                JAXBEndEvent jaxbEnd = (JAXBEndEvent)jaxb;
                EventBuilder eventBuilder = procBuilder.addEndEvent(jaxbEnd.getName());
                if (jaxbEnd.getResult().size() > 1) {
                    throw new NotImplementedException("JBPM-1683", "EndEvent Multiple Result");
                }
                for (JAXBEventDetail jaxbResult : jaxbEnd.getResult()) {
                    if (jaxbResult instanceof JAXBMessageEventDetail) {
                        JAXBMessageEventDetail jaxbMessageResult = (JAXBMessageEventDetail)jaxbResult;
                        eventBuilder.addEventDetail(EventDetail.EventDetailType.Message);
                        JAXBMessageRef jaxbMsg = jaxbMessageResult.getMessageRef();
                        eventBuilder.addMessageRef(jaxbMsg.getNameRef());
                        continue;
                    }
                    if (jaxbResult instanceof JAXBErrorEventDetail) {
                        throw new NotImplementedException("JBPM-1677", "EndEvent Error Result");
                    }
                    if (jaxbResult instanceof JAXBCancelEventDetail) {
                        throw new NotImplementedException("JBPM-1678", "EndEvent Cancel Result");
                    }
                    if (jaxbResult instanceof JAXBCompensationEventDetail) {
                        throw new NotImplementedException("JBPM-1679", "EndEvent Compensation Result");
                    }
                    if (jaxbResult instanceof JAXBSignalEventDetail) {
                        throw new NotImplementedException("JBPM-1651", "EndEvent Signal Result");
                    }
                    if (jaxbResult instanceof JAXBTerminateEventDetail) {
                        throw new NotImplementedException("JBPM-1680", "EndEvent Terminate Result");
                    }
                    throw new IllegalStateException("Unsupported end event result type: " + jaxbResult);
                }
            } else {
                throw new IllegalStateException("Unsupported Event: " + jaxb);
            }
        }
        procBuilder.addExecutionHandler(this.loadHandler(jaxb.getExecutionHandler()));
        procBuilder.addFlowHandler(this.loadHandler(jaxb.getFlowHandler()));
        procBuilder.addSignalHandler(this.loadHandler(jaxb.getSignalHandler()));
    }

    private void adaptTask(ProcessBuilder procBuilder, JAXBProcess jaxbProc, JAXBTask jaxbTask) {
        TaskBuilder taskBuilder = procBuilder.addTask(jaxbTask.getName(), jaxbTask.getTaskType());
        this.addOutFlow((ProcessBuilder)taskBuilder, jaxbTask.getOutFlow());
        for (JAXBInputSet jAXBInputSet : jaxbTask.getInputSets()) {
            taskBuilder.addInputSet();
            for (JAXBProperty jaxbProp : jAXBInputSet.getProperties()) {
                taskBuilder.addPropertyInput(jaxbProp.getName());
            }
        }
        for (JAXBOutputSet jAXBOutputSet : jaxbTask.getOutputSets()) {
            taskBuilder.addOutputSet();
            for (JAXBProperty jaxbProp : jAXBOutputSet.getProperties()) {
                taskBuilder.addPropertyOutput(jaxbProp.getName(), jaxbProp.getValue());
            }
        }
        for (JAXBProperty jAXBProperty : jaxbTask.getProperties()) {
            taskBuilder.addProperty(jAXBProperty.getName(), jAXBProperty.getValue());
        }
        JAXBMessageRef jaxbMsgRef = jaxbTask.getMessageRef();
        if (jaxbMsgRef != null) {
            String string = jaxbMsgRef.getNameRef();
            taskBuilder.addMessageRef(string);
        }
        procBuilder.addExecutionHandler(this.loadHandler(jaxbTask.getExecutionHandler()));
        procBuilder.addFlowHandler(this.loadHandler(jaxbTask.getFlowHandler()));
        procBuilder.addSignalHandler(this.loadHandler(jaxbTask.getSignalHandler()));
    }

    private void adaptJAXBGateway(ProcessBuilder procBuilder, JAXBProcess jaxbProc, JAXBGateway jaxb) {
        GatewayBuilder gwBuilder;
        if (jaxb instanceof JAXBExclusiveGateway) {
            gwBuilder = procBuilder.addGateway(jaxb.getName(), Gateway.GatewayType.Exclusive);
        } else if (jaxb instanceof JAXBInclusiveGateway) {
            gwBuilder = procBuilder.addGateway(jaxb.getName(), Gateway.GatewayType.Inclusive);
        } else if (jaxb instanceof JAXBComplexGateway) {
            gwBuilder = procBuilder.addGateway(jaxb.getName(), Gateway.GatewayType.Complex);
        } else if (jaxb instanceof JAXBParallelGateway) {
            gwBuilder = procBuilder.addGateway(jaxb.getName(), Gateway.GatewayType.Parallel);
        } else {
            throw new IllegalStateException("Unsupported gateway: " + jaxb);
        }
        for (JAXBFlow jaxbFlow : jaxb.getOutFlows()) {
            if (jaxbFlow instanceof JAXBSequenceFlow) {
                JAXBSequenceFlow jaxbSeq = (JAXBSequenceFlow)jaxbFlow;
                if (jaxbSeq.getConditionType() == SequenceFlow.ConditionType.Expression) {
                    JAXBExpression jaxbExpr = jaxbSeq.getCondition();
                    gwBuilder.addConditionalGate(jaxbFlow.getTargetName(), jaxbExpr.getLang(), jaxbExpr.getBody());
                    continue;
                }
                if (jaxbSeq.getConditionType() == SequenceFlow.ConditionType.Default) {
                    gwBuilder.addDefaultGate(jaxbFlow.getTargetName());
                    continue;
                }
                gwBuilder.addGate(jaxbFlow.getTargetName());
                continue;
            }
            if (jaxbFlow instanceof JAXBMessageFlow) {
                throw new NotImplementedException("JBPM-1382", "Message Flow");
            }
            throw new IllegalStateException("Unsupported connectiong object: " + jaxbFlow);
        }
        procBuilder.addExecutionHandler(this.loadHandler(jaxb.getExecutionHandler()));
        procBuilder.addFlowHandler(this.loadHandler(jaxb.getFlowHandler()));
        procBuilder.addSignalHandler(this.loadHandler(jaxb.getSignalHandler()));
    }

    private void addOutFlow(ProcessBuilder procBuilder, JAXBFlow jaxbFlow) {
        if (jaxbFlow != null) {
            if (jaxbFlow instanceof JAXBSequenceFlow) {
                procBuilder.addSequenceFlow(jaxbFlow.getTargetName());
            } else {
                if (jaxbFlow instanceof JAXBMessageFlow) {
                    throw new NotImplementedException("JBPM-1382", "Message Flow");
                }
                throw new IllegalStateException("Unsupported connectiong object: " + jaxbFlow);
            }
        }
    }

    private Class<Handler> loadHandler(JAXBHandler jaxbHandler) {
        Class<?> handlerClass = null;
        if (jaxbHandler != null) {
            String className = jaxbHandler.getClassName();
            try {
                ClassLoader ctxLoader = Thread.currentThread().getContextClassLoader();
                handlerClass = ctxLoader.loadClass(className);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("Cannot load handler class: " + className);
            }
        }
        return handlerClass;
    }
}

