/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.dialect.jpdl32;

// $Id: ProcessUnmarshaller.java 1663 2008-07-17 09:27:02Z thomas.diesler@jboss.com $

import java.io.Reader;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;

import org.jboss.bpm.dialect.jpdl32.model.JPDL32ProcessDefinition;
import org.jboss.bpm.dialect.jpdl32.model.ObjectFactory;

/**
 * A JAXB unmarshaller for a Process 
 * 
 * @author thomas.diesler@jboss.com
 * @since 08-Jul-2008
 */
public class ProcessUnmarshaller 
{
  public JPDL32ProcessDefinition unmarshallProcess(Reader xml) throws JAXBException 
  {
    JAXBContext jaxbContext = JAXBContext.newInstance(ObjectFactory.class);
    Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
    unmarshaller.setProperty("com.sun.xml.bind.ObjectFactory",new ObjectFactory());
    JPDL32ProcessDefinition proc = (JPDL32ProcessDefinition)unmarshaller.unmarshal(xml);
    return proc;
  }
}
