/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.dialect.jpdl32;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.Writer;
import java.net.URL;
import javax.xml.bind.JAXBException;
import org.jboss.bpm.InvalidProcessException;
import org.jboss.bpm.NotImplementedException;
import org.jboss.bpm.client.DialectHandler;
import org.jboss.bpm.dialect.jpdl32.ProcessDefinitionAdapter;
import org.jboss.bpm.dialect.jpdl32.ProcessUnmarshaller;
import org.jboss.bpm.dialect.jpdl32.model.JPDL32ProcessDefinition;
import org.jboss.bpm.model.Process;

public class DialectHandlerImpl
implements DialectHandler {
    public static final String NAMESPACE_URI = "urn:jbpm.org:jpdl-3.2";

    public String getNamespaceURI() {
        return NAMESPACE_URI;
    }

    public Process createProcess(String pXML, boolean isInclude) {
        try {
            ProcessUnmarshaller unmarschaller = new ProcessUnmarshaller();
            JPDL32ProcessDefinition jaxbProc = unmarschaller.unmarshallProcess(new StringReader(pXML));
            Process proc = new ProcessDefinitionAdapter().adaptProcessDefinition(jaxbProc);
            return proc;
        }
        catch (JAXBException ex) {
            throw new InvalidProcessException("Cannot unmarschall: " + pXML, (Throwable)ex);
        }
    }

    public Process createProcess(URL pURL, boolean isInclude) throws IOException {
        try {
            ProcessUnmarshaller unmarschaller = new ProcessUnmarshaller();
            JPDL32ProcessDefinition jaxbProc = unmarschaller.unmarshallProcess(new InputStreamReader(pURL.openStream()));
            Process proc = new ProcessDefinitionAdapter().adaptProcessDefinition(jaxbProc);
            return proc;
        }
        catch (JAXBException ex) {
            throw new InvalidProcessException("Cannot unmarschall: " + pURL, (Throwable)ex);
        }
    }

    public void marshallProcess(Process proc, Writer out) throws IOException {
        throw new NotImplementedException("JBPM-1638", "DialectHandler jPDL3.2 marshallProcess");
    }
}

