/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.dialect.stp;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Writer;
import java.net.URL;
import javax.xml.bind.JAXBException;
import org.jboss.bpm.InvalidProcessException;
import org.jboss.bpm.NotImplementedException;
import org.jboss.bpm.client.DialectHandler;
import org.jboss.bpm.dialect.stp.ProcessUnmarshaller;
import org.jboss.bpm.model.Process;

public class DialectHandlerImpl
implements DialectHandler {
    public static final String NAMESPACE_URI = "http://stp.eclipse.org/bpmn";

    public String getNamespaceURI() {
        return NAMESPACE_URI;
    }

    public Process createProcess(String pXML, boolean isInclude) {
        try {
            ProcessUnmarshaller unmarschaller = new ProcessUnmarshaller();
            Process proc = unmarschaller.unmarshallProcess(new ByteArrayInputStream(pXML.getBytes()), isInclude);
            return proc;
        }
        catch (JAXBException ex) {
            throw new InvalidProcessException("Cannot unmarschall: " + pXML, (Throwable)ex);
        }
    }

    public Process createProcess(URL pURL, boolean isInclude) throws IOException {
        try {
            ProcessUnmarshaller unmarschaller = new ProcessUnmarshaller();
            Process proc = unmarschaller.unmarshallProcess(pURL.openStream(), isInclude);
            return proc;
        }
        catch (JAXBException ex) {
            throw new InvalidProcessException("Cannot unmarschall: " + pURL, (Throwable)ex);
        }
    }

    public void marshallProcess(Process proc, Writer out) throws IOException {
        throw new NotImplementedException("JBPM-1639", "DialectHandler STP marshallProcess");
    }
}

