/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.dialect.xpdl21;

// $Id: WorkflowProcessAdapter.java 1864 2008-08-11 10:56:42Z thomas.diesler@jboss.com $

import org.jboss.bpm.InvalidProcessException;
import org.jboss.bpm.dialect.xpdl21.model.XPDLActivities;
import org.jboss.bpm.dialect.xpdl21.model.XPDLActivity;
import org.jboss.bpm.dialect.xpdl21.model.XPDLEvent;
import org.jboss.bpm.dialect.xpdl21.model.XPDLWorkflowProcess;
import org.jboss.bpm.model.Process;
import org.jboss.bpm.model.ProcessBuilder;
import org.jboss.bpm.model.ProcessBuilderFactory;

/**
 * Adapt the jpdl-3.2 ProcessDefinition to the API Process
 * 
 * @author thomas.diesler@jboss.com
 * @since 18-Jun-2008
 */
public class WorkflowProcessAdapter
{
  public Process adaptWorkflowProcess(XPDLWorkflowProcess xpdlProc)
  {
    ProcessBuilder builder = ProcessBuilderFactory.newInstance().newProcessBuilder();
    builder.addProcess(xpdlProc.getName());
    
    XPDLActivities xpdlActivities = xpdlProc.getActivities();
    for (XPDLActivity xpdlActivity : xpdlActivities.getActivity())
    {
      XPDLEvent xpdlEvent = xpdlActivity.getEvent();
      if (xpdlEvent != null)
      {
        if (xpdlEvent.getStartEvent() != null)
        {
          builder.addStartEvent("Start");
        }
        else if (xpdlEvent.getEndEvent() != null)
        {
          builder.addEndEvent(xpdlActivity.getName());
        }
        else
        {
          throw new InvalidProcessException("Unsupported type: " + xpdlEvent);
        }
      }
      else
      {
        throw new InvalidProcessException("Unsupported type: " + xpdlActivity);
      }
    }

    Process proc = builder.getProcess();
    return proc;
  }
}
