/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.ri.model.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.bpm.model.Expression;
import org.jboss.bpm.model.FlowObject;
import org.jboss.bpm.model.Gate;
import org.jboss.bpm.model.Gateway;
import org.jboss.bpm.model.InclusiveGateway;
import org.jboss.bpm.model.SequenceFlow;
import org.jboss.bpm.ri.model.impl.GatewayImpl;
import org.jboss.bpm.runtime.Attachments;
import org.jboss.bpm.runtime.ExecutionContext;
import org.jboss.bpm.runtime.Token;
import org.jboss.bpm.runtime.TokenExecutor;
import org.mvel.MVEL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InclusiveGatewayImpl
extends GatewayImpl
implements InclusiveGateway {
    private static final Log log = LogFactory.getLog(InclusiveGatewayImpl.class);

    public InclusiveGatewayImpl(String name) {
        super(name);
    }

    public Gateway.GatewayType getGatewayType() {
        return Gateway.GatewayType.Inclusive;
    }

    @Override
    protected void defaultFlowHandler(TokenExecutor tokenExecutor, Token token) {
        FlowObject sourceRef = token.getFlow().getSourceRef();
        log.debug((Object)("Propagate token comming from: " + sourceRef));
        List<Gate> applicableGates = this.getApplicableGates(token);
        log.debug((Object)("applicableGates: " + applicableGates));
        if (applicableGates.size() == 1) {
            SequenceFlow outFlow = applicableGates.get(0).getOutgoingSequenceFlow();
            tokenExecutor.move(token, outFlow);
        } else {
            ArrayList<Token> outTokens = new ArrayList<Token>();
            for (Gate aux : applicableGates) {
                SequenceFlow outFlow = aux.getOutgoingSequenceFlow();
                Token outToken = token.copyToken();
                tokenExecutor.create(outToken, outFlow);
                outTokens.add(outToken);
            }
            for (Token outToken : outTokens) {
                tokenExecutor.start(outToken);
            }
        }
        if (applicableGates.size() > 1) {
            tokenExecutor.destroy(token);
        }
    }

    private List<Gate> getApplicableGates(Token token) {
        Gate auxGate;
        SequenceFlow seqFlow;
        SequenceFlow seqFlow2;
        ArrayList<Gate> applicableGates = new ArrayList<Gate>();
        for (Gate auxGate2 : this.getGates()) {
            seqFlow2 = auxGate2.getOutgoingSequenceFlow();
            if (seqFlow2.getConditionType() != SequenceFlow.ConditionType.Expression) continue;
            Expression expr = seqFlow2.getConditionExpression();
            if (expr.getExpressionLanguage() == Expression.ExpressionLanguage.MVEL) {
                String mvel = expr.getExpressionBody();
                ExecutionContext exContext = token.getExecutionContext();
                HashMap<String, Object> vars = new HashMap<String, Object>();
                for (Attachments.Key key : exContext.getAttachmentKeys()) {
                    String name = key.getNamePart();
                    Object value = exContext.getAttachment(name);
                    vars.put(name, value);
                }
                Boolean result = (Boolean)MVEL.eval((String)mvel, vars);
                if (!result.booleanValue()) continue;
                applicableGates.add(auxGate2);
                continue;
            }
            throw new IllegalStateException("Unsupported expression language: " + expr.getExpressionLanguage());
        }
        if (applicableGates.size() == 0) {
            for (Gate auxGate2 : this.getGates()) {
                seqFlow2 = auxGate2.getOutgoingSequenceFlow();
                if (seqFlow2.getConditionType() != SequenceFlow.ConditionType.Default) continue;
                applicableGates.add(auxGate2);
            }
        }
        if (applicableGates.size() == 0 && this.getGates().size() == 1 && (seqFlow = (auxGate = this.getGates().get(0)).getOutgoingSequenceFlow()).getConditionType() == SequenceFlow.ConditionType.None) {
            applicableGates.add(auxGate);
        }
        if (applicableGates.size() == 0) {
            throw new IllegalStateException("Cannot select applicable gate in: " + this);
        }
        return applicableGates;
    }

    public String toString() {
        return "InclusiveGateway[" + this.getName() + "]";
    }
}

