/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.ri.model.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.bpm.model.ConnectingObject;
import org.jboss.bpm.model.Gate;
import org.jboss.bpm.model.Gateway;
import org.jboss.bpm.model.ParallelGateway;
import org.jboss.bpm.model.SequenceFlow;
import org.jboss.bpm.ri.model.impl.GatewayImpl;
import org.jboss.bpm.ri.runtime.TokenImpl;
import org.jboss.bpm.runtime.Token;
import org.jboss.bpm.runtime.TokenExecutor;

public class ParallelGatewayImpl
extends GatewayImpl
implements ParallelGateway {
    private static final Log log = LogFactory.getLog(ParallelGatewayImpl.class);
    private Set<ConnectingObject> outstandingFlows;
    private Set<Token> mergeTokens;

    public ParallelGatewayImpl(String name) {
        super(name);
    }

    public Gateway.GatewayType getGatewayType() {
        return Gateway.GatewayType.Parallel;
    }

    public void defaultExecution(Token token) {
        super.defaultExecution(token);
        if (this.outstandingFlows == null) {
            this.outstandingFlows = new HashSet<ConnectingObject>(this.inFlows);
            this.mergeTokens = new HashSet<Token>();
        }
        SequenceFlow flow = token.getFlow();
        this.outstandingFlows.remove(flow);
        this.mergeTokens.add(token);
    }

    protected void defaultFlowHandler(TokenExecutor tokenExecutor, Token token) {
        Token outToken;
        tokenExecutor.suspend(token);
        Object object = outToken = this.getInFlows().size() == 1 ? token : null;
        if (outToken == null) {
            if (this.outstandingFlows.size() == 0) {
                outToken = this.getMergedTokens();
            } else if (this.outstandingFlows.size() > 0) {
                log.debug((Object)("Waiting for " + this.outstandingFlows + " in gateway: " + this));
            }
        }
        if (outToken != null) {
            ArrayList<Token> outTokens = new ArrayList<Token>();
            for (Gate gate : this.getGates()) {
                SequenceFlow outFlow = gate.getOutgoingSequenceFlow();
                outToken = outToken.copyToken();
                tokenExecutor.create(outToken, outFlow);
                outTokens.add(outToken);
            }
            for (Token auxToken : outTokens) {
                tokenExecutor.start(auxToken);
            }
            for (Token auxToken : this.receivedTokens) {
                tokenExecutor.destroy(auxToken);
            }
            this.reset();
        }
    }

    public void reset() {
        super.reset();
        this.outstandingFlows = null;
        this.mergeTokens = null;
    }

    private Token getMergedTokens() {
        TokenImpl mergedToken = new TokenImpl(null);
        for (Token auxToken : this.mergeTokens) {
            log.debug((Object)("mergeToken: " + auxToken));
            mergedToken.mergeToken(auxToken);
        }
        return mergedToken;
    }

    public String toString() {
        return "ParallelGateway[" + this.getName() + "]";
    }
}

