/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.ri.runtime;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.jboss.bpm.model.Activity;
import org.jboss.bpm.model.FlowObject;
import org.jboss.bpm.model.Process;
import org.jboss.bpm.model.Property;
import org.jboss.bpm.runtime.Attachments;
import org.jboss.bpm.runtime.ExecutionContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DelegatingExecutionContext
implements ExecutionContext {
    private FlowObject flowObject;
    private ExecutionContext delegate;
    private String activityPrefix;
    private String procPrefix;
    private Process proc;

    DelegatingExecutionContext(FlowObject flowObject, ExecutionContext delegate) {
        this.flowObject = flowObject;
        this.delegate = delegate;
        this.proc = flowObject.getProcess();
        this.procPrefix = this.proc.getName() + ".";
        this.activityPrefix = this.procPrefix + flowObject.getName() + ".";
    }

    public Object getAttachment(String name) {
        String key;
        Property prop;
        Object value = null;
        if (this.flowObject instanceof Activity && name.startsWith(this.activityPrefix)) {
            Activity activity = (Activity)this.flowObject;
            String key2 = name.substring(this.activityPrefix.length());
            Property prop2 = activity.getProperty(key2);
            if (prop2 != null) {
                value = prop2.getValue();
            }
        } else if (name.startsWith(this.procPrefix) && (prop = this.proc.getProperty(key = name.substring(this.procPrefix.length()))) != null) {
            value = prop.getValue();
        }
        if (value == null) {
            value = this.delegate.getAttachment(name);
        }
        return value;
    }

    public Collection<Attachments.Key> getAttachmentKeys() {
        ArrayList<Attachments.Key> keys = new ArrayList<Attachments.Key>(this.delegate.getAttachmentKeys());
        if (this.flowObject instanceof Activity) {
            Activity activity = (Activity)this.flowObject;
            for (Property prop : activity.getProperties()) {
                Attachments.Key key = new Attachments.Key(null, this.activityPrefix + prop.getName());
                keys.add(key);
            }
        }
        for (Property prop : this.proc.getProperties()) {
            Attachments.Key key = new Attachments.Key(null, this.procPrefix + prop.getName());
            keys.add(key);
        }
        return keys;
    }

    public <T> T getAttachment(Class<T> clazz) {
        return (T)this.delegate.getAttachment(clazz);
    }

    public <T> T getAttachment(Class<T> clazz, String name) {
        return (T)this.delegate.getAttachment(clazz, name);
    }

    public <T> T addAttachment(Class<T> clazz, Object value) {
        return (T)this.delegate.addAttachment(clazz, value);
    }

    public <T> T addAttachment(Class<T> clazz, String name, Object value) {
        this.validateAttachmentKey(name);
        return (T)this.delegate.addAttachment(clazz, name, value);
    }

    public Object addAttachment(String name, Object value) {
        this.validateAttachmentKey(name);
        return this.delegate.addAttachment(name, value);
    }

    public <T> T removeAttachment(Class<T> clazz) {
        return (T)this.delegate.removeAttachment(clazz);
    }

    public <T> T removeAttachment(Class<T> clazz, String name) {
        this.validateAttachmentKey(name);
        return (T)this.delegate.removeAttachment(clazz, name);
    }

    public Object removeAttachment(String name) {
        this.validateAttachmentKey(name);
        return this.delegate.removeAttachment(name);
    }

    private void validateAttachmentKey(String name) {
        if (name.startsWith(this.procPrefix) || name.startsWith(this.activityPrefix)) {
            throw new IllegalArgumentException("Invalid attachment key: " + name);
        }
    }

    public String toString() {
        HashMap<Attachments.Key, Object> combined = new HashMap<Attachments.Key, Object>();
        for (Attachments.Key key : this.getAttachmentKeys()) {
            if (key.getClassPart() != null) {
                combined.put(key, this.getAttachment(key.getClassPart(), key.getNamePart()));
                continue;
            }
            combined.put(key, this.getAttachment(key.getNamePart()));
        }
        return ((Object)combined).toString();
    }
}

