/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.constant_pool_scanner;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstantPoolScanner {
    public static Set<String> dependencies(byte[] data) throws IOException {
        return ConstantPoolScanner.dependencies(new ByteArrayInputStream(data));
    }

    public static Set<String> dependencies(InputStream in) throws IOException {
        int i;
        TreeSet<String> result = new TreeSet<String>();
        DataInputStream input = new DataInputStream(in);
        ConstantPoolScanner.skip(input, 8);
        int size = input.readUnsignedShort() - 1;
        String[] utf8Strings = new String[size];
        boolean[] isClassName = new boolean[size];
        boolean[] isDescriptor = new boolean[size];
        block8: for (i = 0; i < size; ++i) {
            byte tag = input.readByte();
            switch (tag) {
                case 1: {
                    utf8Strings[i] = input.readUTF();
                    continue block8;
                }
                case 7: {
                    int index = input.readUnsignedShort() - 1;
                    if (index >= size) {
                        throw new IOException("@" + i + ": CONSTANT_Class_info.name_index " + index + " too big for size of pool " + size);
                    }
                    isClassName[index] = true;
                    continue block8;
                }
                case 3: 
                case 4: 
                case 9: 
                case 10: 
                case 11: {
                    ConstantPoolScanner.skip(input, 4);
                    continue block8;
                }
                case 12: {
                    ConstantPoolScanner.skip(input, 2);
                    int index = input.readUnsignedShort() - 1;
                    if (index >= size || index < 0) {
                        throw new IOException("@" + i + ": CONSTANT_NameAndType_info.descriptor_index " + index + " too big for size of pool " + size);
                    }
                    isDescriptor[index] = true;
                    continue block8;
                }
                case 8: {
                    ConstantPoolScanner.skip(input, 2);
                    continue block8;
                }
                case 5: 
                case 6: {
                    ConstantPoolScanner.skip(input, 8);
                    ++i;
                    continue block8;
                }
                default: {
                    throw new IOException("Unrecognized constant pool tag " + tag + " at index " + i + "; running UTF-8 strings: " + Arrays.asList(utf8Strings));
                }
            }
        }
        for (i = 0; i < size; ++i) {
            String s = utf8Strings[i];
            if (isClassName[i]) {
                while (s.charAt(0) == '[') {
                    s = s.substring(1);
                }
                if (s.length() == 1) continue;
                String c = s.charAt(s.length() - 1) == ';' && s.charAt(0) == 'L' ? s.substring(1, s.length() - 1) : s;
                result.add(c.replace('/', '.'));
                continue;
            }
            if (!isDescriptor[i]) continue;
            int idx = 0;
            while ((idx = s.indexOf(76, idx)) != -1) {
                int semi = s.indexOf(59, idx);
                if (semi == -1) {
                    throw new IOException("Invalid type or descriptor: " + s);
                }
                result.add(s.substring(idx + 1, semi).replace('/', '.'));
                idx = semi;
            }
        }
        return result;
    }

    private static void skip(DataInput input, int bytes) throws IOException {
        int skipped = input.skipBytes(bytes);
        if (skipped != bytes) {
            throw new IOException("Truncated class file");
        }
    }

    private ConstantPoolScanner() {
    }
}

