/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.utils;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.DatatypeConverter;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.utils.JsLibrary;
import org.jetbrains.kotlin.utils.JsLibraryUtils;
import org.jetbrains.kotlin.utils.JsMetadataVersion;
import org.jetbrains.kotlin.utils.KotlinJavascriptMetadata;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0010!\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0004H\u0007J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0007J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0017\u001a\u00020\u0004H\u0007J\u001e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0011\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00140\u001cH\u0007J\u000e\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/utils/KotlinJavascriptMetadataUtils;", "", "()V", "JS_EXT", "", "JS_MAP_EXT", "KOTLIN_JAVASCRIPT_METHOD_NAME", "KOTLIN_JAVASCRIPT_METHOD_NAME_PATTERN", "Ljava/util/regex/Pattern;", "METADATA_PATTERN", "META_JS_SUFFIX", "formatMetadataAsString", "moduleName", "content", "", "hasMetadata", "", "text", "loadMetadata", "", "Lorg/jetbrains/kotlin/utils/KotlinJavascriptMetadata;", "file", "Ljava/io/File;", "path", "parseMetadata", "", "", "metadataList", "", "replaceSuffix", "filePath", "kotlin-compiler"})
public final class KotlinJavascriptMetadataUtils {
    @NotNull
    public static final String JS_EXT = ".js";
    @NotNull
    public static final String META_JS_SUFFIX = ".meta.js";
    @NotNull
    public static final String JS_MAP_EXT = ".js.map";
    private static final String KOTLIN_JAVASCRIPT_METHOD_NAME = "kotlin_module_metadata";
    private static final Pattern KOTLIN_JAVASCRIPT_METHOD_NAME_PATTERN;
    private static final Pattern METADATA_PATTERN;
    public static final KotlinJavascriptMetadataUtils INSTANCE;

    @NotNull
    public final String replaceSuffix(@NotNull String filePath) {
        Intrinsics.checkParameterIsNotNull(filePath, "filePath");
        return StringsKt.substringBeforeLast$default(filePath, JS_EXT, null, 2, null) + META_JS_SUFFIX;
    }

    @JvmStatic
    public static final boolean hasMetadata(@NotNull String text2) {
        Intrinsics.checkParameterIsNotNull(text2, "text");
        return KOTLIN_JAVASCRIPT_METHOD_NAME_PATTERN.matcher(text2).find() && METADATA_PATTERN.matcher(text2).find();
    }

    @NotNull
    public final String formatMetadataAsString(@NotNull String moduleName, @NotNull byte[] content) {
        Intrinsics.checkParameterIsNotNull(moduleName, "moduleName");
        Intrinsics.checkParameterIsNotNull(content, "content");
        return "// Kotlin." + KOTLIN_JAVASCRIPT_METHOD_NAME + '(' + JsMetadataVersion.INSTANCE.toInteger() + ", \"" + moduleName + "\", \"" + DatatypeConverter.printBase64Binary((byte[])content) + "\");\n";
    }

    @JvmStatic
    @NotNull
    public static final List<KotlinJavascriptMetadata> loadMetadata(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull(file, "file");
        boolean bl = file.exists();
        if (_Assertions.ENABLED && !bl) {
            String string = "Library " + file + " not found";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        ArrayList metadataList = new ArrayList();
        JsLibraryUtils.traverseJsLibrary(file, (Function1<? super JsLibrary, Unit>)new Function1<JsLibrary, Unit>(metadataList){
            final /* synthetic */ ArrayList $metadataList;

            public final void invoke(@NotNull JsLibrary library) {
                Intrinsics.checkParameterIsNotNull(library, "library");
                KotlinJavascriptMetadataUtils.parseMetadata(library.getContent(), this.$metadataList);
            }
            {
                this.$metadataList = arrayList;
                super(1);
            }
        });
        return metadataList;
    }

    @JvmStatic
    @NotNull
    public static final List<KotlinJavascriptMetadata> loadMetadata(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull(path, "path");
        return KotlinJavascriptMetadataUtils.loadMetadata(new File(path));
    }

    @JvmStatic
    public static final void parseMetadata(@NotNull CharSequence text2, @NotNull List<KotlinJavascriptMetadata> metadataList) {
        Intrinsics.checkParameterIsNotNull(text2, "text");
        Intrinsics.checkParameterIsNotNull(metadataList, "metadataList");
        if (!KOTLIN_JAVASCRIPT_METHOD_NAME_PATTERN.matcher(text2).find()) {
            return;
        }
        Matcher matcher = METADATA_PATTERN.matcher(text2);
        while (matcher.find()) {
            String string = matcher.group(1);
            JsMetadataVersion.Companion companion = JsMetadataVersion.Companion;
            int n = Integer.parseInt(string);
            JsMetadataVersion abiVersion = companion.fromInteger(n);
            String moduleName = matcher.group(3);
            String data2 = matcher.group(5);
            String string2 = moduleName;
            Intrinsics.checkExpressionValueIsNotNull(string2, "moduleName");
            byte[] byArray = DatatypeConverter.parseBase64Binary((String)data2);
            Intrinsics.checkExpressionValueIsNotNull(byArray, "parseBase64Binary(data)");
            metadataList.add(new KotlinJavascriptMetadata(abiVersion, string2, byArray));
        }
    }

    private KotlinJavascriptMetadataUtils() {
        INSTANCE = this;
        KOTLIN_JAVASCRIPT_METHOD_NAME = KOTLIN_JAVASCRIPT_METHOD_NAME;
        String string = "\\.kotlin_module_metadata\\(";
        int n = 0;
        Pattern pattern = Pattern.compile(string, n);
        Intrinsics.checkExpressionValueIsNotNull(pattern, "java.util.regex.Pattern.compile(this, flags)");
        KOTLIN_JAVASCRIPT_METHOD_NAME_PATTERN = pattern;
        string = "(?m)\\w+\\." + KOTLIN_JAVASCRIPT_METHOD_NAME + "\\((\\d+),\\s*(['\"])([^'\"]*)\\2,\\s*(['\"])([^'\"]*)\\4\\)";
        n = 0;
        Pattern pattern2 = Pattern.compile(string, n);
        Intrinsics.checkExpressionValueIsNotNull(pattern2, "java.util.regex.Pattern.compile(this, flags)");
        METADATA_PATTERN = pattern2;
    }

    static {
        new KotlinJavascriptMetadataUtils();
    }
}

