/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.graphInference;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDiamondType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.impl.source.resolve.ParameterTypeInferencePolicy;
import com.intellij.psi.impl.source.resolve.graphInference.CompoundInitialState;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceBound;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceVariable;
import com.intellij.psi.impl.source.resolve.graphInference.InitialInferenceState;
import com.intellij.psi.impl.source.resolve.graphInference.PsiPolyExpressionUtil;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.ExpressionCompatibilityConstraint;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InferenceSessionContainer {
    private static final Logger LOG = Logger.getInstance("#" + InferenceSessionContainer.class.getName());
    private final Map<PsiElement, InferenceSession> myNestedSessions = new HashMap<PsiElement, InferenceSession>();

    public void registerNestedSession(InferenceSession session) {
        this.myNestedSessions.put(session.getContext(), session);
        this.myNestedSessions.putAll(session.getInferenceSessionContainer().myNestedSessions);
    }

    @Contract(value="_, !null -> !null")
    public PsiSubstitutor findNestedSubstitutor(PsiElement arg, @Nullable PsiSubstitutor defaultSession) {
        InferenceSession session = this.myNestedSessions.get(PsiTreeUtil.getParentOfType(arg, PsiCall.class));
        return session == null ? defaultSession : session.getInferenceSubstitution();
    }

    void registerNestedSession(InferenceSession session, PsiType returnType, PsiExpression returnExpression) {
        InferenceSession inferenceSession;
        PsiSubstitutor callSession = this.findNestedSubstitutor(((PsiCallExpression)returnExpression).getArgumentList(), null);
        if (callSession == null && (inferenceSession = ExpressionCompatibilityConstraint.reduceExpressionCompatibilityConstraint(session, returnExpression, returnType, false)) != null && inferenceSession != session) {
            this.registerNestedSession(inferenceSession);
            session.propagateVariables(inferenceSession.getInferenceVariables(), inferenceSession.getRestoreNameSubstitution());
        }
    }

    static PsiSubstitutor infer(@NotNull PsiTypeParameter[] typeParameters2, @NotNull PsiParameter[] parameters2, @NotNull PsiExpression[] arguments2, @NotNull PsiSubstitutor partialSubstitutor, @NotNull PsiElement parent2, @NotNull ParameterTypeInferencePolicy policy) {
        PsiCall topLevelCall;
        PsiExpressionList argumentList2;
        MethodCandidateInfo.CurrentCandidateProperties properties2;
        if (typeParameters2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameters", "com/intellij/psi/impl/source/resolve/graphInference/InferenceSessionContainer", "infer"));
        }
        if (parameters2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/psi/impl/source/resolve/graphInference/InferenceSessionContainer", "infer"));
        }
        if (arguments2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "com/intellij/psi/impl/source/resolve/graphInference/InferenceSessionContainer", "infer"));
        }
        if (partialSubstitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "partialSubstitutor", "com/intellij/psi/impl/source/resolve/graphInference/InferenceSessionContainer", "infer"));
        }
        if (parent2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/psi/impl/source/resolve/graphInference/InferenceSessionContainer", "infer"));
        }
        if (policy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "policy", "com/intellij/psi/impl/source/resolve/graphInference/InferenceSessionContainer", "infer"));
        }
        if (parent2 instanceof PsiCall && (properties2 = MethodCandidateInfo.getCurrentMethod(argumentList2 = ((PsiCall)parent2).getArgumentList())) != null && !properties2.isApplicabilityCheck() && !MethodCandidateInfo.ourOverloadGuard.currentStack().contains(argumentList2) && (topLevelCall = PsiResolveHelper.ourGraphGuard.doPreventingRecursion(parent2, false, () -> {
            if (parent2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/psi/impl/source/resolve/graphInference/InferenceSessionContainer", "lambda$infer$0"));
            }
            if (parent2 instanceof PsiExpression && !PsiPolyExpressionUtil.isPolyExpression((PsiExpression)parent2)) {
                return null;
            }
            return LambdaUtil.treeWalkUp(parent2);
        })) != null) {
            InferenceSession session;
            if (MethodCandidateInfo.isOverloadCheck() || !PsiDiamondType.ourDiamondGuard.currentStack().isEmpty() || LambdaUtil.isLambdaParameterCheck()) {
                session = InferenceSessionContainer.startTopLevelInference(topLevelCall, policy);
            } else {
                Map<PsiElement, InferenceSession> sessions;
                InferenceSession childSession;
                session = (InferenceSession)CachedValuesManager.getCachedValue(topLevelCall, () -> {
                    if (policy == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "policy", "com/intellij/psi/impl/source/resolve/graphInference/InferenceSessionContainer", "lambda$infer$1"));
                    }
                    return new CachedValueProvider.Result<InferenceSession>(InferenceSessionContainer.startTopLevelInference(topLevelCall, policy), PsiModificationTracker.MODIFICATION_COUNT);
                });
                if (session != null && (childSession = (sessions = session.getInferenceSessionContainer().myNestedSessions).get(parent2)) != null) {
                    for (PsiTypeParameter parameter : typeParameters2) {
                        if (childSession.getInferenceSubstitution().getSubstitutionMap().containsKey(parameter)) continue;
                        session = InferenceSessionContainer.startTopLevelInference(topLevelCall, policy);
                        break;
                    }
                }
            }
            if (session != null) {
                PsiSubstitutor childSubstitutor = InferenceSessionContainer.inferNested(typeParameters2, parameters2, arguments2, partialSubstitutor, (PsiCall)parent2, policy, properties2, session);
                if (childSubstitutor != null) {
                    return childSubstitutor;
                }
            } else if (topLevelCall instanceof PsiMethodCallExpression) {
                return new InferenceSession(typeParameters2, partialSubstitutor, parent2.getManager(), parent2, policy).prepareSubstitution();
            }
        }
        InferenceSession inferenceSession = new InferenceSession(typeParameters2, partialSubstitutor, parent2.getManager(), parent2, policy);
        inferenceSession.initExpressionConstraints(parameters2, arguments2, parent2);
        return inferenceSession.infer(parameters2, arguments2, parent2);
    }

    private static PsiSubstitutor inferNested(PsiTypeParameter[] typeParameters2, @NotNull PsiParameter[] parameters2, @NotNull PsiExpression[] arguments2, PsiSubstitutor partialSubstitutor, @NotNull PsiCall parent2, @NotNull ParameterTypeInferencePolicy policy, @NotNull MethodCandidateInfo.CurrentCandidateProperties properties2, InferenceSession parentSession) {
        if (parameters2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/psi/impl/source/resolve/graphInference/InferenceSessionContainer", "inferNested"));
        }
        if (arguments2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "com/intellij/psi/impl/source/resolve/graphInference/InferenceSessionContainer", "inferNested"));
        }
        if (parent2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/psi/impl/source/resolve/graphInference/InferenceSessionContainer", "inferNested"));
        }
        if (policy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "policy", "com/intellij/psi/impl/source/resolve/graphInference/InferenceSessionContainer", "inferNested"));
        }
        if (properties2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/intellij/psi/impl/source/resolve/graphInference/InferenceSessionContainer", "inferNested"));
        }
        CompoundInitialState compoundInitialState = InferenceSessionContainer.createState(parentSession);
        InitialInferenceState initialInferenceState = compoundInitialState.getInitialState(parent2);
        if (initialInferenceState != null) {
            InferenceSession childSession = new InferenceSession(initialInferenceState);
            List<String> errorMessages = parentSession.getIncompatibleErrorMessages();
            if (errorMessages != null) {
                properties2.getInfo().setInferenceError(StringUtil.join(errorMessages, "\n"));
                return childSession.prepareSubstitution();
            }
            return childSession.collectAdditionalAndInfer(parameters2, arguments2, properties2, compoundInitialState.getInitialSubstitutor());
        }
        PsiElement gParent = PsiUtil.skipParenthesizedExprUp(parent2.getParent());
        while (true) {
            PsiCall call2;
            PsiElement returnContainer;
            if (gParent instanceof PsiReturnStatement && (returnContainer = gParent.getParent()) instanceof PsiCodeBlock) {
                gParent = returnContainer.getParent();
            }
            if (!(gParent instanceof PsiLambdaExpression) || (call2 = PsiTreeUtil.getParentOfType(gParent, PsiCall.class)) == null) break;
            initialInferenceState = compoundInitialState.getInitialState(call2);
            if (initialInferenceState != null) {
                PsiExpressionList argumentList2 = call2.getArgumentList();
                int idx = LambdaUtil.getLambdaIdx(argumentList2, gParent);
                JavaResolveResult result2 = call2.resolveMethodGenerics();
                PsiElement method = result2.getElement();
                if (!(method instanceof PsiMethod) || idx <= -1) break;
                LOG.assertTrue(argumentList2 != null);
                PsiParameter[] methodParameters = ((PsiMethod)method).getParameterList().getParameters();
                if (methodParameters.length == 0) break;
                PsiType parameterType = PsiTypesUtil.getParameterType(methodParameters, idx, true);
                PsiType parameterTypeInTermsOfSession = initialInferenceState.getInferenceSubstitutor().substitute(parameterType);
                PsiType lambdaTargetType = compoundInitialState.getInitialSubstitutor().substitute(parameterTypeInTermsOfSession);
                if (call2.equals(PsiTreeUtil.getParentOfType((PsiElement)parent2, PsiCall.class, true))) {
                    return LambdaUtil.performWithLambdaTargetType((PsiLambdaExpression)gParent, partialSubstitutor.substitute(lambdaTargetType), () -> {
                        if (parent2 == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/psi/impl/source/resolve/graphInference/InferenceSessionContainer", "lambda$inferNested$2"));
                        }
                        if (policy == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "policy", "com/intellij/psi/impl/source/resolve/graphInference/InferenceSessionContainer", "lambda$inferNested$2"));
                        }
                        if (parameters2 == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/psi/impl/source/resolve/graphInference/InferenceSessionContainer", "lambda$inferNested$2"));
                        }
                        if (arguments2 == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "com/intellij/psi/impl/source/resolve/graphInference/InferenceSessionContainer", "lambda$inferNested$2"));
                        }
                        InferenceSession inferenceSession = new InferenceSession(typeParameters2, partialSubstitutor, parent2.getManager(), parent2, policy);
                        inferenceSession.initExpressionConstraints(parameters2, arguments2, parent2);
                        return inferenceSession.infer(parameters2, arguments2, parent2);
                    });
                }
                InferenceSession sessionInsideLambda = new InferenceSession(initialInferenceState);
                sessionInsideLambda.collectAdditionalAndInfer(methodParameters, argumentList2.getExpressions(), ((MethodCandidateInfo)result2).createProperties(), compoundInitialState.getInitialSubstitutor());
                return InferenceSessionContainer.inferNested(typeParameters2, parameters2, arguments2, partialSubstitutor, parent2, policy, properties2, sessionInsideLambda);
            }
            gParent = PsiUtil.skipParenthesizedExprUp(call2.getParent());
        }
        return null;
    }

    private static CompoundInitialState createState(InferenceSession topLevelSession) {
        PsiSubstitutor topInferenceSubstitutor = InferenceSessionContainer.replaceVariables(topLevelSession.getInferenceVariables());
        final LinkedHashMap<PsiElement, InitialInferenceState> nestedStates = new LinkedHashMap<PsiElement, InitialInferenceState>();
        InferenceSessionContainer copy = new InferenceSessionContainer(){

            @Override
            public PsiSubstitutor findNestedSubstitutor(PsiElement arg, @Nullable PsiSubstitutor defaultSession) {
                PsiSubstitutor substitutor2 = super.findNestedSubstitutor(arg, null);
                if (substitutor2 != null) {
                    return substitutor2;
                }
                InitialInferenceState state2 = (InitialInferenceState)nestedStates.get(PsiTreeUtil.getParentOfType(arg, PsiCall.class));
                if (state2 != null) {
                    return state2.getInferenceSubstitutor();
                }
                return super.findNestedSubstitutor(arg, defaultSession);
            }
        };
        Map<PsiElement, InferenceSession> nestedSessions = topLevelSession.getInferenceSessionContainer().myNestedSessions;
        for (Map.Entry<PsiElement, InferenceSession> entry : nestedSessions.entrySet()) {
            nestedStates.put(entry.getKey(), entry.getValue().createInitialState(copy, topLevelSession.getInferenceVariables(), topInferenceSubstitutor));
        }
        PsiSubstitutor substitutor2 = PsiSubstitutor.EMPTY;
        for (InferenceVariable variable : topLevelSession.getInferenceVariables()) {
            PsiClass psiClass;
            PsiType instantiation = variable.getInstantiation();
            if (instantiation == PsiType.NULL || !((psiClass = PsiUtil.resolveClassInClassTypeOnly(topInferenceSubstitutor.substitute(variable))) instanceof InferenceVariable)) continue;
            substitutor2 = substitutor2.put((PsiTypeParameter)psiClass, instantiation);
        }
        return new CompoundInitialState(substitutor2, nestedStates);
    }

    @Nullable
    private static InferenceSession startTopLevelInference(PsiCall topLevelCall, ParameterTypeInferencePolicy policy) {
        JavaResolveResult result2 = topLevelCall.resolveMethodGenerics();
        if (result2 instanceof MethodCandidateInfo) {
            PsiMethod method = ((MethodCandidateInfo)result2).getElement();
            PsiParameter[] topLevelParameters = method.getParameterList().getParameters();
            PsiExpressionList topLevelCallArgumentList = topLevelCall.getArgumentList();
            LOG.assertTrue(topLevelCallArgumentList != null, topLevelCall);
            PsiExpression[] topLevelArguments = topLevelCallArgumentList.getExpressions();
            return PsiResolveHelper.ourGraphGuard.doPreventingRecursion(topLevelCall, true, () -> {
                InferenceSession topLevelSession = new InferenceSession(method.getTypeParameters(), ((MethodCandidateInfo)result2).getSiteSubstitutor(), topLevelCall.getManager(), topLevelCall, policy);
                topLevelSession.initExpressionConstraints(topLevelParameters, topLevelArguments, topLevelCall, method, ((MethodCandidateInfo)result2).isVarargs());
                topLevelSession.infer(topLevelParameters, topLevelArguments, topLevelCall, ((MethodCandidateInfo)result2).createProperties());
                return topLevelSession;
            });
        }
        return null;
    }

    @NotNull
    private static PsiSubstitutor replaceVariables(Collection<InferenceVariable> inferenceVariables) {
        InferenceVariable[] oldVars;
        ArrayList<InferenceVariable> targetVars = new ArrayList<InferenceVariable>();
        PsiSubstitutor substitutor2 = PsiSubstitutor.EMPTY;
        for (InferenceVariable variable : oldVars = inferenceVariables.toArray(new InferenceVariable[inferenceVariables.size()])) {
            InferenceVariable newVariable = new InferenceVariable(variable.getCallContext(), variable.getParameter(), variable.getName());
            substitutor2 = substitutor2.put(variable, JavaPsiFacade.getElementFactory(variable.getProject()).createType(newVariable));
            targetVars.add(newVariable);
            if (!variable.isThrownBound()) continue;
            newVariable.setThrownBound();
        }
        for (int i = 0; i < targetVars.size(); ++i) {
            InferenceVariable var = (InferenceVariable)targetVars.get(i);
            for (InferenceBound boundType : InferenceBound.values()) {
                for (PsiType bound : oldVars[i].getBounds(boundType)) {
                    var.addBound(substitutor2.substitute(bound), boundType, null);
                }
            }
        }
        PsiSubstitutor psiSubstitutor = substitutor2;
        if (psiSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/graphInference/InferenceSessionContainer", "replaceVariables"));
        }
        return psiSubstitutor;
    }
}

