/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.maven;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.maven.plugin.MojoExecutionException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.maven.kapt.AnnotationProcessingManager;

public class Util {
    static List<String> filterClassPath(File basedir, List<String> classpath) {
        return classpath.stream().filter(s -> new File((String)s).exists() || new File(basedir, (String)s).exists()).collect(Collectors.toList());
    }

    @NotNull
    public static String[] joinArrays(@Nullable String[] first, @Nullable String[] second) {
        if (first == null) {
            first = new String[]{};
        }
        if (second == null) {
            second = new String[]{};
        }
        String[] result = new String[first.length + second.length];
        System.arraycopy(first, 0, result, 0, first.length);
        System.arraycopy(second, 0, result, first.length, second.length);
        return result;
    }

    @NotNull
    public static String getMavenPluginVersion() throws MojoExecutionException {
        ClassLoader classLoader = AnnotationProcessingManager.class.getClassLoader();
        InputStream pomPropertiesIs = classLoader.getResourceAsStream("META-INF/maven/org.jetbrains.kotlin/kotlin-maven-plugin/pom.properties");
        if (pomPropertiesIs == null) {
            throw new MojoExecutionException("Can't resolve the version of kotlin-maven-plugin");
        }
        Properties properties = new Properties();
        try {
            properties.load(pomPropertiesIs);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error while reading kotlin-maven-plugin/pom.properties", (Exception)e);
        }
        return properties.getProperty("version");
    }
}

