/*
 * Decompiled with CFR 0.152.
 */
package jodd.mail;

import com.sun.mail.imap.IMAPSSLStore;
import java.util.Properties;
import javax.mail.NoSuchProviderException;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.URLName;
import jodd.mail.ImapServer;

public class ImapSslServer
extends ImapServer {
    protected static final String MAIL_IMAP_SOCKET_FACTORY_PORT = "mail.imap.socketFactory.port";
    protected static final String MAIL_IMAP_SOCKET_FACTORY_CLASS = "mail.imap.socketFactory.class";
    protected static final String MAIL_IMAP_SOCKET_FACTORY_FALLBACK = "mail.imap.socketFactory.fallback";
    protected static final int DEFAULT_SSL_PORT = 993;
    protected final String username;
    protected final String password;

    public ImapSslServer(String host, String username, String password) {
        this(host, 993, username, password);
    }

    public ImapSslServer(String host, int port, String username, String password) {
        super(host, port, username, password);
        this.username = username;
        this.password = password;
    }

    @Override
    public ImapSslServer setProperty(String name, String value) {
        super.setProperty(name, value);
        return this;
    }

    @Override
    protected Properties createSessionProperties() {
        Properties props = new Properties();
        props.setProperty("mail.imap.port", String.valueOf(this.port));
        props.setProperty(MAIL_IMAP_SOCKET_FACTORY_PORT, String.valueOf(this.port));
        props.setProperty("mail.imap.partialfetch", "false");
        props.setProperty(MAIL_IMAP_SOCKET_FACTORY_CLASS, "javax.net.ssl.SSLSocketFactory");
        props.setProperty(MAIL_IMAP_SOCKET_FACTORY_FALLBACK, "false");
        return props;
    }

    @Override
    protected Store getStore(Session session) throws NoSuchProviderException {
        URLName url = new URLName("imap", this.host, this.port, "", this.username, this.password);
        return new IMAPSSLStore(session, url);
    }
}

