/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.CallBase;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.NoResultCallInstr;
import org.jruby.ir.instructions.ResultInstr;
import org.jruby.ir.instructions.specialized.OneFixnumArgNoBlockCallInstr;
import org.jruby.ir.instructions.specialized.OneOperandArgNoBlockCallInstr;
import org.jruby.ir.instructions.specialized.ZeroOperandArgNoBlockCallInstr;
import org.jruby.ir.operands.MethAddr;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.transformations.inlining.InlinerInfo;
import org.jruby.runtime.CallType;

public class CallInstr
extends CallBase
implements ResultInstr {
    protected Variable result;

    public static CallInstr create(Variable result2, MethAddr methAddr, Operand receiver2, Operand[] args2, Operand closure) {
        return new CallInstr(CallType.NORMAL, result2, methAddr, receiver2, args2, closure);
    }

    public static CallInstr create(CallType callType, Variable result2, MethAddr methAddr, Operand receiver2, Operand[] args2, Operand closure) {
        return new CallInstr(callType, result2, methAddr, receiver2, args2, closure);
    }

    public CallInstr(CallType callType, Variable result2, MethAddr methAddr, Operand receiver2, Operand[] args2, Operand closure) {
        this(Operation.CALL, callType, result2, methAddr, receiver2, args2, closure);
    }

    protected CallInstr(Operation op, CallType callType, Variable result2, MethAddr methAddr, Operand receiver2, Operand[] args2, Operand closure) {
        super(op, callType, methAddr, receiver2, args2, closure);
        assert (result2 != null);
        this.result = result2;
    }

    public CallInstr(Operation op, CallInstr ordinary) {
        this(op, ordinary.getCallType(), ordinary.getResult(), ordinary.getMethodAddr(), ordinary.getReceiver(), ordinary.getCallArgs(), ordinary.getClosureArg(null));
    }

    @Override
    public Variable getResult() {
        return this.result;
    }

    @Override
    public void updateResult(Variable v) {
        this.result = v;
    }

    @Override
    public CallBase specializeForInterpretation() {
        Operand[] callArgs = this.getCallArgs();
        if (this.hasClosure() || CallInstr.containsSplat(callArgs)) {
            return this;
        }
        switch (callArgs.length) {
            case 0: {
                return new ZeroOperandArgNoBlockCallInstr(this);
            }
            case 1: {
                if (this.isAllFixnums()) {
                    return new OneFixnumArgNoBlockCallInstr(this);
                }
                return new OneOperandArgNoBlockCallInstr(this);
            }
        }
        return this;
    }

    public Instr discardResult() {
        return new NoResultCallInstr(Operation.NORESULT_CALL, this.getCallType(), this.getMethodAddr(), this.getReceiver(), this.getCallArgs(), this.closure);
    }

    @Override
    public Instr cloneForInlining(InlinerInfo ii) {
        return new CallInstr(this.getCallType(), ii.getRenamedVariable(this.result), (MethAddr)this.getMethodAddr().cloneForInlining(ii), this.receiver.cloneForInlining(ii), this.cloneCallArgs(ii), this.closure == null ? null : this.closure.cloneForInlining(ii));
    }

    @Override
    public String toString() {
        return (this.hasUnusedResult() ? "[DEAD-RESULT]" : "") + this.result + " = " + super.toString();
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.CallInstr(this);
    }
}

