/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params;

import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import org.jspecify.annotations.Nullable;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.ArgumentCountValidator;
import org.junit.jupiter.params.DefaultParameterInfo;
import org.junit.jupiter.params.EvaluatedArgumentSet;
import org.junit.jupiter.params.ParameterizedDeclarationContext;
import org.junit.jupiter.params.ParameterizedInvocationNameFormatter;
import org.junit.jupiter.params.ParameterizedTestInvocationContext;
import org.junit.jupiter.params.ResolverFacade;
import org.junit.jupiter.params.aggregator.DefaultArgumentsAccessor;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.support.ParameterDeclarations;
import org.junit.platform.commons.util.ClassLoaderUtils;

class ParameterizedInvocationContext<T extends ParameterizedDeclarationContext<?>> {
    private static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{ParameterizedTestInvocationContext.class});
    protected final T declarationContext;
    private final ParameterizedInvocationNameFormatter formatter;
    protected final EvaluatedArgumentSet arguments;
    protected final int invocationIndex;

    ParameterizedInvocationContext(T declarationContext, ParameterizedInvocationNameFormatter formatter, Arguments arguments, int invocationIndex) {
        this.declarationContext = declarationContext;
        this.formatter = formatter;
        ResolverFacade resolverFacade = this.declarationContext.getResolverFacade();
        this.arguments = EvaluatedArgumentSet.of(arguments, resolverFacade::determineConsumedArgumentLength);
        this.invocationIndex = invocationIndex;
    }

    public String getDisplayName(int invocationIndex) {
        return this.formatter.format(invocationIndex, this.arguments);
    }

    public void prepareInvocation(ExtensionContext context) {
        if (this.declarationContext.isAutoClosingArguments()) {
            this.registerAutoCloseableArgumentsInStoreForClosing(context);
        }
        this.validateArgumentCount(context);
        this.storeParameterInfo(context);
    }

    private void registerAutoCloseableArgumentsInStoreForClosing(ExtensionContext context) {
        ExtensionContext.Store store = context.getStore(NAMESPACE);
        AtomicInteger argumentIndex = new AtomicInteger();
        Arrays.stream(this.arguments.getAllPayloads()).filter(AutoCloseable.class::isInstance).map(AutoCloseable.class::cast).map(CloseableArgument::new).forEach(closeable -> store.put((Object)argumentIndex.incrementAndGet(), closeable));
    }

    private void validateArgumentCount(ExtensionContext context) {
        new ArgumentCountValidator((ParameterizedDeclarationContext<?>)this.declarationContext, this.arguments).validate(context);
    }

    private void storeParameterInfo(ExtensionContext context) {
        ParameterDeclarations declarations = this.declarationContext.getResolverFacade().getIndexedParameterDeclarations();
        ClassLoader classLoader = ClassLoaderUtils.getClassLoader(this.declarationContext.getTestClass());
        @Nullable Object[] arguments = this.arguments.getConsumedPayloads();
        DefaultArgumentsAccessor accessor = DefaultArgumentsAccessor.create(this.invocationIndex, classLoader, arguments);
        new DefaultParameterInfo(declarations, accessor).store(context);
    }

    private record CloseableArgument(AutoCloseable autoCloseable) implements ExtensionContext.Store.CloseableResource,
    AutoCloseable
    {
        @Override
        public void close() throws Exception {
            this.autoCloseable.close();
        }
    }
}

