/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.consul.model.acl;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import jakarta.annotation.Nullable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;
import org.kiwiproject.consul.model.acl.BaseRoleResponse;
import org.kiwiproject.consul.model.acl.Role;
import org.kiwiproject.consul.model.acl.RoleResponse;

@JsonIgnoreProperties(ignoreUnknown=true)
@Generated(from="RoleResponse", generator="Immutables")
public final class ImmutableRoleResponse
extends RoleResponse {
    private final String id;
    private final String name;
    private final String description;
    private final ImmutableList<Role.RolePolicyLink> policies;
    private final ImmutableList<Role.RoleServiceIdentity> serviceIdentities;
    private final ImmutableList<Role.RoleNodeIdentity> nodeIdentities;
    private final BigInteger createIndex;
    private final BigInteger modifyIndex;
    private final String hash;

    private ImmutableRoleResponse(String id, String name, String description, ImmutableList<Role.RolePolicyLink> policies, ImmutableList<Role.RoleServiceIdentity> serviceIdentities, ImmutableList<Role.RoleNodeIdentity> nodeIdentities, BigInteger createIndex, BigInteger modifyIndex, String hash) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.policies = policies;
        this.serviceIdentities = serviceIdentities;
        this.nodeIdentities = nodeIdentities;
        this.createIndex = createIndex;
        this.modifyIndex = modifyIndex;
        this.hash = hash;
    }

    @Override
    @JsonProperty(value="ID")
    public String id() {
        return this.id;
    }

    @Override
    @JsonProperty(value="Name")
    public String name() {
        return this.name;
    }

    @Override
    @JsonProperty(value="Description")
    public String description() {
        return this.description;
    }

    @JsonProperty(value="Policies")
    public ImmutableList<Role.RolePolicyLink> policies() {
        return this.policies;
    }

    @JsonProperty(value="ServiceIdentities")
    public ImmutableList<Role.RoleServiceIdentity> serviceIdentities() {
        return this.serviceIdentities;
    }

    @JsonProperty(value="NodeIdentities")
    public ImmutableList<Role.RoleNodeIdentity> nodeIdentities() {
        return this.nodeIdentities;
    }

    @Override
    @JsonProperty(value="CreateIndex")
    public BigInteger createIndex() {
        return this.createIndex;
    }

    @Override
    @JsonProperty(value="ModifyIndex")
    public BigInteger modifyIndex() {
        return this.modifyIndex;
    }

    @Override
    @JsonProperty(value="Hash")
    public String hash() {
        return this.hash;
    }

    public final ImmutableRoleResponse withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new ImmutableRoleResponse(newValue, this.name, this.description, this.policies, this.serviceIdentities, this.nodeIdentities, this.createIndex, this.modifyIndex, this.hash);
    }

    public final ImmutableRoleResponse withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableRoleResponse(this.id, newValue, this.description, this.policies, this.serviceIdentities, this.nodeIdentities, this.createIndex, this.modifyIndex, this.hash);
    }

    public final ImmutableRoleResponse withDescription(String value) {
        String newValue = Objects.requireNonNull(value, "description");
        if (this.description.equals(newValue)) {
            return this;
        }
        return new ImmutableRoleResponse(this.id, this.name, newValue, this.policies, this.serviceIdentities, this.nodeIdentities, this.createIndex, this.modifyIndex, this.hash);
    }

    public final ImmutableRoleResponse withPolicies(Role.RolePolicyLink ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableRoleResponse(this.id, this.name, this.description, (ImmutableList<Role.RolePolicyLink>)newValue, this.serviceIdentities, this.nodeIdentities, this.createIndex, this.modifyIndex, this.hash);
    }

    public final ImmutableRoleResponse withPolicies(Iterable<? extends Role.RolePolicyLink> elements) {
        if (this.policies == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableRoleResponse(this.id, this.name, this.description, (ImmutableList<Role.RolePolicyLink>)newValue, this.serviceIdentities, this.nodeIdentities, this.createIndex, this.modifyIndex, this.hash);
    }

    public final ImmutableRoleResponse withServiceIdentities(Role.RoleServiceIdentity ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableRoleResponse(this.id, this.name, this.description, this.policies, (ImmutableList<Role.RoleServiceIdentity>)newValue, this.nodeIdentities, this.createIndex, this.modifyIndex, this.hash);
    }

    public final ImmutableRoleResponse withServiceIdentities(Iterable<? extends Role.RoleServiceIdentity> elements) {
        if (this.serviceIdentities == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableRoleResponse(this.id, this.name, this.description, this.policies, (ImmutableList<Role.RoleServiceIdentity>)newValue, this.nodeIdentities, this.createIndex, this.modifyIndex, this.hash);
    }

    public final ImmutableRoleResponse withNodeIdentities(Role.RoleNodeIdentity ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableRoleResponse(this.id, this.name, this.description, this.policies, this.serviceIdentities, (ImmutableList<Role.RoleNodeIdentity>)newValue, this.createIndex, this.modifyIndex, this.hash);
    }

    public final ImmutableRoleResponse withNodeIdentities(Iterable<? extends Role.RoleNodeIdentity> elements) {
        if (this.nodeIdentities == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableRoleResponse(this.id, this.name, this.description, this.policies, this.serviceIdentities, (ImmutableList<Role.RoleNodeIdentity>)newValue, this.createIndex, this.modifyIndex, this.hash);
    }

    public final ImmutableRoleResponse withCreateIndex(BigInteger value) {
        BigInteger newValue = Objects.requireNonNull(value, "createIndex");
        if (this.createIndex.equals(newValue)) {
            return this;
        }
        return new ImmutableRoleResponse(this.id, this.name, this.description, this.policies, this.serviceIdentities, this.nodeIdentities, newValue, this.modifyIndex, this.hash);
    }

    public final ImmutableRoleResponse withModifyIndex(BigInteger value) {
        BigInteger newValue = Objects.requireNonNull(value, "modifyIndex");
        if (this.modifyIndex.equals(newValue)) {
            return this;
        }
        return new ImmutableRoleResponse(this.id, this.name, this.description, this.policies, this.serviceIdentities, this.nodeIdentities, this.createIndex, newValue, this.hash);
    }

    public final ImmutableRoleResponse withHash(String value) {
        String newValue = Objects.requireNonNull(value, "hash");
        if (this.hash.equals(newValue)) {
            return this;
        }
        return new ImmutableRoleResponse(this.id, this.name, this.description, this.policies, this.serviceIdentities, this.nodeIdentities, this.createIndex, this.modifyIndex, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRoleResponse && this.equalTo(0, (ImmutableRoleResponse)another);
    }

    private boolean equalTo(int synthetic, ImmutableRoleResponse another) {
        return this.id.equals(another.id) && this.name.equals(another.name) && this.description.equals(another.description) && this.policies.equals(another.policies) && this.serviceIdentities.equals(another.serviceIdentities) && this.nodeIdentities.equals(another.nodeIdentities) && this.createIndex.equals(another.createIndex) && this.modifyIndex.equals(another.modifyIndex) && this.hash.equals(another.hash);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.description.hashCode();
        h += (h << 5) + this.policies.hashCode();
        h += (h << 5) + this.serviceIdentities.hashCode();
        h += (h << 5) + this.nodeIdentities.hashCode();
        h += (h << 5) + this.createIndex.hashCode();
        h += (h << 5) + this.modifyIndex.hashCode();
        h += (h << 5) + this.hash.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"RoleResponse").omitNullValues().add("id", (Object)this.id).add("name", (Object)this.name).add("description", (Object)this.description).add("policies", this.policies).add("serviceIdentities", this.serviceIdentities).add("nodeIdentities", this.nodeIdentities).add("createIndex", (Object)this.createIndex).add("modifyIndex", (Object)this.modifyIndex).add("hash", (Object)this.hash).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableRoleResponse fromJson(Json json) {
        Builder builder = ImmutableRoleResponse.builder();
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.description != null) {
            builder.description(json.description);
        }
        if (json.policies != null) {
            builder.addAllPolicies(json.policies);
        }
        if (json.serviceIdentities != null) {
            builder.addAllServiceIdentities(json.serviceIdentities);
        }
        if (json.nodeIdentities != null) {
            builder.addAllNodeIdentities(json.nodeIdentities);
        }
        if (json.createIndex != null) {
            builder.createIndex(json.createIndex);
        }
        if (json.modifyIndex != null) {
            builder.modifyIndex(json.modifyIndex);
        }
        if (json.hash != null) {
            builder.hash(json.hash);
        }
        return builder.build();
    }

    public static ImmutableRoleResponse copyOf(RoleResponse instance) {
        if (instance instanceof ImmutableRoleResponse) {
            return (ImmutableRoleResponse)instance;
        }
        return ImmutableRoleResponse.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="RoleResponse", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_NAME = 2L;
        private static final long INIT_BIT_DESCRIPTION = 4L;
        private static final long INIT_BIT_CREATE_INDEX = 8L;
        private static final long INIT_BIT_MODIFY_INDEX = 16L;
        private static final long INIT_BIT_HASH = 32L;
        private long initBits = 63L;
        @Nullable
        private String id;
        @Nullable
        private String name;
        @Nullable
        private String description;
        private ImmutableList.Builder<Role.RolePolicyLink> policies = ImmutableList.builder();
        private ImmutableList.Builder<Role.RoleServiceIdentity> serviceIdentities = ImmutableList.builder();
        private ImmutableList.Builder<Role.RoleNodeIdentity> nodeIdentities = ImmutableList.builder();
        @Nullable
        private BigInteger createIndex;
        @Nullable
        private BigInteger modifyIndex;
        @Nullable
        private String hash;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(BaseRoleResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(RoleResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            if (object instanceof BaseRoleResponse) {
                BaseRoleResponse instance = (BaseRoleResponse)object;
                this.addAllNodeIdentities(instance.nodeIdentities());
                this.modifyIndex(instance.modifyIndex());
                this.addAllServiceIdentities(instance.serviceIdentities());
                this.addAllPolicies(instance.policies());
                this.name(instance.name());
                this.description(instance.description());
                this.id(instance.id());
                this.createIndex(instance.createIndex());
                this.hash(instance.hash());
            }
        }

        @JsonProperty(value="ID")
        @CanIgnoreReturnValue
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="Name")
        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="Description")
        @CanIgnoreReturnValue
        public final Builder description(String description) {
            this.description = Objects.requireNonNull(description, "description");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addPolicies(Role.RolePolicyLink element) {
            this.policies.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addPolicies(Role.RolePolicyLink ... elements) {
            this.policies.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="Policies")
        @CanIgnoreReturnValue
        public final Builder policies(Iterable<? extends Role.RolePolicyLink> elements) {
            this.policies = ImmutableList.builder();
            return this.addAllPolicies(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllPolicies(Iterable<? extends Role.RolePolicyLink> elements) {
            this.policies.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addServiceIdentities(Role.RoleServiceIdentity element) {
            this.serviceIdentities.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addServiceIdentities(Role.RoleServiceIdentity ... elements) {
            this.serviceIdentities.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="ServiceIdentities")
        @CanIgnoreReturnValue
        public final Builder serviceIdentities(Iterable<? extends Role.RoleServiceIdentity> elements) {
            this.serviceIdentities = ImmutableList.builder();
            return this.addAllServiceIdentities(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllServiceIdentities(Iterable<? extends Role.RoleServiceIdentity> elements) {
            this.serviceIdentities.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addNodeIdentities(Role.RoleNodeIdentity element) {
            this.nodeIdentities.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addNodeIdentities(Role.RoleNodeIdentity ... elements) {
            this.nodeIdentities.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="NodeIdentities")
        @CanIgnoreReturnValue
        public final Builder nodeIdentities(Iterable<? extends Role.RoleNodeIdentity> elements) {
            this.nodeIdentities = ImmutableList.builder();
            return this.addAllNodeIdentities(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllNodeIdentities(Iterable<? extends Role.RoleNodeIdentity> elements) {
            this.nodeIdentities.addAll(elements);
            return this;
        }

        @JsonProperty(value="CreateIndex")
        @CanIgnoreReturnValue
        public final Builder createIndex(BigInteger createIndex) {
            this.createIndex = Objects.requireNonNull(createIndex, "createIndex");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="ModifyIndex")
        @CanIgnoreReturnValue
        public final Builder modifyIndex(BigInteger modifyIndex) {
            this.modifyIndex = Objects.requireNonNull(modifyIndex, "modifyIndex");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @JsonProperty(value="Hash")
        @CanIgnoreReturnValue
        public final Builder hash(String hash) {
            this.hash = Objects.requireNonNull(hash, "hash");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        public ImmutableRoleResponse build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableRoleResponse(this.id, this.name, this.description, (ImmutableList<Role.RolePolicyLink>)this.policies.build(), (ImmutableList<Role.RoleServiceIdentity>)this.serviceIdentities.build(), (ImmutableList<Role.RoleNodeIdentity>)this.nodeIdentities.build(), this.createIndex, this.modifyIndex, this.hash);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("description");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("createIndex");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("modifyIndex");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("hash");
            }
            return "Cannot build RoleResponse, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="RoleResponse", generator="Immutables")
    static final class Json
    extends RoleResponse {
        @Nullable
        String id;
        @Nullable
        String name;
        @Nullable
        String description;
        @Nullable
        List<Role.RolePolicyLink> policies = ImmutableList.of();
        @Nullable
        List<Role.RoleServiceIdentity> serviceIdentities = ImmutableList.of();
        @Nullable
        List<Role.RoleNodeIdentity> nodeIdentities = ImmutableList.of();
        @Nullable
        BigInteger createIndex;
        @Nullable
        BigInteger modifyIndex;
        @Nullable
        String hash;

        Json() {
        }

        @JsonProperty(value="ID")
        public void setId(String id) {
            this.id = id;
        }

        @JsonProperty(value="Name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="Description")
        public void setDescription(String description) {
            this.description = description;
        }

        @JsonProperty(value="Policies")
        public void setPolicies(List<Role.RolePolicyLink> policies) {
            this.policies = policies;
        }

        @JsonProperty(value="ServiceIdentities")
        public void setServiceIdentities(List<Role.RoleServiceIdentity> serviceIdentities) {
            this.serviceIdentities = serviceIdentities;
        }

        @JsonProperty(value="NodeIdentities")
        public void setNodeIdentities(List<Role.RoleNodeIdentity> nodeIdentities) {
            this.nodeIdentities = nodeIdentities;
        }

        @JsonProperty(value="CreateIndex")
        public void setCreateIndex(BigInteger createIndex) {
            this.createIndex = createIndex;
        }

        @JsonProperty(value="ModifyIndex")
        public void setModifyIndex(BigInteger modifyIndex) {
            this.modifyIndex = modifyIndex;
        }

        @JsonProperty(value="Hash")
        public void setHash(String hash) {
            this.hash = hash;
        }

        @Override
        public String id() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String name() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String description() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Role.RolePolicyLink> policies() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Role.RoleServiceIdentity> serviceIdentities() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Role.RoleNodeIdentity> nodeIdentities() {
            throw new UnsupportedOperationException();
        }

        @Override
        public BigInteger createIndex() {
            throw new UnsupportedOperationException();
        }

        @Override
        public BigInteger modifyIndex() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String hash() {
            throw new UnsupportedOperationException();
        }
    }
}

