/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.de;

import com.hankcs.algorithm.AhoCorasickDoubleArrayTrie;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.LinguServices;
import org.languagetool.Tag;
import org.languagetool.UserConfig;
import org.languagetool.broker.ResourceDataBroker;
import org.languagetool.language.GermanyGerman;
import org.languagetool.languagemodel.BaseLanguageModel;
import org.languagetool.languagemodel.LanguageModel;
import org.languagetool.rules.Categories;
import org.languagetool.rules.ConfusionPair;
import org.languagetool.rules.ConfusionSetLoader;
import org.languagetool.rules.ConfusionString;
import org.languagetool.rules.Example;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.tools.StringTools;

public class ProhibitedCompoundRule
extends Rule {
    public static final String RULE_ID = "DE_PROHIBITED_COMPOUNDS";
    private static final List<Pair> lowercasePairs = Arrays.asList(new Pair("eigen", "'selbst', z.B. 'Eigenzitat'", "eingen", "M\u00f6glicher Tippfehler"), new Pair("st\u00fcmpfe", "Rest eines K\u00f6rpergliedes", "str\u00fcmpfe", "Bekleidungsst\u00fcck f\u00fcr den Fu\u00df"), new Pair("gel\u00e4nde", "Gebiet", "gel\u00e4nder", "Konstruktion zum Festhalten entlang von Treppen"), new Pair("tropen", "feuchtwarme Gebiete am \u00c4quator", "tropfen", "kleine Menge Fl\u00fcssigkeit"), new Pair("enge", "Mangel an Platz", "menge", "Anzahl an Einheiten"), new Pair("ritt", "Reiten", "tritt", "Aufsetzen eines Fu\u00dfes"), new Pair("beine", "K\u00f6rperteil", "biene", "Insekt"), new Pair("rebe", "Weinrebe", "reibe", "K\u00fcchenreibe"), new Pair("lande", null, "landes", null), new Pair("ass", "Spielkarte", "pass", "Reisepass; \u00dcbergang durch ein Gebirge"), new Pair("t\u00fcrmer", "Turmw\u00e4chter", "t\u00fcrme", "Plural von 'Turm' (Bauwerk)"), new Pair("soge", "ziehende Str\u00f6mungen", "sorge", "bedr\u00fcckendes Gef\u00fchl"), new Pair("panne", "technischer Defekt", "spanne", "Zeitraum"), new Pair("elfer", "Elfmeter", "helfer", "Person, die hilft"), new Pair("bau", "Bauwerk, Baustelle", "baum", "Pflanze"), new Pair("gase", "Plural von 'Gas' (Aggregatzustand)", "gasse", "kleine Stra\u00dfe"), new Pair("ekel", "Abscheu", "enkel", "Kind eines eigenen Kindes"), new Pair("reis", "Nahrungsmittel", "reise", "Ausflug/Fahrt"), new Pair("speichel", "K\u00f6rperfl\u00fcssigkeit", "speicher", "Lager, Depot, Ablage"), new Pair("h\u00fcte", "Kopfbedeckungen", "h\u00e4ute", "Plural von 'Haut'"), new Pair("bach", "kleiner Fluss", "bauch", "Teil des menschlichen K\u00f6rpers"), new Pair("werbereich", null, "erbereich", null), new Pair("lage", "Position", "alge", "im Wasser lebende Organismen"), new Pair("sph\u00e4re", "Kugel", "sp\u00e4hreh", null), new Pair("schenke", "Gastwirtschaft (auch: Sch\u00e4nke)", "schenkel", "Ober- und Unterschenkel"), new Pair("rune", "Schriftzeichen der Germanen", "runde", "Rundstrecke"), new Pair("mai", "Monat nach April", "mail", "E-Mail"), new Pair("pump", "'auf Pump': umgangssprachlich f\u00fcr 'auf Kredit'", "pumpe", "Ger\u00e4t zur Bef\u00f6rderung von Fl\u00fcssigkeiten"), new Pair("mitte", "zentral", "mittel", "Methode, um etwas zu erreichen"), new Pair("fein", "feink\u00f6rnig, genau, gut", "feind", "Gegner"), new Pair("traum", "Erleben w\u00e4hrend des Schlafes", "trauma", "Verletzung"), new Pair("name", "Bezeichnung (z.B. 'Vorname')", "nahme", "zu 'nehmen' (z.B. 'Teilnahme')"), new Pair("bart", "Haarbewuchs im Gesicht", "dart", "Wurfpfeil"), new Pair("hart", "fest", "dart", "Wurfpfeil"), new Pair("speiche", "Verbindung zwischen Nabe und Felge beim Rad", "speicher", "Lagerraum"), new Pair("speichen", "Verbindung zwischen Nabe und Felge beim Rad", "speicher", "Lagerraum"), new Pair("kart", "Gokart (Fahrzeug)", "karte", "Fahrkarte, Postkarte, Landkarte, ..."), new Pair("karts", "Kart = Gokart (Fahrzeug)", "karte", "Fahrkarte, Postkarte, Landkarte, ..."), new Pair("kurz", "Gegenteil von 'lang'", "kur", "medizinische Vorsorge und Rehabilitation"), new Pair("kiefer", "kn\u00f6cherner Teil des Sch\u00e4dels", "kiefern", "Kieferngew\u00e4chse (Baum)"), new Pair("gel", "dickfl\u00fcssige Masse", "geld", "Zahlungsmittel"), new Pair("flucht", "Entkommen, Fliehen", "frucht", "Ummantelung des Samens einer Pflanze"), new Pair("kamp", "Flurname f\u00fcr ein St\u00fcck Land", "kampf", "Auseinandersetzung"), new Pair("obst", "Frucht", "ost", "Himmelsrichtung"), new Pair("beeren", "Fr\u00fcchte", "b\u00e4ren", "Raubtiere"), new Pair("laus", "Insekt", "lauf", "Bewegungsart"), new Pair("l\u00e4use", "Insekt", "l\u00e4ufe", "Bewegungsart"), new Pair("l\u00e4usen", "Insekt", "l\u00e4ufen", "Bewegungsart"), new Pair("ruck", "pl\u00f6tzliche Bewegung", "druck", "Belastung"), new Pair("br\u00fcste", "Plural von Brust", "b\u00fcrste", "Ger\u00e4t mit Borsten, z.B. zum Reinigen"), new Pair("attraktion", "Sehensw\u00fcrdigkeit", "akttaktion", "vermutlicher Tippfehler"), new Pair("nah", "zu 'nah' (wenig entfernt)", "n\u00e4h", "zu 'n\u00e4hen' (mit einem Faden verbinden)"), new Pair("turn", "zu 'turnen'", "turm", "hohes Bauwerk"), new Pair("mit", "Pr\u00e4position", "miet", "zu 'Miete' (\u00dcberlassung gegen Bezahlung)"), new Pair("bart", "Behaarung im Gesicht", "brat", "zu 'braten', z.B. 'Bratkartoffel'"), new Pair("uhr", "Instrument zur Zeitmessung", "ur", "urspr\u00fcnglich"), new Pair("abschluss", "Ende", "abschuss", "Vorgang des Abschie\u00dfens, z.B. mit einer Waffe"), new Pair("brache", "verlassenes Grundst\u00fcck", "branche", "Wirtschaftszweig"), new Pair("wieder", "erneut, wiederholt, nochmal (Wiederholung, Wiedervorlage, ...)", "wider", "gegen, entgegen (Widerwille, Widerstand, Widerspruch, ...)"), new Pair("leer", "ohne Inhalt", "lehr", "bezogen auf Ausbildung und Wissen"), new Pair("gewerbe", "wirtschaftliche T\u00e4tigkeit", "gewebe", "gewebter Stoff; Verbund \u00e4hnlicher Zellen"), new Pair("klima", "langfristige Wetterzust\u00e4nde", "lima", "Hauptstadt von Peru"), new Pair("modell", "vereinfachtes Abbild der Wirklichkeit", "model", "Fotomodell"), new Pair("treppen", "Folge von Stufen (Mehrzahl)", "truppen", "Armee oder Teil einer Armee (Mehrzahl)"), new Pair("h\u00e4ufigkeit", "Anzahl von Ereignissen", "h\u00e4utigkeit", "z.B. in Dunkelh\u00e4utigkeit"), new Pair("hin", "in Richtung", "hirn", "Gehirn, Denkapparat"), new Pair("verkl\u00e4rung", "Besch\u00f6nigung, Darstellung in einem besseren Licht", "erkl\u00e4rung", "Darstellung, Erl\u00e4uterung"), new Pair("spitze", "spitzes Ende eines Gegenstandes", "spritze", "medizinisches Instrument zur Injektion"), new Pair("punk", "Jugendkultur", "punkt", "Satzzeichen"), new Pair("reis", "Nahrungsmittel", "eis", "gefrorenes Wasser"), new Pair("balkan", "Region in S\u00fcdosteuropa", "balkon", "Plattform, die aus einem Geb\u00e4ude herausragt"), new Pair("haft", "Freiheitsentzug", "schaft", "-schaft (Element zur Wortbildung)"), new Pair("stande", "zu 'Stand'", "stange", "l\u00e4nglicher Gegenstand"));
    private static LinguServices linguServices;
    private static final List<String> ignoreWords;
    private static final List<String> blacklistRegex;
    private static final Set<String> blacklist;
    protected AhoCorasickDoubleArrayTrie<String> ahoCorasickDoubleArrayTrie;
    protected Map<String, List<Pair>> pairMap;
    private static final AhoCorasickDoubleArrayTrie<String> prohibitedCompoundRuleSearcher;
    private static final Map<String, List<Pair>> prohibitedCompoundRulePairMap;
    private final BaseLanguageModel lm;
    private Pair confusionPair = null;

    private static void addAllCaseVariants(List<Pair> candidatePairs, Pair lcPair) {
        candidatePairs.add(new Pair(lcPair.part1, lcPair.part1Desc, lcPair.part2, lcPair.part2Desc));
        String ucPart1 = StringTools.uppercaseFirstChar((String)lcPair.part1);
        String ucPart2 = StringTools.uppercaseFirstChar((String)lcPair.part2);
        if (!lcPair.part1.equals(ucPart1) || !lcPair.part2.equals(ucPart2)) {
            candidatePairs.add(new Pair(ucPart1, lcPair.part1Desc, ucPart2, lcPair.part2Desc));
        }
    }

    private static void addUpperCaseVariants(List<Pair> pairs) {
        for (Pair lcPair : lowercasePairs) {
            if (StringTools.startsWithUppercase((String)lcPair.part1)) {
                throw new IllegalArgumentException("Use all-lowercase word in " + ProhibitedCompoundRule.class + ": " + lcPair.part1);
            }
            if (StringTools.startsWithUppercase((String)lcPair.part2)) {
                throw new IllegalArgumentException("Use all-lowercase word in " + ProhibitedCompoundRule.class + ": " + lcPair.part2);
            }
            ProhibitedCompoundRule.addAllCaseVariants(pairs, lcPair);
        }
    }

    protected static void addItemsFromConfusionSets(List<Pair> pairs, String confusionSetsFile, boolean isUpperCase) {
        try {
            ResourceDataBroker dataBroker = JLanguageTool.getDataBroker();
            try (InputStream confusionSetStream = dataBroker.getFromResourceDirAsStream(confusionSetsFile);){
                ConfusionSetLoader loader = new ConfusionSetLoader((Language)GermanyGerman.INSTANCE);
                Map confusionPairs = loader.loadConfusionPairs(confusionSetStream);
                for (Map.Entry entry : confusionPairs.entrySet()) {
                    for (ConfusionPair pair : (List)entry.getValue()) {
                        boolean allUpper = pair.getTerms().stream().allMatch(k -> StringTools.startsWithUppercase((String)k.getString()) && !ignoreWords.contains(k.getString()));
                        if (!allUpper && isUpperCase) continue;
                        List cSet = pair.getTerms();
                        if (cSet.size() != 2) {
                            throw new RuntimeException("Got confusion set with != 2 items: " + cSet);
                        }
                        Iterator it = cSet.iterator();
                        ConfusionString part1 = (ConfusionString)it.next();
                        ConfusionString part2 = (ConfusionString)it.next();
                        pairs.add(new Pair(part1.getString(), part1.getDescription(), part2.getString(), part2.getDescription()));
                        if (isUpperCase) {
                            pairs.add(new Pair(StringTools.lowercaseFirstChar((String)part1.getString()), part1.getDescription(), StringTools.lowercaseFirstChar((String)part2.getString()), part2.getDescription()));
                            continue;
                        }
                        pairs.add(new Pair(StringTools.uppercaseFirstChar((String)part1.getString()), part1.getDescription(), StringTools.uppercaseFirstChar((String)part2.getString()), part2.getDescription()));
                    }
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected static AhoCorasickDoubleArrayTrie<String> setupAhoCorasickSearch(List<Pair> pairs, Map<String, List<Pair>> pairMap) {
        TreeMap<String, String> map = new TreeMap<String, String>();
        for (Pair pair : pairs) {
            map.put(pair.part1, pair.part1);
            map.put(pair.part2, pair.part2);
            pairMap.putIfAbsent(pair.part1, new LinkedList());
            pairMap.putIfAbsent(pair.part2, new LinkedList());
            pairMap.get(pair.part1).add(pair);
            pairMap.get(pair.part2).add(pair);
        }
        AhoCorasickDoubleArrayTrie ahoCorasickDoubleArrayTrie = new AhoCorasickDoubleArrayTrie();
        ahoCorasickDoubleArrayTrie.build(map);
        return ahoCorasickDoubleArrayTrie;
    }

    public ProhibitedCompoundRule(ResourceBundle messages, LanguageModel lm, UserConfig userConfig) {
        super(messages);
        this.lm = (BaseLanguageModel)Objects.requireNonNull(lm);
        super.setCategory(Categories.TYPOS.getCategory(messages));
        this.ahoCorasickDoubleArrayTrie = prohibitedCompoundRuleSearcher;
        this.pairMap = prohibitedCompoundRulePairMap;
        linguServices = userConfig != null ? userConfig.getLinguServices() : null;
        this.addExamplePair(Example.wrong((String)"Da steht eine <marker>Lehrzeile</marker> zu viel."), Example.fixed((String)"Da steht eine <marker>Leerzeile</marker> zu viel."));
    }

    public String getId() {
        return RULE_ID;
    }

    public String getDescription() {
        return "Markiert wahrscheinlich falsche Komposita wie 'Lehrzeile', wenn 'Leerzeile' h\u00e4ufiger vorkommt.";
    }

    public RuleMatch[] match(AnalyzedSentence sentence) throws IOException {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        AnalyzedTokenReadings prevReadings = null;
        for (AnalyzedTokenReadings readings : sentence.getTokensWithoutWhitespace()) {
            String tmpWord = readings.getToken();
            if (prevReadings != null && prevReadings.hasAnyPartialPosTag(new String[]{"EIG:"}) && StringTools.startsWithUppercase((String)tmpWord) && (readings.hasAnyPartialPosTag(new String[]{"EIG:"}) || readings.isPosTagUnknown()) || prevReadings != null && prevReadings.getToken().matches("Herrn?|Frau")) continue;
            ArrayList<String> wordsParts = new ArrayList<String>(Arrays.asList(tmpWord.split("-")));
            int partsStartPos = 0;
            for (String wordPart : wordsParts) {
                partsStartPos = this.getMatches(sentence, ruleMatches, readings, partsStartPos, wordPart, 0);
            }
            String noHyphens = this.removeHyphensAndAdaptCase(tmpWord);
            if (noHyphens != null) {
                this.getMatches(sentence, ruleMatches, readings, 0, noHyphens, tmpWord.length() - noHyphens.length());
            }
            prevReadings = readings;
        }
        return this.toRuleMatchArray(ruleMatches);
    }

    private static boolean isMisspelled(String word) {
        if (linguServices == null) {
            return GermanyGerman.INSTANCE.getDefaultSpellingRule().isMisspelled(word);
        }
        return !linguServices.isCorrectSpell(word, (Language)GermanyGerman.INSTANCE);
    }

    private int getMatches(AnalyzedSentence sentence, List<RuleMatch> ruleMatches, AnalyzedTokenReadings readings, int partsStartPos, String wordPart, int toPosCorrection) {
        if (readings.isTagged() && !readings.hasPartialPosTag("SUB") && !readings.hasPosTagStartingWith("EIG:") || wordPart.length() <= 6) {
            return partsStartPos += wordPart.length() + 1;
        }
        ArrayList<Pair> candidatePairs = new ArrayList<Pair>();
        if (this.confusionPair == null) {
            List wordList = this.ahoCorasickDoubleArrayTrie.parseText((CharSequence)wordPart);
            for (AhoCorasickDoubleArrayTrie.Hit hit : wordList) {
                List<Pair> pair = this.pairMap.get(hit.value);
                if (pair == null) continue;
                candidatePairs.addAll(pair);
            }
        } else {
            ProhibitedCompoundRule.addAllCaseVariants(candidatePairs, this.confusionPair);
        }
        ArrayList<WeightedRuleMatch> weightedMatches = new ArrayList<WeightedRuleMatch>();
        for (Pair pair : candidatePairs) {
            String variant = null;
            if (wordPart.contains(pair.part1)) {
                variant = wordPart.replaceFirst(pair.part1, pair.part2);
            } else if (wordPart.contains(pair.part2)) {
                variant = wordPart.replaceFirst(pair.part2, pair.part1);
            }
            if (variant == null) {
                partsStartPos += wordPart.length() + 1;
                continue;
            }
            long wordCount = this.lm.getCount(wordPart);
            long variantCount = this.lm.getCount(variant);
            if (variantCount <= (long)this.getThreshold() || wordCount != 0L || blacklist.contains(wordPart) || ProhibitedCompoundRule.isMisspelled(variant) || !blacklistRegex.stream().noneMatch(k -> wordPart.matches(".*" + k + ".*"))) continue;
            String msg = pair.part1Desc != null && pair.part2Desc != null ? "M\u00f6glicher Tippfehler. " + StringTools.uppercaseFirstChar((String)pair.part1) + ": " + pair.part1Desc + ", " + StringTools.uppercaseFirstChar((String)pair.part2) + ": " + pair.part2Desc : "M\u00f6glicher Tippfehler: " + pair.part1 + "/" + pair.part2;
            int fromPos = readings.getStartPos() + partsStartPos;
            int toPos = fromPos + wordPart.length() + toPosCorrection;
            String id = this.getId() + "_" + this.cleanId(pair.part1) + "_" + this.cleanId(pair.part2);
            SpecificIdRule idRule = new SpecificIdRule(id, pair.part1, pair.part2, this.messages, this.isPremium(), this.getTags());
            RuleMatch match = new RuleMatch((Rule)idRule, sentence, fromPos, toPos, msg);
            match.setSuggestedReplacement(variant);
            weightedMatches.add(new WeightedRuleMatch(variantCount, match));
        }
        if (weightedMatches.size() > 0) {
            Collections.sort(weightedMatches);
            ruleMatches.add(((WeightedRuleMatch)weightedMatches.get((int)0)).match);
        }
        return partsStartPos += wordPart.length() + 1;
    }

    int getThreshold() {
        return 0;
    }

    private String cleanId(String id) {
        return id.toUpperCase().replace("\u00c4", "AE").replace("\u00dc", "UE").replace("\u00d6", "OE");
    }

    public void setConfusionPair(Pair confusionPair) {
        this.confusionPair = confusionPair;
    }

    @Nullable
    String removeHyphensAndAdaptCase(String word) {
        String[] parts = word.split("-");
        if (parts.length > 1) {
            StringBuilder sb = new StringBuilder();
            int i = 0;
            for (String part : parts) {
                if (part.length() <= 1) {
                    return null;
                }
                sb.append(i == 0 ? part : StringTools.lowercaseFirstChar((String)part));
                ++i;
            }
            return sb.toString();
        }
        return null;
    }

    static {
        ignoreWords = Arrays.asList("Die", "De");
        blacklistRegex = Arrays.asList("stromkreis", "Lande(basis|basen|region|gebiets?|gebieten?|regionen|betriebs?|betrieben?|offizieren?|bereichs?|bereichen?|einrichtung|einrichtungen|massen?|plans?|versuchs?|versuchen?)", "Model(vertrags?|vertr\u00e4gen?|erfahrung|erfahrungen|szene|welt)", "(Raum|Surf|Jazz|Herbst|Gymnastik|Normal)schuhen?", "preis", "reis\u00e4hnlich(e|e[nmrs])?", "reisender", "[a-z\u00f6\u00e4\u00fc\u00df]+sender", "gra(ph|f)ische?", "gra(ph|f)ische[rsnm]", "gra(ph|f)s?$", "gra(ph|f)en", "gra(ph|f)in", "gra(ph|f)ik", "gra(ph|f)ie", "Gra(ph|f)its?", ".+gra(ph|f)its?");
        blacklist = new HashSet<String>(Arrays.asList("Trendgericht", "Balkonfront", "Balkonbereich", "Anlaufleistung", "Haushaltstuch", "Arztdiagnose", "Wickelbereich", "Trassenkonflikt", "Trassenkonflikte", "bef\u00fcllende", "Echsenauge", "Echsenaugen", "Lackpulver", "Lackpulvers", "Mikrolage", "Mikrolagen", "Sichtnutzer", "Sichtnutzers", "Sichtnutzern", "Jugendrad", "Jugendrads", "Lizenzname", "Lizenznamen", "Rhein-Nahe", "Geleinlage", "Geleinlagen", "Leerbest\u00e4nde", "Rechnungszeile", "Speichenschutz", "Notfunk", "Notfunks", "Leerteile", "Leerteilen", "Leerteils", "Mietdiskussion", "Mietdiskussionen", "Mietverwalter", "Mietverwaltern", "Mietverwalters", "Handfilter", "Handfiltern", "Handfilters", "Fellpartie", "Fellpartien", "Reservesitz", "Energiekonten", "Steingel\u00e4nde", "Marktengen", "Stromernte", "Stromernten", "Plastikspitze", "Plastikspitzen", "Speichenmuster", "Ticketverlauf", "Ticketverlaufs", "Immobilienwelt", "Rheinruhr", "Turmbewegung", "Turmbewegungen", "Turmwart", "Turmwarts", "Reisblatt", "Reisblatts", "Reisbl\u00e4tter", "Reisbl\u00e4ttern", "Reisgetr\u00e4nk", "Reisgetr\u00e4nks", "Reisgetr\u00e4nke", "Reisgetr\u00e4nken", "Reiszwecke", "Reiszwecken", "Bankangabe", "Bankangaben", "Lehrbecken", "Strohseide", "Filtermaschine", "Filtermaschinen", "Kenncode", "Kenncodes", "Sicherheitshalt", "Sicherheitshalts", "Sicherheitshalte", "Wandschalter", "Wandschalters", "Wildgericht", "Wildgerichte", "Haltungskonzept", "Schenkelbiene", "Schenkelbienen", "Felsenbiene", "Felsenbienen", "Killerbiene", "Killerbienen", "Investitionsbetrug", "Investitionsbetruges", "Investitionsbetrugs", "Luftwert", "Luftwerte", "Luftwerts", "Luftwertes", "Luftwerten", "Gegenschall", "Kontenvorg\u00e4nge", "Milit\u00e4rbunker", "Gem\u00fcseboxen", "Suchwunsch", "Pflanzerden", "Kriegsflucht", "Reisekabel", "Schutzboxen", "Wandbeschichtung", "Maschinenbrand", "Badehilfe", "Badehilfen", "Backprogramm", "Backprogramme", "Backprogrammen", "Backfunktion", "Backleistung", "Winterblues", "Klickverbindung", "Klickverbindungen", "Traumschuhe", "Traumschuhen", "Schulware", "Schulwaren", "Konzernkreisen", "Strandmotiv", "Strandmotive", "Strandmotiven", "Tiersammelstelle", "Tiersammelstellen", "Verkaufserlebnis", "Eisgenuss", "Oberhardt", "Hundebett", "Artengesetz", "Mietpartner", "Mietpartners", "Mietpartnern", "Mieterlebnis", "Paketkasten", "Ausnahmefirmen", "Schreibraten", "Treppentransport", "Treppentransports", "Treppentransporte", "Treppentransporten", "Familienvillen", "Kampweg", "Kampwegs", "Werbemodel", "Werbemodels", "Schuhreinigung", "Luftrad", "Luftrads", "Waschgel", "Waschgels", "Absatzzeile", "Absatzzeilen", "Standardzeile", "Standardzeilen", "Reisspezialit\u00e4t", "Reisspezialit\u00e4ten", "Kommunikationsgewerbe", "Kunststoffgewerbe", "Obstring", "Obstringen", "Mietinformation", "Mietinformationen", "Bergtrasse", "Privatprofil", "Spezial\u00f6len", "Ladedock", "Ladedocks", "Fahrtenregler", "Fahrtenreglern", "Fahrtenreglers", "K\u00f6rperakne", "Mitarbeiterakte", "Mitarbeiterakten", "Frontschaden", "Testgeb\u00fchr", "Testgeb\u00fchren", "Energiegeld", "Kontaktermittlung", "Flutnacht", "Salztank", "Kursformat", "Kursformate", "Kursformaten", "Kursseite", "Kursseiten", "Ladekarte", "Ladekarten", "Schneehose", "Schneehosen", "Au\u00dfendusche", "Au\u00dfenduschen", "Nachbauteile", "Nachbauteilen", "Au\u00dfenbar", "Modelfigur", "Kurzangebot", "Kurzangebote", "Kurzangeboten", "Verschw\u00f6rungsideologe", "Verschw\u00f6rungsideologen", "Maklerkollege", "Maklerkollegen", "Suppenk\u00f6che", "Suppenk\u00f6chen", "Schulk\u00f6che", "Schulk\u00f6chen", "Privatk\u00f6che", "Privatk\u00f6chen", "Mannschaftsk\u00f6che", "Mannschaftsk\u00f6chen", "Gourmetk\u00f6che", "Gourmetk\u00f6chen", "Fischk\u00f6che", "Fischk\u00f6chen", "Gef\u00e4ngnisk\u00f6che", "Gef\u00e4ngnisk\u00f6chen", "Chemieexperte", "Devisenexperte", "Mietinteressent", "Mietinteressenten", "Mietinteressentin", "Mietinteressentinnen", "Gruppenunterkunft", "Gruppenunterk\u00fcnfte", "Gruppenunterk\u00fcnften", "Fischturm", "Wandtaster", "Rauchsalz", "Miettag", "Mietrechnung", "Grundgas", "Mahlstufe", "Mahlstufen", "Mahlprogramm", "Mahlprogramme", "Mahlprogrammen", "umparken", "Fabrikgasse", "Dachreinigung", "Dachreinigungen", "Geisterspiel", "Geisterspiels", "Geisterspiele", "Geisterspielen", "gehostet", "gehostete", "gehostetes", "gehosteten", "gehostetes", "gehosteter", "gehostetem", "Felltyp", "Felltyps", "Gem\u00fcsehaus", "Ladepark", "Ladeparks", "Autoexperte", "Autoexperten", "Basiskonten", "Onlinekonten", "Druckmodell", "Druckmodells", "Druckmodelle", "Druckmodellen", "Modelleben", "Modellebens", "Porzellanmarke", "Porzellanmarken", "Abtauvorgang", "Abtauvorgangs", "Abtauvorg\u00e4nge", "Abtauvorg\u00e4ngen", "Kurzantrag", "Kurzantr\u00e4ge", "Kurzantr\u00e4gen", "Hundeschuhe", "Hundeschuhen", "Testerinnen", "Wirtschaftspreises", "Schl\u00fcsselkreise", "Bundespreisen", "Terminsuche", "Suchposition", "Mietersache", "Textpr\u00fcfungen", "Abteilungszahlen", "Batteriewahl", "Zahlrhythmus", "Zahldatum", "Auszahlphase", "Auszahlmethode", "Zahlprozess", "Protestzahlen", "Leserwahlen", "Publikumswahl", "H\u00e4ndlerwahl", "Wettbetrag", "Wettguthaben", "Wettannahme", "Wettkonto", "Wettguthaben", "Wettguthabens", "Wettsteuern", "Wettoptionen", "Testhaushalt", "Testkapazit\u00e4t", "Testfamilie", "Testkapazit\u00e4ten", "Testbeobachtung", "Testproduktionen", "Produkttest", "Produkttesten", "Produkttext", "Textkampagnen", "Texting", "Testfelds", "Testnachweis", "Testbeitr\u00e4ge", "Testbeitr\u00e4gen", "Verkaufstext", "Bewerbungsfrage", "Bewerbungstag", "Best\u00e4tigungstext", "Bewerbungsprozess", "Bewerbungsprozesse", "Bewertungsmanagement", "Bewertungsdossier", "Bewerbungsnote", "Bewerbungskennziffer", "Online-Bewertung", "Schuhmodell", "Schuhmodells", "B\u00fcrgertest", "Testzelt", "Testgelegenheit", "Testbestellung", "Aufkl\u00e4rungsseiten", "Verkaufsseiten", "Morgenseiten", "Bed\u00fcrfnisseiten", "Kehrzeiten", "Lernseiten", "Suchstatistik", "Kassenl\u00f6sung", "Kassenchef", "Kassenmanagement", "Kassenbesetzung", "Stundenkonten", "Werbekonten", "Kontensicherung", "Extrakonten", "Servicekonten", "Lichtmodi", "Frontlicht", "sichtgesch\u00fctzter", "Sichtproben", "Mietschein", "Miethilfen", "Mietberater", "Mietstrom", "Fitnessmarke", "Kameramarke", "Gew\u00fcrzmarke", "Paketmarke", "Standregal", "Standordnung", "Zahnkorrekturen", "Infektionslage", "Strandtage", "Schweinebach", "Schweinebaches", "Wellenbach", "Kesselbauches", "Froschbach", "Bachregion", "Bachregionen", "Flugtaxen", "Fahrerkanzel", "Wehrchef", "Lichtkunstwerk", "Infektionslage", "Teilspiegel", "Preiseseite", "Teamfahrers", "Supportzeiten", "Schwabenweg", "Datenspende", "Datenspenden", "Designermaske", "Designermasken", "Herdenschutz", "Maskendisziplin", "Maskenmode", "Maskenmoden", "Maskenmoral", "Impfvorrang", "Volksmaske", "Volksmasken", "Testmeilen", "Hauptstrand", "Hauptstrands", "Hauptstrandes", "H\u00fcttenschuhe", "H\u00fcttenschuhen", "H\u00fcttenschuhs", "Mietbedingung", "Mietbedingungen", "Modeltyp", "Modeltyps", "Modeltypen", "Musikversand", "Musikversands", "Musikversandes", "Paragrafzeichen", "Paragrafzeichens", "Pflanzenmarkt", "Pflanzenmarkts", "Pflanzenmarktes", "Privatstrand", "Privatstrands", "Privatstr\u00e4nde", "Privatstr\u00e4nden", "Privatstrandes", "Reisessig", "Reisessigs", "Reiswein", "Reisweins", "Reisweine", "Schuhabteilung", "Schuhabteilungen", "Schulfirma", "Schulfirmen", "Schulmagazin", "Schulmagazins", "Schulmagazinen", "Schulmagazinen", "Segelschuhe", "Segelschuhen", "Spitzenhaus", "Spitzenhauses", "Spitzenh\u00e4user", "Spitzenh\u00e4usern", "Standgebl\u00e4se", "Standgebl\u00e4sen", "Standgebl\u00e4ses", "Standstreifen", "Standstreifens", "Strandfigur", "Strandfoto", "Strandfotos", "Strandkonzert", "Strandkonzerts", "Strandkonzertes", "Strandkonzerte", "Strandkonzerten", "Strandverlust", "Strandverluste", "Strandverlusten", "Tierversand", "Tierversands", "Treppenart", "Treppenarten", "Winterflucht", "Nachtmitte", "Gemeindemitte", "Feinbeurteilung", "Bremssand", "Bratform", "Devisenspritze", "Einkaufszielen", "einn\u00e4hmt", "hin\u00fcbern\u00e4hmen", "maschinenn\u00e4her", "zentrumsn\u00e4her", "Einzelversandes", "Eisb\u00e4llchen", "Eisenbahnrades", "Eisl\u00e4ufer", "Eisl\u00e4ufern", "Eisl\u00e4ufers", "Fachversand", "Fachversandes", "Feinwahrnehmung", "Feinwahrnehmungen", "Fluchtkapsel", "Fluchtkapseln", "Fluchtschiffe", "Fluchtschiffes", "Fluchtschiffs", "Fluchtschiffen", "Fl\u00fcgeltreppe", "Fl\u00fcgeltreppen", "Fruchtspiel", "Gletschersand", "Gletschersands", "Gletschersandes", "Grafem", "Grafems", "Grafeme", "Grafemen", "grafitgrau", "grafithaltig", "grafithaltige", "grafithaltiger", "grafithaltigen", "grafithaltigem", "grafithaltiges", "grafithaltigeren", "grafithaltigerem", "Reitschuhe", "Reitschuhen", "Nordbalkon", "Ostbalkon", "S\u00fcdbalkon", "Westbalkon", "Zahngel", "Reinigungsgel", "Schutzname", "Schutznamen", "Gebrauchsname", "Gebrauchsnamen", "Erbname", "Erbnamen", "Datenname", "Datennamen", "Geldnahme", "Geldnahmen", "Kreispokal", "Gr\u00fcndertag", "Korrekturl\u00f6sung", "Regelschreiber", "Glasreinigern", "Holzstele", "Brandschutz", "Testbahn", "Testbahnen", "Startglocke", "Startglocken", "Ladepunkte", "Kinderpreise", "Kinderpreisen", "Belegungsoptionen", "Brandgebiete", "Brandgebieten", "Innenfell", "Innenfelle", "Batteriepreis", "Alltagsschuhe", "Alltagsschuhen", "Arbeiterschuhe", "Arbeiterschuhen", "Bartvogel", "Abschiedsmail", "Abschiedsmails", "Wohnindex", "Entwicklungsstudio", "Ermittlungsgesetz", "Lindeverfahren", "Stromspender", "Turmverlag", "B\u00e4ckerlunge", "Reisbeutel", "Reisbeuteln", "Reisbeutels", "Fellnase", "Fellnasen", "Kletterwald", "Kletterwalds", "Lusth\u00f6hle", "Lusth\u00f6hlen", "Abschlagswert", "Schuhfach", "Schuhf\u00e4cher", "Sp\u00fclkan\u00fcle", "Sp\u00fclkan\u00fclen", "Tankkosten", "Hangout", "Hangouts", "Kassenloser", "kassenloser", "Reisnadel", "Reisnadeln", "stielloses", "stielloser", "stiellosen", "Beiratsregelung", "Beiratsregelungen", "Kreiskongress", "Lagekosten", "hineinfeiern", "Maskenhersteller", "Wabendesign", "Maskenherstellers", "Maskenherstellern", "Firmenvokabular", "Maskenproduktion", "Maskenpflicht", "Nachmiete", "Ringseil", "Ringseilen", "Jagdschule", "Tachograf", "Tachografs", "Tachografen", "Grafitpulver", "Grafitmine", "Grafitminen", "Nesselstra\u00dfe", "Reitsachen", "Mehrfachabrechnung", "Stuhlrolle", "Stuhlrollen", "neugestartet", "Vertragskonto", "M\u00e4nnerding", "Restwoche", "Startpakete", "Startpaketen", "Suchintention", "Wettgl\u00fcck", "Wettprogramm", "Wettprogramme", "Z\u00e4hlerwechsel", "Z\u00e4hlerwechsels", "N\u00e4hrstoffleitungen", "Verhandlungskreise", "Verhandlungskreisen", "Mietsuchenden", "Mietsuchende", "Mietsuchender", "Autoboss", "Autobossen", "Testmonat", "Testmonats", "Testmonate", "Naturseife", "Naturseifen", "Ankerkraut", "Ankerkrauts", "Bewerbungstool", "Bewerbungstools", "Elektromarke", "Elektromarken", "Ankerkraut", "Testuser", "Testangeboten", "Testangebots", "Testangebotes", "verkeimt", "verkeimte", "verkeimter", "verkeimtes", "verkeimten", "verkeimtem", "Flugscham", "Kurseinf\u00fchrung", "Januar-Miete", "Februar-Miete", "M\u00e4rz-Miete", "April-Miete", "Mai-Miete", "Juni-Miete", "Juli-Miete", "August-Miete", "September-Miete", "Oktober-Miete", "November-Miete", "Dezember-Miete", "Suchindices", "Kirchenfreizeit", "Kirchenfreizeiten", "Erkl\u00e4rb\u00e4r", "Wettart", "Wettarten", "Einzelwette", "Einzelwetten", "Artikelzeile", "Artikelzeilen", "Echtgeld", "Kartenansicht", "Kartenansichten", "Systemwette", "Systemwetten", "Dachzelt", "Dachzelte", "Badeloch", "Bonusaktion", "Bonusaktionen", "Projektannahme", "Pollenbelastung", "Fastenfenster", "Bauchtasche", "Bauchtaschen", "Zahloption", "Zahloptionen", "Zeckenschutz", "Vertragskonto", "Zeichengrenze", "Zeichengrenzen", "Kartontasche", "Kartontaschen", "Mietbest\u00e4tigung", "Mietbest\u00e4tigungen", "Tunnelzelt", "Tunnelzelts", "Tunnelzelte", "Dichtleistung", "Dichtleistungen", "Testkonto", "Testkontos", "Konzernnummer", "Konzernnummern", "Vertragsstunde", "Vertragsstunden", "Zauntr\u00e4ger", "Zauntr\u00e4gern", "Zauntr\u00e4gers", "Hallenschuh", "Hallenschuhs", "Hallenschuhe", "Rekrutierungsausgabe", "Rekrutierungsausgaben", "geruchsfreies", "Tafelfolie", "Gartenservice", "Gartenservices", "Rollger\u00fcste", "Rollger\u00fcsten", "Grasabfall", "Grasabf\u00e4llen", "Ketogrippe", "Ger\u00e4teh\u00fclle", "kaltwei\u00df", "Maskenbefreiung", "Lusttropfen", "Kundenstimme", "Deichschafen", "Industriehefe", "Freizeitschuhe", "Freizeitschuhen", "Trainingsschuhe", "Trainingsschuhen", "Schuhblatt", "Nachbacken", "Wassermelder", "Schutzsegen", "Fischversteigerung", "Fischversteigerungen", "Konfigurationsteile", "Konfigurationsteilen", "Wasserbauch", "Wasserbauchs", "Stadtrad", "Stadtrads", "Seniorenrad", "Seniorenrads", "Bodenplane", "Schwimmschuhe", "Familienstrand", "versiegelbaren", "\u00dcberraschungsfeier", "\u00dcberraschungsfeiern", "ballseitig", "Genussgarten", "Genussgartens", "Edelsteingarten", "Edelsteingartens", "Insektengarten", "Insektengartens", "Klimakurs", "Klimakurses", "Kursperioden", "Musikreise", "Musikreisen", "Ziegenhof", "Ziegenhofs", "Au\u00dfendecke", "Au\u00dfendecken", "Bewegungsbarriere", "Bewegungsbarrieren", "Gerichtsantrag", "Gerichtsantrags", "Gerichtsantr\u00e4ge", "Spezialwette", "Spezialwetten", "Geldmagnet", "Testartikel", "Testartikeln", "Testartikels", "folierte", "foliert", "folierten", "foliertes", "foliertem", "Implementierungsvorgaben", "B\u00fccherzelle", "B\u00fccherzellen", "Cuttermesser", "Cuttermessern", "Cuttermessers", "Kabelsammlung", "Kabelsammlungen", "Schleifschwamm", "Schleifschwamms", "Schleifschw\u00e4mme", "Teemarke", "Teemarken", "Vorzelt", "Vorzelte", "Supportleitung", "Kursname", "Schmucksorte", "Schmucksorten", "Farbsorte", "Farbsorten", "Donaublick", "Rundhals", "Trittschutz", "Laufhaus", "Wickeltasche", "Bayernliga", "Badsanierung", "Laufbereitschaft", "Geschenkkarten", "Landesklasse", "Firmenlauf", "Satzverlust", "Satzgewinn", "Monatslinsen", "Tageslinsen", "Sexstellung", "Traumbad", "Schlafsystem", "Startspieler", "Tabellenrang", "Heimerfolg", "Dachboxen", "Videotest", "Zugbindung", "Badplanung", "Badschrank", "Reiturlaub", "Zeittraining", "Dichtungssatz", "Wettb\u00f6rsen", "Bildungspaket", "anklickst", "Frauenlauf", "Problemhaut", "Absperrpfosten", "Regenh\u00fclle", "Satzball", "Ausw\u00e4rtsfahrt", "Dichtsatz", "Nutzungserlebnis", "Saumabschluss", "Rundengewinn", "Haussteuerung", "Unterfederung", "Sternek\u00fcche", "Wickeltaschen", "Jahreslinsen", "Blutmond", "Badeplattform", "Wettquote", "Haarmaske", "Schlussgang", "Damengr\u00f6\u00dfen", "Hautanalyse", "Au\u00dfenkamera", "Kuscheldecken", "Feinhefe", "Radstation", "Satzb\u00e4lle", "gelinkter", "Nacktbild", "B\u00fccherb\u00e4r", "Winzerhof", "Laufh\u00e4user", "Verbandsklasse", "Rennrunde", "Luftmasche", "Suchfiltern", "Wohndecke", "bespa\u00dft", "Endrohren", "ablutschte", "Waldkatzen", "Sicherheitsweste", "Gelbsperre", "Kopfdichtung", "Wurfzelt", "Gemeinschaftskarten", "Kornkreis", "Bronzerang", "Fensterfolien", "eink\u00f6pfen", "Einkaufsnacht", "Reiserad", "Leistungsspange", "Ladepunkten", "Breitb\u00e4nder", "Wochenplaner", "Leserunden", "K\u00f6nigsleiten", "Hochlader", "Lauferlebnis", "Radstrecken", "Kinderlauf", "Bettsystem", "Reifentests", "Fettleder", "Bildungsstreik", "Satzr\u00fcckstand", "B\u00fcrstenk\u00f6pfe", "Werbegesicht", "Bassreflex", "Postrock", "gelaserten", "Ohrb\u00fcgel", "Bestweite", "Golfschuhe", "Genussreise", "Barkultur", "Ladepunkt", "Sportreifen", "Begleitdamen", "Tauchgebiet", "Stadttouren", "vermixen", "Suchvorschl\u00e4ge", "Damenmodell", "Putzkittel", "Eistees", "Begleitdame", "Frontmanns", "Katzenbett", "Pizza\u00f6fen", "Sitzerh\u00f6hungen", "Golfkurse", "Ventilkappen", "Kinderuhr", "Bachbl\u00fcte", "rockigem", "Kinderpreis", "Massivhauses", "Golfstar", "Herstellerwertung", "Herznoten", "Geldklammer", "Einzelkatze", "Fellwechsels", "Duftreis", "Jugendpokal", "Werbel\u00fcge", "Superzoom", "Inselpark", "Golfschuh", "Schuhwahl", "Schwingtor", "Sexabenteuern", "Insektenhaus", "Ramschniveau", "Verbrenners", "Doppelklingen", "Clubkonzert", "pullert", "Meisterchor", "Bienenfarm", "Windknoten", "Videoarten", "Textartikel", "Textartikels", "Textartikeln", "Feuchtmann", "Fachlekt\u00fcre", "Fachlekt\u00fcren", "Lustkugel", "Lustkugeln", "Tankbeleg", "Tankbelegs", "Tankbeleges", "Tankbelege", "Tankbelegen", "Kamelart", "Kamelarten", "Bayern-Pr\u00e4sident", "Bayern-Pr\u00e4sidenten", "Bundessprechern", "Netzsuche", "Beileger", "Beilegers", "Beilegern", "Sexangelegenheit", "Sexangelegenheiten", "Mobilfunkmarke", "Schulball", "Schulballs", "Aluminiumz\u00f6lle", "Aluminiumz\u00f6llen", "Herz-Ass", "Herzass", "Fleischmagen", "marktdurchdringend", "marktdurchdringende", "marktdurchdringendes", "marktdurchdringender", "marktdurchdringenden", "marktdurchdringendem", "Zukunftsbaum", "Zukunftsbaums", "Zukunftsbaumes", "Rasenwurzel", "Rasenwurzeln", "Wandlungskapital", "Wandlungskapitals", "Themenboxen", "Superyacht", "Testbestellung", "Testbestellungen", "Reisbeilage", "Reisbeilagen"));
        ArrayList<Pair> pairs = new ArrayList<Pair>();
        HashMap<String, List<Pair>> pairMap = new HashMap<String, List<Pair>>();
        ProhibitedCompoundRule.addUpperCaseVariants(pairs);
        ProhibitedCompoundRule.addItemsFromConfusionSets(pairs, "/de/confusion_sets.txt", true);
        prohibitedCompoundRuleSearcher = ProhibitedCompoundRule.setupAhoCorasickSearch(pairs, pairMap);
        prohibitedCompoundRulePairMap = pairMap;
    }

    private static class SpecificIdRule
    extends Rule {
        private final String id;
        private final String desc;

        SpecificIdRule(String id, String part1, String part2, ResourceBundle messages, boolean isPremium, List<Tag> tags) {
            this.setPremium(isPremium);
            this.id = Objects.requireNonNull(id);
            this.desc = "Markiert wahrscheinlich falsche Komposita mit Teilwort '" + StringTools.uppercaseFirstChar((String)part1) + "' statt '" + StringTools.uppercaseFirstChar((String)part2) + "' und umgekehrt";
            this.setCategory(Categories.TYPOS.getCategory(messages));
            this.setTags(tags);
        }

        public String getId() {
            return this.id;
        }

        public String getDescription() {
            return this.desc;
        }

        public RuleMatch[] match(AnalyzedSentence sentence) throws IOException {
            return RuleMatch.EMPTY_ARRAY;
        }
    }

    public static class Pair {
        private final String part1;
        private final String part1Desc;
        private final String part2;
        private final String part2Desc;

        public Pair(String part1, String part1Desc, String part2, String part2Desc) {
            this.part1 = part1;
            this.part1Desc = part1Desc;
            this.part2 = part2;
            this.part2Desc = part2Desc;
        }

        public String toString() {
            return this.part1 + "/" + this.part2;
        }
    }

    static class WeightedRuleMatch
    implements Comparable<WeightedRuleMatch> {
        long weight;
        RuleMatch match;

        WeightedRuleMatch(long weight, RuleMatch match) {
            this.weight = weight;
            this.match = match;
        }

        @Override
        public int compareTo(@NotNull WeightedRuleMatch other) {
            return Long.compare(other.weight, this.weight);
        }
    }
}

