/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.de;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.similarity.LevenshteinDistance;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.language.German;
import org.languagetool.rules.Categories;
import org.languagetool.rules.Example;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.TextLevelRule;
import org.languagetool.rules.patterns.PatternRuleBuilderHelper;
import org.languagetool.rules.patterns.PatternToken;
import org.languagetool.rules.patterns.PatternTokenBuilder;
import org.languagetool.tagging.disambiguation.rules.DisambiguationPatternRule;
import org.languagetool.tools.StringTools;

public class VerbAgreementRule
extends TextLevelRule {
    private static final List<List<PatternToken>> ANTI_PATTERNS = Arrays.asList(Arrays.asList(PatternRuleBuilderHelper.token((String)"du"), PatternRuleBuilderHelper.token((String)"w\u00e4rst"), PatternRuleBuilderHelper.token((String)"ich")), Arrays.asList(PatternRuleBuilderHelper.token((String)"ich"), PatternRuleBuilderHelper.token((String)"schlafen"), PatternRuleBuilderHelper.token((String)"gehe")), Arrays.asList(PatternRuleBuilderHelper.token((String)"du"), PatternRuleBuilderHelper.token((String)"schlafen"), PatternRuleBuilderHelper.token((String)"gehst")), Arrays.asList(PatternRuleBuilderHelper.token((String)"per"), PatternRuleBuilderHelper.token((String)"du"), PatternRuleBuilderHelper.tokenRegex((String)"sind|waren|sein|w\u00e4ren|war|ist|gewesen")), Arrays.asList(PatternRuleBuilderHelper.token((String)"schnellst"), PatternRuleBuilderHelper.token((String)"m\u00f6glich")), Arrays.asList(PatternRuleBuilderHelper.token((String)"er"), PatternRuleBuilderHelper.token((String)"schlafen"), PatternRuleBuilderHelper.token((String)"geht")), Arrays.asList(PatternRuleBuilderHelper.token((String)"vermittelst")), Arrays.asList(PatternRuleBuilderHelper.token((String)"du"), PatternRuleBuilderHelper.token((String)"denkst"), PatternRuleBuilderHelper.token((String)"ich")), Arrays.asList(PatternRuleBuilderHelper.token((String)"na"), PatternRuleBuilderHelper.token((String)"komm")), Arrays.asList(PatternRuleBuilderHelper.tokenRegex((String)"mu\u00df|mu\u00dften?|m\u00fc\u00dft?en?"), PatternRuleBuilderHelper.tokenRegex((String)"ich|wir|sie|er|es")), Arrays.asList(PatternRuleBuilderHelper.token((String)"ich"), PatternRuleBuilderHelper.tokenRegex((String)"w\u00fcrd|k\u00f6nnt|werd|wollt|sollt|m\u00fcsst|f\u00fcrcht"), PatternRuleBuilderHelper.tokenRegex((String)"['\u2019`\u00b4\u2018]")), Arrays.asList(PatternRuleBuilderHelper.tokenRegex((String)"wir|sie|zu"), PatternRuleBuilderHelper.tokenRegex((String)"seh|steh|geh"), PatternRuleBuilderHelper.tokenRegex((String)"['\u2019`\u00b4\u2018]"), PatternRuleBuilderHelper.token((String)"n")), Arrays.asList(PatternRuleBuilderHelper.token((String)"ick"), PatternRuleBuilderHelper.tokenRegex((String)"bin|war|w\u00e4r|hab|hatte")), Arrays.asList(PatternRuleBuilderHelper.token((String)"#"), PatternRuleBuilderHelper.posRegex((String)"VER.*")), Arrays.asList(PatternRuleBuilderHelper.token((String)"wie"), PatternRuleBuilderHelper.tokenRegex((String)"du|ihr|er|es|sie"), PatternRuleBuilderHelper.tokenRegex((String)"bin|war"), PatternRuleBuilderHelper.token((String)"ich")), Arrays.asList(PatternRuleBuilderHelper.posRegex((String)"UNKNOWN|EIG.*"), PatternRuleBuilderHelper.token((String)"bin"), PatternRuleBuilderHelper.posRegex((String)"UNKNOWN|EIG.*")), Arrays.asList(PatternRuleBuilderHelper.tokenRegex((String)"du|sie"), PatternRuleBuilderHelper.tokenRegex((String)"schei(\u00df|ss)"), PatternRuleBuilderHelper.posRegex((String)"SUB.*|UNKNOWN")), Arrays.asList(PatternRuleBuilderHelper.token((String)"Du"), PatternRuleBuilderHelper.tokenRegex((String)"bist|warst|w\u00e4rst")), Arrays.asList(PatternRuleBuilderHelper.token((String)"als"), PatternRuleBuilderHelper.token((String)"auch"), PatternRuleBuilderHelper.tokenRegex((String)"er|sie|wir|du|ich|ihr")), Arrays.asList(PatternRuleBuilderHelper.tokenRegex((String)"so|wie|zu"), PatternRuleBuilderHelper.token((String)"lange"), PatternRuleBuilderHelper.tokenRegex((String)"er|sie|wir|du|ich|ihr")), Arrays.asList(new PatternTokenBuilder().tokenRegex("so|genauso|\u00e4hnlich").matchInflectedForms().setSkip(2).build(), PatternRuleBuilderHelper.token((String)"wie"), PatternRuleBuilderHelper.tokenRegex((String)"er|sie|du|ihr|ich"), PatternRuleBuilderHelper.posRegex((String)"VER.*")), Arrays.asList(PatternRuleBuilderHelper.pos((String)"SENT_START"), PatternRuleBuilderHelper.posRegex((String)"VER:2:SIN:.*"), PatternRuleBuilderHelper.posRegex((String)"ART.*|ADV.*|PRO:POS.*")), Arrays.asList(PatternRuleBuilderHelper.token((String)","), PatternRuleBuilderHelper.posRegex((String)"EIG:.*|UNKNOWN"), PatternRuleBuilderHelper.regex((String)"und|oder"), PatternRuleBuilderHelper.token((String)"auch"), PatternRuleBuilderHelper.token((String)"ich")), Arrays.asList(PatternRuleBuilderHelper.posRegex((String)"VER.*"), PatternRuleBuilderHelper.tokenRegex((String)"er|sie|ich|wir|du|es|ihr"), PatternRuleBuilderHelper.tokenRegex((String)"gleich|bereit|lange|schnelle?|halt|bitte|dank")), Arrays.asList(PatternRuleBuilderHelper.posRegex((String)"ADV.*|KON.*"), PatternRuleBuilderHelper.tokenRegex((String)"er|sie|ich|wir|du|es|ihr"), PatternRuleBuilderHelper.tokenRegex((String)"gleich|bereit|lange|schnelle?|halt|bitte|dank")), Arrays.asList(PatternRuleBuilderHelper.posRegex((String)"ADV.*|KON.*"), PatternRuleBuilderHelper.tokenRegex((String)"er|sie|ich|wir|du|es|ihr"), PatternRuleBuilderHelper.tokenRegex((String)"verlegen"), PatternRuleBuilderHelper.posRegex((String)"VER.*")), Arrays.asList(PatternRuleBuilderHelper.pos((String)"SENT_START"), PatternRuleBuilderHelper.posRegex((String)"VER:2:SIN:.*"), PatternRuleBuilderHelper.token((String)"nicht")), Arrays.asList(new PatternTokenBuilder().token("machen").matchInflectedForms().setSkip(-1).build(), PatternRuleBuilderHelper.token((String)"halt")), Arrays.asList(PatternRuleBuilderHelper.posRegex((String)"VER:.*"), PatternRuleBuilderHelper.tokenRegex((String)"du|ihr"), PatternRuleBuilderHelper.token((String)"auch")), Arrays.asList(PatternRuleBuilderHelper.token((String)"f\u00fcr"), PatternRuleBuilderHelper.token((String)"Sie"), PatternRuleBuilderHelper.pos((String)"VER:3:SIN:KJ1:SFT"), PatternRuleBuilderHelper.token((String)"ich")), Arrays.asList(PatternRuleBuilderHelper.tokenRegex((String)"(irgend)?einer?|(irgend)?jemand"), PatternRuleBuilderHelper.token((String)"wie"), PatternRuleBuilderHelper.token((String)"du"), PatternRuleBuilderHelper.posRegex((String)"VER:3:.*")), Arrays.asList(PatternRuleBuilderHelper.pos((String)"VER:MOD:2:SIN:PR\u00c4"), PatternRuleBuilderHelper.posRegex((String)"PRO:PER:.*")), Arrays.asList(PatternRuleBuilderHelper.tokenRegex((String)"die|welche"), PatternRuleBuilderHelper.tokenRegex((String)".*"), PatternRuleBuilderHelper.tokenRegex((String)"mehr|weniger"), PatternRuleBuilderHelper.token((String)"als"), PatternRuleBuilderHelper.tokenRegex((String)"ich|du|e[rs]|sie")), Arrays.asList(PatternRuleBuilderHelper.token((String)"wenn"), PatternRuleBuilderHelper.token((String)"du"), PatternRuleBuilderHelper.token((String)"anstelle")), Arrays.asList(PatternRuleBuilderHelper.tokenRegex((String)"ok(ay)?|ja|nein|vielleicht|oh"), PatternRuleBuilderHelper.tokenRegex((String)"bin|sind")), Arrays.asList(PatternRuleBuilderHelper.token((String)"das"), PatternRuleBuilderHelper.csToken((String)"Du"), new PatternTokenBuilder().token("anbieten").matchInflectedForms().build()), Arrays.asList(PatternRuleBuilderHelper.csToken((String)"Du"), new PatternTokenBuilder().tokenRegex("anreden|ansprechen").matchInflectedForms().build()), Arrays.asList(PatternRuleBuilderHelper.posRegex((String)"SUB:.*PLU.*"), PatternRuleBuilderHelper.token((String)"wie"), PatternRuleBuilderHelper.token((String)"Du"), PatternRuleBuilderHelper.posRegex((String)"VER:3:PLU.*")), Arrays.asList(PatternRuleBuilderHelper.token((String)"w\u00fcrd"), PatternRuleBuilderHelper.tokenRegex((String)"[nm]ich|man|ichs|'")), Arrays.asList(PatternRuleBuilderHelper.token((String)","), PatternRuleBuilderHelper.posRegex((String)"VER:MOD:2:.*")), Arrays.asList(PatternRuleBuilderHelper.csToken((String)"Soll"), PatternRuleBuilderHelper.token((String)"ich")), Arrays.asList(PatternRuleBuilderHelper.csToken((String)"Solltest"), PatternRuleBuilderHelper.token((String)"du")), Arrays.asList(PatternRuleBuilderHelper.csToken((String)"M\u00fcsstest"), PatternRuleBuilderHelper.token((String)"dir")), Arrays.asList(PatternRuleBuilderHelper.csToken((String)"K\u00f6nntest"), PatternRuleBuilderHelper.token((String)"dir")), Arrays.asList(PatternRuleBuilderHelper.csToken((String)"Sollte"), PatternRuleBuilderHelper.tokenRegex((String)"er|sie")), Arrays.asList(PatternRuleBuilderHelper.pos((String)"SENT_START"), PatternRuleBuilderHelper.tokenRegex((String)"Bin|Kannst|Musst")), Arrays.asList(PatternRuleBuilderHelper.token((String)","), PatternRuleBuilderHelper.tokenRegex((String)"bin|hast|kannst|musst")), Arrays.asList(PatternRuleBuilderHelper.token((String)"er"), PatternRuleBuilderHelper.posRegex((String)"VER:.*"), PatternRuleBuilderHelper.token((String)"wird")), Arrays.asList(PatternRuleBuilderHelper.tokenRegex((String)"wie|als"), PatternRuleBuilderHelper.token((String)"ich"), PatternRuleBuilderHelper.posRegex((String)"VER:.*")), Arrays.asList(PatternRuleBuilderHelper.tokenRegex((String)"ich"), PatternRuleBuilderHelper.pos((String)"VER:INF:NON"), PatternRuleBuilderHelper.token((String)"werde")), Arrays.asList(PatternRuleBuilderHelper.pos((String)"VER:IMP:SIN:SFT"), PatternRuleBuilderHelper.token((String)"du"), PatternRuleBuilderHelper.tokenRegex((String)"dich|dein|deine[srnm]?")), Arrays.asList(PatternRuleBuilderHelper.token((String)"sei"), PatternRuleBuilderHelper.token((String)"du"), PatternRuleBuilderHelper.token((String)"selbst")), Arrays.asList(PatternRuleBuilderHelper.token((String)"als"), PatternRuleBuilderHelper.token((String)"ich"), PatternRuleBuilderHelper.posRegex((String)"PA2:.*"), PatternRuleBuilderHelper.token((String)"bin")), Arrays.asList(PatternRuleBuilderHelper.token((String)"als"), PatternRuleBuilderHelper.tokenRegex((String)"du|e[rs]|sie|ich"), new PatternTokenBuilder().token("sein").matchInflectedForms().build(), PatternRuleBuilderHelper.tokenRegex((String)"[\\.,]")), Arrays.asList(PatternRuleBuilderHelper.tokenRegex((String)"D[au]rf.*|Muss.*"), PatternRuleBuilderHelper.posRegex((String)"PRO:PER:NOM:.+"), PatternRuleBuilderHelper.posRegex((String)"VER:INF:.+"), PatternRuleBuilderHelper.pos((String)"PKT"), PatternRuleBuilderHelper.tokenRegex((String)"(?!die).+")), Arrays.asList(PatternRuleBuilderHelper.csToken((String)"("), PatternRuleBuilderHelper.posRegex((String)"VER:2:SIN:.+"), PatternRuleBuilderHelper.csToken((String)")")), Arrays.asList(PatternRuleBuilderHelper.posRegex((String)"VER:MOD:1:PLU:.+"), PatternRuleBuilderHelper.csToken((String)"wir"), PatternRuleBuilderHelper.csToken((String)"bitte")), Arrays.asList(PatternRuleBuilderHelper.token((String)"ohne"), PatternRuleBuilderHelper.token((String)"sie"), PatternRuleBuilderHelper.token((String)"h\u00e4tte"), PatternRuleBuilderHelper.token((String)"ich")), Arrays.asList(PatternRuleBuilderHelper.pos((String)"SENT_START"), PatternRuleBuilderHelper.posRegex((String)"VER:IMP:SIN.+"), PatternRuleBuilderHelper.csToken((String)"du"), new PatternTokenBuilder().csToken("?").negate().build()), Arrays.asList(PatternRuleBuilderHelper.tokenRegex((String)"[^a-z\u00e4\u00f6\u00fc\u00df]+du"), PatternRuleBuilderHelper.pos((String)"VER:2:SIN:PR\u00c4:SFT")), Arrays.asList(PatternRuleBuilderHelper.posRegex((String)"PRO:IND.*"), PatternRuleBuilderHelper.posRegex((String)"SUB:.+:PLU.*"), PatternRuleBuilderHelper.tokenRegex((String)"wie|als"), PatternRuleBuilderHelper.posRegex((String)"PRO:PER.+"), PatternRuleBuilderHelper.posRegex((String)"VER:[1-3]:PLU.*")), Arrays.asList(PatternRuleBuilderHelper.pos((String)"ADV:MOD"), PatternRuleBuilderHelper.tokenRegex((String)"als"), PatternRuleBuilderHelper.posRegex((String)"PRO:PER.+"), PatternRuleBuilderHelper.posRegex((String)"VER:3:SIN.*"), PatternRuleBuilderHelper.posRegex((String)"PRO:IND:NOM:SIN.*")), Arrays.asList(PatternRuleBuilderHelper.posRegex((String)"PRO:IND.*"), PatternRuleBuilderHelper.tokenRegex((String)"wie"), PatternRuleBuilderHelper.posRegex((String)"PRO:PER.+"), PatternRuleBuilderHelper.posRegex((String)"VER:.*:SIN.*"), PatternRuleBuilderHelper.posRegex((String)"PRO:PER:NOM:SIN.*")), Arrays.asList(PatternRuleBuilderHelper.tokenRegex((String)"kein|keine"), PatternRuleBuilderHelper.tokenRegex((String)"anderer|andere"), PatternRuleBuilderHelper.token((String)"als"), PatternRuleBuilderHelper.tokenRegex((String)"ich|du|er|sie|es"), PatternRuleBuilderHelper.posRegex((String)"VER:MOD.*:PR\u00c4")), Arrays.asList(PatternRuleBuilderHelper.posRegex((String)"ART:DEF.*"), PatternRuleBuilderHelper.tokenRegex((String)"gleich(e|en)|selb(e|en)"), PatternRuleBuilderHelper.posRegex((String)"SUB:.+"), PatternRuleBuilderHelper.token((String)"wie"), PatternRuleBuilderHelper.posRegex((String)"PRO:PER:NOM:SIN.*"), PatternRuleBuilderHelper.posRegex((String)"VER:INF.*")), Arrays.asList(PatternRuleBuilderHelper.token((String)"wenn"), PatternRuleBuilderHelper.posRegex((String)"PRO:PER:NOM:SIN.+"), PatternRuleBuilderHelper.posRegex((String)"PRO:PER:NOM.+"), PatternRuleBuilderHelper.posRegex((String)"VER:AUX:[1-3]:SIN:KJ2")), Arrays.asList(PatternRuleBuilderHelper.token((String)"wenn"), PatternRuleBuilderHelper.posRegex((String)"PRO:PER:NOM:PLU.+"), PatternRuleBuilderHelper.posRegex((String)"PRO:PER:NOM.+"), PatternRuleBuilderHelper.posRegex((String)"VER:AUX:[1-3]:PLU:KJ2")), Arrays.asList(PatternRuleBuilderHelper.token((String)"wenn"), PatternRuleBuilderHelper.token((String)"du"), PatternRuleBuilderHelper.token((String)"gehen"), PatternRuleBuilderHelper.token((String)"willst"), PatternRuleBuilderHelper.token((String)","), PatternRuleBuilderHelper.token((String)"dann"), PatternRuleBuilderHelper.token((String)"geh")), Arrays.asList(PatternRuleBuilderHelper.token((String)"ob"), PatternRuleBuilderHelper.token((String)"ich"), PatternRuleBuilderHelper.posRegex((String)"VER:1.+"), PatternRuleBuilderHelper.token((String)"oder"), PatternRuleBuilderHelper.posRegex((String)"VER:1.+"), new PatternTokenBuilder().token("gehen").matchInflectedForms().build(), PatternRuleBuilderHelper.posRegex((String)"VER:MOD:1.*")), Arrays.asList(PatternRuleBuilderHelper.token((String)"mal"), PatternRuleBuilderHelper.token((String)"seh"), PatternRuleBuilderHelper.tokenRegex((String)"\u2019|'"), PatternRuleBuilderHelper.token((String)"n")));
    private static final Set<String> BIN_IGNORE = new HashSet<String>(Arrays.asList("Suleiman", "Mohamed", "Muhammad", "Muhammed", "Mohammed", "Mohammad", "Mansour", "Qaboos", "Qabus", "Tamim", "Majid", "Salman", "Ghazi", "Mahathir", "Madschid", "Maktum", "al-Aziz", "Asis", "Numan", "Hussein", "Abdul", "Abdulla", "Abdullah", "Isa", "Osama", "Said", "Zayid", "Zayed", "Hamad", "Chalifa", "Raschid", "Turki", "/"));
    private static final Set<String> CONJUNCTIONS = new HashSet<String>(Arrays.asList("weil", "obwohl", "dass", "indem", "sodass"));
    private static final Set<String> QUOTATION_MARKS = new HashSet<String>(Arrays.asList("\"", "\u201e"));
    private final German language;
    private final Supplier<List<DisambiguationPatternRule>> antiPatterns;

    public VerbAgreementRule(ResourceBundle messages, German language) {
        this.language = language;
        super.setCategory(Categories.GRAMMAR.getCategory(messages));
        this.addExamplePair(Example.wrong((String)"Ich <marker>bist</marker> \u00fcber die Entwicklung sehr froh."), Example.fixed((String)"Ich <marker>bin</marker> \u00fcber die Entwicklung sehr froh."));
        this.antiPatterns = VerbAgreementRule.cacheAntiPatterns((Language)language, ANTI_PATTERNS);
    }

    public String getId() {
        return "DE_VERBAGREEMENT";
    }

    public String getDescription() {
        return "Kongruenz von Subjekt und Pr\u00e4dikat (nur 1. u. 2. Person oder m. Personalpronomen), z.B. 'Er bist (ist)'";
    }

    public RuleMatch[] match(List<AnalyzedSentence> sentences) {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        int pos = 0;
        for (AnalyzedSentence sentence : sentences) {
            AnalyzedSentence partialSentence;
            int idx = 0;
            AnalyzedTokenReadings[] tokens = sentence.getTokens();
            for (int i = 2; i < tokens.length; ++i) {
                if (!",".equals(tokens[i - 2].getToken()) || !CONJUNCTIONS.contains(tokens[i].getToken())) continue;
                partialSentence = new AnalyzedSentence(Arrays.copyOfRange(tokens, idx, i));
                ruleMatches.addAll(this.match(partialSentence, pos, sentence));
                idx = i;
            }
            partialSentence = new AnalyzedSentence(Arrays.copyOfRange(tokens, idx, tokens.length));
            ruleMatches.addAll(this.match(partialSentence, pos, sentence));
            pos += sentence.getCorrectedTextLength();
        }
        return this.toRuleMatchArray(ruleMatches);
    }

    private List<RuleMatch> match(AnalyzedSentence sentence, int pos, AnalyzedSentence wholeSentence) {
        BooleanAndFiniteVerb check;
        int plus1;
        AnalyzedTokenReadings finiteVerb = null;
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        AnalyzedTokenReadings[] tokens = this.getSentenceWithImmunization(sentence).getTokensWithoutWhitespace();
        if (tokens.length < 4) {
            return ruleMatches;
        }
        int posIch = -1;
        int posDu = -1;
        int posEr = -1;
        int posWir = -1;
        int posVer1Sin = -1;
        int posVer2Sin = -1;
        int posVer1Plu = -1;
        int posPossibleVer1Sin = -1;
        int posPossibleVer2Sin = -1;
        int posPossibleVer3Sin = -1;
        int posPossibleVer1Plu = -1;
        for (int i = 1; i < tokens.length; ++i) {
            String strToken = tokens[i].getToken().toLowerCase();
            switch (strToken = strToken.replace("\u201a", "")) {
                case "ich": {
                    posIch = i;
                    break;
                }
                case "du": {
                    posDu = i;
                    break;
                }
                case "er": {
                    posEr = i;
                    break;
                }
                case "wir": {
                    posWir = i;
                }
            }
            if (!tokens[i].hasPartialPosTag("VER") || !Character.isLowerCase(tokens[i].getToken().charAt(0)) && i != 1 && !this.isQuotationMark(tokens[i - 1])) continue;
            if (!(!this.hasUnambiguouslyPersonAndNumber(tokens[i], "1", "SIN") || strToken.equals("bin") && (BIN_IGNORE.contains(tokens[i - 1].getToken()) || tokens.length != i + 1 && tokens[i + 1].getToken().startsWith("Laden")))) {
                posVer1Sin = i;
            } else if (this.hasUnambiguouslyPersonAndNumber(tokens[i], "2", "SIN") && !"Probst".equals(tokens[i].getToken())) {
                posVer2Sin = i;
            } else if (this.hasUnambiguouslyPersonAndNumber(tokens[i], "1", "PLU")) {
                posVer1Plu = i;
            }
            if (tokens[i].hasPartialPosTag(":1:SIN")) {
                posPossibleVer1Sin = i;
            }
            if (tokens[i].hasPartialPosTag(":2:SIN")) {
                posPossibleVer2Sin = i;
            }
            if (tokens[i].hasPartialPosTag(":3:SIN")) {
                posPossibleVer3Sin = i;
            }
            if (!tokens[i].hasPartialPosTag(":1:PLU")) continue;
            posPossibleVer1Plu = i;
        }
        if (posVer1Sin != -1 && posIch == -1 && !this.isQuotationMark(tokens[posVer1Sin - 1])) {
            if (!tokens[posVer1Sin].isImmunized()) {
                ruleMatches.add(this.ruleMatchWrongVerb(tokens[posVer1Sin], pos, wholeSentence));
            }
        } else if (posIch > 0 && !this.isNear(posPossibleVer1Sin, posIch) && (tokens[posIch].getToken().equals("ich") || tokens[posIch].getStartPos() <= 1 || tokens[posIch].getToken().equals("Ich") && posIch >= 2 && tokens[posIch - 2].getToken().equals(":") || tokens[posIch].getToken().equals("Ich") && posIch >= 1 && tokens[posIch - 1].getToken().equals(":")) && (!this.isQuotationMark(tokens[posIch - 1]) || posIch < 3 || posIch > 1 && tokens[posIch - 2].getToken().equals(":"))) {
            plus1 = posIch + 1 == tokens.length ? 0 : 1;
            check = this.verbDoesMatchPersonAndNumber(tokens[posIch - 1], tokens[posIch + plus1], "1", "SIN", finiteVerb);
            if (!(check.verbDoesMatchPersonAndNumber || this.nextButOneIsModal(tokens, posIch) || "\u00e4u\u00dferst".equals(check.finiteVerb.getToken()) || tokens[posIch].isImmunized())) {
                ruleMatches.add(this.ruleMatchWrongVerbSubject(tokens[posIch], check.finiteVerb, "1:SIN", pos, wholeSentence));
            }
        }
        if (posVer2Sin != -1 && posDu == -1 && !this.isQuotationMark(tokens[posVer2Sin - 1])) {
            if (!tokens[posVer2Sin].isImmunized()) {
                ruleMatches.add(this.ruleMatchWrongVerb(tokens[posVer2Sin], pos, wholeSentence));
            }
        } else if (posDu > 0 && !this.isNear(posPossibleVer2Sin, posDu) && (!this.isQuotationMark(tokens[posDu - 1]) || posDu < 3 || posDu > 1 && tokens[posDu - 2].getToken().equals(":"))) {
            plus1 = posDu + 1 == tokens.length ? 0 : 1;
            check = this.verbDoesMatchPersonAndNumber(tokens[posDu - 1], tokens[posDu + plus1], "2", "SIN", finiteVerb);
            if (!(check.verbDoesMatchPersonAndNumber || tokens[posDu + plus1].hasPosTagStartingWith("VER:1:SIN:KJ2") || tokens[posDu + plus1].hasPosTagStartingWith("ADJ:") && !tokens[posDu + plus1].hasPosTag("ADJ:PRD:GRU") || tokens[posDu - 1].hasPosTagStartingWith("VER:1:SIN:KJ2") || this.nextButOneIsModal(tokens, posDu) || tokens[posDu].isImmunized())) {
                ruleMatches.add(this.ruleMatchWrongVerbSubject(tokens[posDu], check.finiteVerb, "2:SIN", pos, wholeSentence));
            }
        }
        if (posEr > 0 && !this.isNear(posPossibleVer3Sin, posEr) && (!this.isQuotationMark(tokens[posEr - 1]) || posEr < 3 || posEr > 1 && tokens[posEr - 2].getToken().equals(":"))) {
            plus1 = posEr + 1 == tokens.length ? 0 : 1;
            check = this.verbDoesMatchPersonAndNumber(tokens[posEr - 1], tokens[posEr + plus1], "3", "SIN", finiteVerb);
            if (!(check.verbDoesMatchPersonAndNumber || this.nextButOneIsModal(tokens, posEr) || "\u00e4u\u00dferst".equals(check.finiteVerb.getToken()) || "regen".equals(check.finiteVerb.getToken()) || tokens[posEr].isImmunized())) {
                ruleMatches.add(this.ruleMatchWrongVerbSubject(tokens[posEr], check.finiteVerb, "3:SIN", pos, wholeSentence));
            }
        }
        if (posVer1Plu != -1 && posWir == -1 && !this.isQuotationMark(tokens[posVer1Plu - 1])) {
            if (!tokens[posVer1Plu].isImmunized()) {
                ruleMatches.add(this.ruleMatchWrongVerb(tokens[posVer1Plu], pos, wholeSentence));
            }
        } else if (posWir > 0 && !this.isNear(posPossibleVer1Plu, posWir) && !this.isQuotationMark(tokens[posWir - 1])) {
            plus1 = posWir + 1 == tokens.length ? 0 : 1;
            check = this.verbDoesMatchPersonAndNumber(tokens[posWir - 1], tokens[posWir + plus1], "1", "PLU", finiteVerb);
            if (!(check.verbDoesMatchPersonAndNumber || this.nextButOneIsModal(tokens, posWir) || tokens[posWir].isImmunized() || check.finiteVerb.getToken().equals("\u00e4u\u00dferst"))) {
                ruleMatches.add(this.ruleMatchWrongVerbSubject(tokens[posWir], check.finiteVerb, "1:PLU", pos, wholeSentence));
            }
        }
        return ruleMatches;
    }

    public List<DisambiguationPatternRule> getAntiPatterns() {
        return this.antiPatterns.get();
    }

    private boolean nextButOneIsModal(AnalyzedTokenReadings[] tokens, int pos) {
        return pos < tokens.length - 2 && tokens[pos + 2].hasPartialPosTag(":MOD:");
    }

    private boolean isNear(int a, int b) {
        return a != -1 && Math.abs(a - b) < 5;
    }

    private boolean isQuotationMark(AnalyzedTokenReadings token) {
        return QUOTATION_MARKS.contains(token.getToken());
    }

    private boolean hasUnambiguouslyPersonAndNumber(AnalyzedTokenReadings tokenReadings, String person, String number) {
        if (tokenReadings.getToken().length() == 0 || Character.isUpperCase(tokenReadings.getToken().charAt(0)) && tokenReadings.getStartPos() != 0 || !tokenReadings.hasPosTagStartingWith("VER")) {
            return false;
        }
        for (AnalyzedToken analyzedToken : tokenReadings) {
            String postag = analyzedToken.getPOSTag();
            if (postag == null || postag.endsWith("_END") || postag.contains(":" + person + ":" + number)) continue;
            return false;
        }
        return true;
    }

    private boolean isFiniteVerb(AnalyzedTokenReadings token) {
        if (token.getToken().length() == 0 || Character.isUpperCase(token.getToken().charAt(0)) && token.getStartPos() != 0 || !token.hasPosTagStartingWith("VER") || token.hasAnyPartialPosTag(new String[]{"PA2", "PRO:", "ZAL"}) || "einst".equals(token.getToken())) {
            return false;
        }
        return token.hasAnyPartialPosTag(new String[]{":1:", ":2:", ":3:"});
    }

    private BooleanAndFiniteVerb verbDoesMatchPersonAndNumber(AnalyzedTokenReadings token1, AnalyzedTokenReadings token2, String person, String number, AnalyzedTokenReadings finiteVerb) {
        if (StringUtils.equalsAny((CharSequence)token1.getToken(), (CharSequence[])new CharSequence[]{",", "und", "sowie", "&"}) || StringUtils.equalsAny((CharSequence)token2.getToken(), (CharSequence[])new CharSequence[]{",", "und", "sowie", "&"})) {
            return new BooleanAndFiniteVerb(true, finiteVerb);
        }
        boolean foundFiniteVerb = false;
        if (this.isFiniteVerb(token1)) {
            foundFiniteVerb = true;
            finiteVerb = token1;
            if (token1.hasPartialPosTag(":" + person + ":" + number)) {
                return new BooleanAndFiniteVerb(true, finiteVerb);
            }
        }
        if (this.isFiniteVerb(token2)) {
            foundFiniteVerb = true;
            finiteVerb = token2;
            if (token2.hasPartialPosTag(":" + person + ":" + number)) {
                return new BooleanAndFiniteVerb(true, finiteVerb);
            }
        }
        return new BooleanAndFiniteVerb(!foundFiniteVerb, finiteVerb);
    }

    private List<String> getVerbSuggestions(AnalyzedTokenReadings verb, String expectedVerbPOS, boolean toUppercase) {
        AnalyzedToken verbToken = new AnalyzedToken("", "", "");
        for (AnalyzedToken token : verb.getReadings()) {
            if (!token.getPOSTag().startsWith("VER:")) continue;
            verbToken = token;
            break;
        }
        try {
            String[] synthesized = this.language.getSynthesizer().synthesize(verbToken, "VER.*:" + expectedVerbPOS + ".*", true);
            HashSet<String> suggestionSet = new HashSet<String>(Arrays.asList(synthesized));
            ArrayList<String> suggestions = new ArrayList<String>(suggestionSet);
            if (toUppercase) {
                for (int i = 0; i < suggestions.size(); ++i) {
                    suggestions.set(i, StringTools.uppercaseFirstChar((String)((String)suggestions.get(i))));
                }
            }
            return suggestions;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private List<String> getPronounSuggestions(AnalyzedTokenReadings verb, boolean toUppercase) {
        ArrayList<String> result = new ArrayList<String>();
        if (verb.hasPartialPosTag(":1:SIN")) {
            result.add("ich");
        }
        if (verb.hasPartialPosTag(":2:SIN")) {
            result.add("du");
        }
        if (verb.hasPartialPosTag(":3:SIN")) {
            result.add("er");
            result.add("sie");
            result.add("es");
        }
        if (verb.hasPartialPosTag(":1:PLU")) {
            result.add("wir");
        }
        if (verb.hasPartialPosTag(":2:PLU")) {
            result.add("ihr");
        }
        if (verb.hasPartialPosTag(":3:PLU") && !result.contains("sie")) {
            result.add("sie");
        }
        if (toUppercase) {
            for (int i = 0; i < result.size(); ++i) {
                result.set(i, StringTools.uppercaseFirstChar((String)((String)result.get(i))));
            }
        }
        return result;
    }

    private RuleMatch ruleMatchWrongVerb(AnalyzedTokenReadings token, int pos, AnalyzedSentence sentence) {
        String msg = "M\u00f6glicherweise fehlende grammatische \u00dcbereinstimmung zwischen Subjekt und Pr\u00e4dikat (" + token.getToken() + ") bez\u00fcglich Person oder Numerus (Einzahl, Mehrzahl - Beispiel: 'Max bist' statt 'Max ist').";
        return new RuleMatch((Rule)this, sentence, pos + token.getStartPos(), pos + token.getEndPos(), msg);
    }

    private RuleMatch ruleMatchWrongVerbSubject(AnalyzedTokenReadings subject, AnalyzedTokenReadings verb, String expectedVerbPOS, int pos, AnalyzedSentence sentence) {
        RuleMatch ruleMatch;
        String msg = "M\u00f6glicherweise fehlende grammatische \u00dcbereinstimmung zwischen Subjekt (" + subject.getToken() + ") und Pr\u00e4dikat (" + verb.getToken() + ") bez\u00fcglich Person oder Numerus (Einzahl, Mehrzahl - Beispiel: 'ich sind' statt 'ich bin').";
        ArrayList<String> suggestions = new ArrayList<String>();
        ArrayList<String> verbSuggestions = new ArrayList<String>();
        ArrayList<String> pronounSuggestions = new ArrayList<String>();
        if (subject.getStartPos() < verb.getStartPos()) {
            ruleMatch = new RuleMatch((Rule)this, sentence, pos + subject.getStartPos(), pos + verb.getStartPos() + verb.getToken().length(), msg);
            verbSuggestions.addAll(this.getVerbSuggestions(verb, expectedVerbPOS, false));
            for (String verbSuggestion : verbSuggestions) {
                suggestions.add(subject.getToken() + " " + verbSuggestion);
            }
            pronounSuggestions.addAll(this.getPronounSuggestions(verb, Character.isUpperCase(subject.getToken().charAt(0))));
            for (String pronounSuggestion : pronounSuggestions) {
                suggestions.add(pronounSuggestion + " " + verb.getToken());
            }
            String markedText = sentence.getText().substring(subject.getStartPos(), verb.getStartPos() + verb.getToken().length());
            this.sortBySimilarity(suggestions, markedText);
            ruleMatch.setSuggestedReplacements(suggestions);
        } else {
            ruleMatch = new RuleMatch((Rule)this, sentence, pos + verb.getStartPos(), pos + subject.getStartPos() + subject.getToken().length(), msg);
            verbSuggestions.addAll(this.getVerbSuggestions(verb, expectedVerbPOS, Character.isUpperCase(verb.getToken().charAt(0))));
            for (String verbSuggestion : verbSuggestions) {
                suggestions.add(verbSuggestion + " " + subject.getToken());
            }
            pronounSuggestions.addAll(this.getPronounSuggestions(verb, false));
            for (String pronounSuggestion : pronounSuggestions) {
                suggestions.add(verb.getToken() + " " + pronounSuggestion);
            }
            String markedText = sentence.getText().substring(verb.getStartPos(), subject.getStartPos() + subject.getToken().length());
            this.sortBySimilarity(suggestions, markedText);
            ruleMatch.setSuggestedReplacements(suggestions);
        }
        return ruleMatch;
    }

    private void sortBySimilarity(List<String> suggestions, String markedText) {
        suggestions.sort((o1, o2) -> {
            int diff1 = LevenshteinDistance.getDefaultInstance().apply((CharSequence)markedText, (CharSequence)o1);
            int diff2 = LevenshteinDistance.getDefaultInstance().apply((CharSequence)markedText, (CharSequence)o2);
            return diff1 - diff2;
        });
    }

    public int minToCheckParagraph() {
        return 0;
    }

    static class BooleanAndFiniteVerb {
        boolean verbDoesMatchPersonAndNumber;
        AnalyzedTokenReadings finiteVerb;

        private BooleanAndFiniteVerb(boolean verbDoesMatchPersonAndNumber, AnalyzedTokenReadings finiteVerb) {
            this.verbDoesMatchPersonAndNumber = verbDoesMatchPersonAndNumber;
            this.finiteVerb = finiteVerb;
        }
    }
}

