/*
 * Decompiled with CFR 0.152.
 */
package org.lenskit.mf.svd;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.annotation.Nullable;
import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.RealVector;
import org.lenskit.util.keys.KeyIndex;

public class MFModel
implements Serializable {
    private static final long serialVersionUID = 2L;
    protected int featureCount;
    protected int userCount;
    protected int itemCount;
    protected RealMatrix userMatrix;
    protected RealMatrix itemMatrix;
    protected KeyIndex userIndex;
    protected KeyIndex itemIndex;

    public MFModel(RealMatrix umat, RealMatrix imat, KeyIndex uidx, KeyIndex iidx) {
        Preconditions.checkArgument((umat.getColumnDimension() == imat.getColumnDimension() ? 1 : 0) != 0, (Object)"mismatched matrix sizes");
        this.featureCount = umat.getColumnDimension();
        this.userCount = uidx.size();
        this.itemCount = iidx.size();
        Preconditions.checkArgument((umat.getRowDimension() == this.userCount ? 1 : 0) != 0, (String)"user matrix has %s rows, expected %s", (Object[])new Object[]{umat.getRowDimension(), this.userCount});
        Preconditions.checkArgument((imat.getRowDimension() == this.itemCount ? 1 : 0) != 0, (String)"item matrix has %s rows, expected %s", (Object[])new Object[]{imat.getRowDimension(), this.itemCount});
        this.userMatrix = umat;
        this.itemMatrix = imat;
        this.userIndex = uidx;
        this.itemIndex = iidx;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        int j;
        int i;
        out.writeInt(this.featureCount);
        out.writeInt(this.userCount);
        out.writeInt(this.itemCount);
        for (i = 0; i < this.userCount; ++i) {
            for (j = 0; j < this.featureCount; ++j) {
                out.writeDouble(this.userMatrix.getEntry(i, j));
            }
        }
        for (i = 0; i < this.itemCount; ++i) {
            for (j = 0; j < this.featureCount; ++j) {
                out.writeDouble(this.itemMatrix.getEntry(i, j));
            }
        }
        out.writeObject(this.userIndex);
        out.writeObject(this.itemIndex);
    }

    private void readObject(ObjectInputStream input) throws IOException, ClassNotFoundException {
        this.featureCount = input.readInt();
        this.userCount = input.readInt();
        this.itemCount = input.readInt();
        RealMatrix umat = MatrixUtils.createRealMatrix((int)this.userCount, (int)this.featureCount);
        for (int i = 0; i < this.userCount; ++i) {
            for (int j = 0; j < this.featureCount; ++j) {
                umat.setEntry(i, j, input.readDouble());
            }
        }
        this.userMatrix = umat;
        RealMatrix imat = MatrixUtils.createRealMatrix((int)this.itemCount, (int)this.featureCount);
        for (int i = 0; i < this.itemCount; ++i) {
            for (int j = 0; j < this.featureCount; ++j) {
                imat.setEntry(i, j, input.readDouble());
            }
        }
        this.itemMatrix = imat;
        this.userIndex = (KeyIndex)input.readObject();
        this.itemIndex = (KeyIndex)input.readObject();
        if (this.userIndex.size() != this.userMatrix.getRowDimension()) {
            throw new InvalidObjectException("user matrix and index have different row counts");
        }
        if (this.itemIndex.size() != this.itemMatrix.getRowDimension()) {
            throw new InvalidObjectException("item matrix and index have different row counts");
        }
    }

    public int getFeatureCount() {
        return this.featureCount;
    }

    public int getUserCount() {
        return this.userCount;
    }

    public int getItemCount() {
        return this.itemCount;
    }

    public KeyIndex getItemIndex() {
        return this.itemIndex;
    }

    public KeyIndex getUserIndex() {
        return this.userIndex;
    }

    public RealMatrix getUserMatrix() {
        return this.userMatrix;
    }

    public RealMatrix getItemMatrix() {
        return this.itemMatrix;
    }

    @Nullable
    public RealVector getUserVector(long user) {
        int uidx = this.userIndex.tryGetIndex(user);
        if (uidx < 0) {
            return null;
        }
        return this.userMatrix.getRowVector(uidx);
    }

    @Nullable
    public RealVector getItemVector(long item) {
        int iidx = this.itemIndex.tryGetIndex(item);
        if (iidx < 0) {
            return null;
        }
        return this.itemMatrix.getRowVector(iidx);
    }

    public double getUserFeature(long uid, int feature) {
        int uidx = this.userIndex.tryGetIndex(uid);
        if (uidx < 0) {
            return 0.0;
        }
        return this.userMatrix.getEntry(uidx, feature);
    }

    public double getItemFeature(long iid, int feature) {
        int iidx = this.itemIndex.tryGetIndex(iid);
        if (iidx < 0) {
            return 0.0;
        }
        return this.itemMatrix.getEntry(iidx, feature);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("(nu=").append(this.getUserCount()).append(", ni=").append(this.getItemCount()).append(", nf=").append(this.getFeatureCount()).append(")");
        return sb.toString();
    }
}

