/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.processor.creation;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.mapstruct.ap.internal.conversion.ConversionProvider;
import org.mapstruct.ap.internal.conversion.Conversions;
import org.mapstruct.ap.internal.model.HelperMethod;
import org.mapstruct.ap.internal.model.MapperReference;
import org.mapstruct.ap.internal.model.MappingBuilderContext;
import org.mapstruct.ap.internal.model.MethodReference;
import org.mapstruct.ap.internal.model.SourceRHS;
import org.mapstruct.ap.internal.model.VirtualMappingMethod;
import org.mapstruct.ap.internal.model.assignment.Assignment;
import org.mapstruct.ap.internal.model.common.DefaultConversionContext;
import org.mapstruct.ap.internal.model.common.Type;
import org.mapstruct.ap.internal.model.common.TypeFactory;
import org.mapstruct.ap.internal.model.source.FormattingParameters;
import org.mapstruct.ap.internal.model.source.Method;
import org.mapstruct.ap.internal.model.source.SelectionParameters;
import org.mapstruct.ap.internal.model.source.SourceMethod;
import org.mapstruct.ap.internal.model.source.builtin.BuiltInMappingMethods;
import org.mapstruct.ap.internal.model.source.builtin.BuiltInMethod;
import org.mapstruct.ap.internal.model.source.selector.MethodSelectors;
import org.mapstruct.ap.internal.model.source.selector.SelectionCriteria;
import org.mapstruct.ap.internal.util.Collections;
import org.mapstruct.ap.internal.util.FormattingMessager;
import org.mapstruct.ap.internal.util.Message;
import org.mapstruct.ap.internal.util.Strings;

public class MappingResolverImpl
implements MappingBuilderContext.MappingResolver {
    private final FormattingMessager messager;
    private final Types typeUtils;
    private final TypeFactory typeFactory;
    private final List<SourceMethod> sourceModel;
    private final List<MapperReference> mapperReferences;
    private final Conversions conversions;
    private final BuiltInMappingMethods builtInMethods;
    private final MethodSelectors methodSelectors;
    private final Set<VirtualMappingMethod> usedVirtualMappings = new HashSet<VirtualMappingMethod>();

    public MappingResolverImpl(FormattingMessager messager, Elements elementUtils, Types typeUtils, TypeFactory typeFactory, List<SourceMethod> sourceModel, List<MapperReference> mapperReferences) {
        this.messager = messager;
        this.typeUtils = typeUtils;
        this.typeFactory = typeFactory;
        this.sourceModel = sourceModel;
        this.mapperReferences = mapperReferences;
        this.conversions = new Conversions(elementUtils, typeFactory);
        this.builtInMethods = new BuiltInMappingMethods(typeFactory);
        this.methodSelectors = new MethodSelectors(typeUtils, elementUtils, typeFactory);
    }

    @Override
    public Assignment getTargetAssignment(Method mappingMethod, String mappedElement, Type sourceType, Type targetType, String targetPropertyName, FormattingParameters formattingParameters, SelectionParameters selectionParameters, SourceRHS sourceRHS, boolean preferUpdateMapping) {
        SelectionCriteria criteria = new SelectionCriteria(selectionParameters, targetPropertyName, preferUpdateMapping);
        String dateFormat = null;
        String numberFormat = null;
        if (formattingParameters != null) {
            dateFormat = formattingParameters.getDate();
            numberFormat = formattingParameters.getNumber();
        }
        ResolvingAttempt attempt = new ResolvingAttempt(this.sourceModel, mappingMethod, mappedElement, dateFormat, numberFormat, sourceRHS, criteria);
        return attempt.getTargetAssignment(sourceType, targetType);
    }

    @Override
    public Set<VirtualMappingMethod> getUsedVirtualMappings() {
        return this.usedVirtualMappings;
    }

    @Override
    public MethodReference getFactoryMethod(Method mappingMethod, Type targetType, SelectionParameters selectionParameters) {
        SelectionCriteria criteria = new SelectionCriteria(selectionParameters, null, false);
        ResolvingAttempt attempt = new ResolvingAttempt(this.sourceModel, mappingMethod, null, null, null, null, criteria);
        SourceMethod matchingSourceMethod = (SourceMethod)attempt.getBestMatch(this.sourceModel, null, targetType);
        if (matchingSourceMethod != null) {
            MapperReference ref = attempt.findMapperReference(matchingSourceMethod);
            return new MethodReference((Method)matchingSourceMethod, ref, null);
        }
        return null;
    }

    private class ResolvingAttempt {
        private final Method mappingMethod;
        private final String mappedElement;
        private final List<SourceMethod> methods;
        private final String dateFormat;
        private final String numberFormat;
        private final SelectionCriteria selectionCriteria;
        private final SourceRHS sourceRHS;
        private final boolean savedPreferUpdateMapping;
        private final Set<VirtualMappingMethod> virtualMethodCandidates;

        private ResolvingAttempt(List<SourceMethod> sourceModel, Method mappingMethod, String mappedElement, String dateFormat, String numberFormat, SourceRHS sourceRHS, SelectionCriteria criteria) {
            this.mappingMethod = mappingMethod;
            this.mappedElement = mappedElement;
            this.methods = this.filterPossibleCandidateMethods(sourceModel);
            this.dateFormat = dateFormat;
            this.numberFormat = numberFormat;
            this.sourceRHS = sourceRHS;
            this.virtualMethodCandidates = new HashSet<VirtualMappingMethod>();
            this.selectionCriteria = criteria;
            this.savedPreferUpdateMapping = criteria.isPreferUpdateMapping();
        }

        private <T extends Method> List<T> filterPossibleCandidateMethods(List<T> candidateMethods) {
            ArrayList<Method> result = new ArrayList<Method>(candidateMethods.size());
            for (Method candidate : candidateMethods) {
                if (!this.isCandidateForMapping(candidate)) continue;
                result.add(candidate);
            }
            return result;
        }

        private Assignment getTargetAssignment(Type sourceType, Type targetType) {
            Assignment referencedMethod = this.resolveViaMethod(sourceType, targetType, false);
            if (referencedMethod != null) {
                referencedMethod.setAssignment(this.sourceRHS);
                return referencedMethod;
            }
            if (sourceType.isAssignableTo(targetType) || this.isAssignableThroughCollectionCopyConstructor(sourceType, targetType)) {
                SourceRHS simpleAssignment = this.sourceRHS;
                return simpleAssignment;
            }
            Assignment conversion = this.resolveViaConversion(sourceType, targetType);
            if (conversion != null) {
                conversion.setAssignment(this.sourceRHS);
                return conversion;
            }
            Assignment builtInMethod = this.resolveViaBuiltInMethod(sourceType, targetType);
            if (builtInMethod != null) {
                builtInMethod.setAssignment(this.sourceRHS);
                MappingResolverImpl.this.usedVirtualMappings.addAll(this.virtualMethodCandidates);
                return builtInMethod;
            }
            referencedMethod = this.resolveViaMethodAndMethod(sourceType, targetType);
            if (referencedMethod != null) {
                MappingResolverImpl.this.usedVirtualMappings.addAll(this.virtualMethodCandidates);
                return referencedMethod;
            }
            referencedMethod = this.resolveViaConversionAndMethod(sourceType, targetType);
            if (referencedMethod != null) {
                MappingResolverImpl.this.usedVirtualMappings.addAll(this.virtualMethodCandidates);
                return referencedMethod;
            }
            this.selectionCriteria.setPreferUpdateMapping(false);
            conversion = this.resolveViaMethodAndConversion(sourceType, targetType);
            if (conversion != null) {
                MappingResolverImpl.this.usedVirtualMappings.addAll(this.virtualMethodCandidates);
                return conversion;
            }
            return null;
        }

        private Assignment resolveViaConversion(Type sourceType, Type targetType) {
            ConversionProvider conversionProvider = MappingResolverImpl.this.conversions.getConversion(sourceType, targetType);
            if (conversionProvider == null) {
                return null;
            }
            DefaultConversionContext ctx = new DefaultConversionContext(MappingResolverImpl.this.typeFactory, MappingResolverImpl.this.messager, sourceType, targetType, this.dateFormat, this.numberFormat);
            for (HelperMethod helperMethod : conversionProvider.getRequiredHelperMethods(ctx)) {
                MappingResolverImpl.this.usedVirtualMappings.add(new VirtualMappingMethod(helperMethod));
            }
            return conversionProvider.to(ctx);
        }

        private Assignment resolveViaMethod(Type sourceType, Type targetType, boolean considerBuiltInMethods) {
            SourceMethod matchingSourceMethod = this.getBestMatch(this.methods, sourceType, targetType);
            if (matchingSourceMethod != null) {
                return this.getMappingMethodReference(matchingSourceMethod, targetType);
            }
            if (considerBuiltInMethods) {
                return this.resolveViaBuiltInMethod(sourceType, targetType);
            }
            return null;
        }

        private Assignment resolveViaBuiltInMethod(Type sourceType, Type targetType) {
            BuiltInMethod matchingBuiltInMethod = this.getBestMatch(MappingResolverImpl.this.builtInMethods.getBuiltInMethods(), sourceType, targetType);
            if (matchingBuiltInMethod != null) {
                this.virtualMethodCandidates.add(new VirtualMappingMethod(matchingBuiltInMethod));
                DefaultConversionContext ctx = new DefaultConversionContext(MappingResolverImpl.this.typeFactory, MappingResolverImpl.this.messager, sourceType, targetType, this.dateFormat, this.numberFormat);
                MethodReference methodReference = new MethodReference(matchingBuiltInMethod, ctx);
                methodReference.setAssignment(this.sourceRHS);
                return methodReference;
            }
            return null;
        }

        private Assignment resolveViaMethodAndMethod(Type sourceType, Type targetType) {
            ArrayList<SourceMethod> methodYCandidates = new ArrayList<SourceMethod>(this.methods);
            methodYCandidates.addAll(MappingResolverImpl.this.builtInMethods.getBuiltInMethods());
            Assignment methodRefY = null;
            for (Method method : methodYCandidates) {
                methodRefY = this.resolveViaMethod(method.getSourceParameters().get(0).getType(), targetType, true);
                if (methodRefY == null) continue;
                this.selectionCriteria.setPreferUpdateMapping(false);
                Assignment methodRefX = this.resolveViaMethod(sourceType, method.getSourceParameters().get(0).getType(), true);
                this.selectionCriteria.setPreferUpdateMapping(this.savedPreferUpdateMapping);
                if (methodRefX != null) {
                    methodRefY.setAssignment(methodRefX);
                    methodRefX.setAssignment(this.sourceRHS);
                    break;
                }
                this.virtualMethodCandidates.clear();
                methodRefY = null;
            }
            return methodRefY;
        }

        private Assignment resolveViaConversionAndMethod(Type sourceType, Type targetType) {
            ArrayList<SourceMethod> methodYCandidates = new ArrayList<SourceMethod>(this.methods);
            methodYCandidates.addAll(MappingResolverImpl.this.builtInMethods.getBuiltInMethods());
            Assignment methodRefY = null;
            for (Method method : methodYCandidates) {
                methodRefY = this.resolveViaMethod(method.getSourceParameters().get(0).getType(), targetType, true);
                if (methodRefY == null) continue;
                Assignment conversionXRef = this.resolveViaConversion(sourceType, method.getSourceParameters().get(0).getType());
                if (conversionXRef != null) {
                    methodRefY.setAssignment(conversionXRef);
                    conversionXRef.setAssignment(this.sourceRHS);
                    break;
                }
                this.virtualMethodCandidates.clear();
                methodRefY = null;
            }
            return methodRefY;
        }

        private Assignment resolveViaMethodAndConversion(Type sourceType, Type targetType) {
            ArrayList<SourceMethod> methodXCandidates = new ArrayList<SourceMethod>(this.methods);
            methodXCandidates.addAll(MappingResolverImpl.this.builtInMethods.getBuiltInMethods());
            Assignment conversionYRef = null;
            for (Method method : methodXCandidates) {
                Assignment methodRefX;
                if (method.getMappingTargetParameter() != null || (methodRefX = this.resolveViaMethod(sourceType, method.getReturnType(), true)) == null) continue;
                conversionYRef = this.resolveViaConversion(method.getReturnType(), targetType);
                if (conversionYRef != null) {
                    conversionYRef.setAssignment(methodRefX);
                    methodRefX.setAssignment(this.sourceRHS);
                    break;
                }
                this.virtualMethodCandidates.clear();
                conversionYRef = null;
            }
            return conversionYRef;
        }

        private boolean isCandidateForMapping(Method methodCandidate) {
            return this.isCreateMethodForMapping(methodCandidate) || this.isUpdateMethodForMapping(methodCandidate);
        }

        private boolean isCreateMethodForMapping(Method methodCandidate) {
            return methodCandidate.getSourceParameters().size() == 1 && !methodCandidate.getReturnType().isVoid() && methodCandidate.getMappingTargetParameter() == null && !methodCandidate.isLifecycleCallbackMethod();
        }

        private boolean isUpdateMethodForMapping(Method methodCandidate) {
            return methodCandidate.getSourceParameters().size() == 1 && methodCandidate.getMappingTargetParameter() != null && !methodCandidate.isLifecycleCallbackMethod();
        }

        private <T extends Method> T getBestMatch(List<T> methods, Type sourceType, Type returnType) {
            List<T> candidates = MappingResolverImpl.this.methodSelectors.getMatchingMethods(this.mappingMethod, methods, sourceType, returnType, this.selectionCriteria);
            if (candidates.size() > 1) {
                if (this.mappedElement != null) {
                    MappingResolverImpl.this.messager.printMessage((Element)this.mappingMethod.getExecutable(), Message.GENERAL_AMBIGIOUS_MAPPING_METHOD, this.mappedElement, returnType, Strings.join(candidates, ", "));
                } else {
                    MappingResolverImpl.this.messager.printMessage((Element)this.mappingMethod.getExecutable(), Message.GENERAL_AMBIGIOUS_FACTORY_METHOD, returnType, Strings.join(candidates, ", "));
                }
            }
            if (!candidates.isEmpty()) {
                return (T)((Method)candidates.get(0));
            }
            return null;
        }

        private Assignment getMappingMethodReference(SourceMethod method, Type targetType) {
            MapperReference mapperReference = this.findMapperReference(method);
            return new MethodReference((Method)method, mapperReference, SourceMethod.containsTargetTypeParameter(method.getParameters()) ? targetType : null);
        }

        private MapperReference findMapperReference(SourceMethod method) {
            for (MapperReference ref : MappingResolverImpl.this.mapperReferences) {
                if (!ref.getType().equals(method.getDeclaringMapper())) continue;
                ref.setUsed(!method.isStatic());
                ref.setTypeRequiresImport(true);
                return ref;
            }
            return null;
        }

        private boolean isAssignableThroughCollectionCopyConstructor(Type sourceType, Type targetType) {
            boolean bothCollectionOrMap = false;
            if (sourceType.isCollectionType() && targetType.isCollectionType() || sourceType.isMapType() && targetType.isMapType()) {
                bothCollectionOrMap = true;
            }
            if (bothCollectionOrMap) {
                return this.hasCompatibleCopyConstructor(sourceType, targetType.getImplementationType() != null ? targetType.getImplementationType() : targetType);
            }
            return false;
        }

        private boolean hasCompatibleCopyConstructor(Type sourceType, Type targetType) {
            if (targetType.isPrimitive()) {
                return false;
            }
            List<ExecutableElement> targetTypeConstructors = ElementFilter.constructorsIn(targetType.getTypeElement().getEnclosedElements());
            for (ExecutableElement constructor : targetTypeConstructors) {
                if (constructor.getParameters().size() != 1) continue;
                ExecutableType typedConstructor = (ExecutableType)MappingResolverImpl.this.typeUtils.asMemberOf((DeclaredType)targetType.getTypeMirror(), constructor);
                TypeMirror parameterType = Collections.first(typedConstructor.getParameterTypes());
                if (parameterType.getKind() == TypeKind.DECLARED) {
                    DeclaredType p = (DeclaredType)parameterType;
                    ArrayList<TypeMirror> typeArguments = new ArrayList<TypeMirror>(p.getTypeArguments().size());
                    for (TypeMirror typeMirror : p.getTypeArguments()) {
                        typeArguments.add(MappingResolverImpl.this.typeFactory.getTypeBound(typeMirror));
                    }
                    parameterType = MappingResolverImpl.this.typeUtils.getDeclaredType((TypeElement)p.asElement(), typeArguments.toArray(new TypeMirror[typeArguments.size()]));
                }
                if (!MappingResolverImpl.this.typeUtils.isAssignable(sourceType.getTypeMirror(), parameterType)) continue;
                return true;
            }
            return false;
        }
    }
}

