/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.gwt.generator.widgetprocessor.binding.simple;

import com.google.gwt.core.ext.Generator;
import com.google.gwt.core.ext.GeneratorContext;
import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.core.ext.typeinfo.JMethod;
import com.google.gwt.core.ext.typeinfo.JPrimitiveType;
import com.google.gwt.core.ext.typeinfo.JType;
import com.google.gwt.core.ext.typeinfo.NotFoundException;
import com.google.gwt.core.ext.typeinfo.TypeOracle;
import com.google.gwt.user.rebind.ClassSourceFileComposerFactory;
import com.google.gwt.user.rebind.SourceWriter;
import java.io.PrintWriter;
import org.metawidget.gwt.client.widgetprocessor.binding.simple.SimpleBindingProcessorAdapter;
import org.metawidget.util.simple.StringUtils;

public class SimpleBindingProcessorAdapterGenerator
extends Generator {
    private static final String VARIABLE_NAME_PREFIX = "the";
    private static final int WRITE_GETTER = 0;
    private static final int WRITE_TYPE_GETTER = 1;
    private static final int WRITE_SETTER = 2;
    private static final int WRITE_ACTION = 3;
    private static final int MAXIMUM_DEPTH = 10;
    private TypeOracle mTypeOracle;

    public String generate(TreeLogger logger, GeneratorContext context, String typeName) {
        JClassType classType;
        this.mTypeOracle = context.getTypeOracle();
        try {
            classType = this.mTypeOracle.getType(typeName);
        }
        catch (NotFoundException e) {
            throw new RuntimeException(e);
        }
        String packageName = classType.getPackage().getName();
        String sourceClassName = classType.getSimpleSourceName();
        String bindingClassName = sourceClassName + "BindingAdapter";
        PrintWriter printWriter = context.tryCreate(logger, packageName, bindingClassName);
        String qualifiedBindingClassName = packageName + '.' + bindingClassName;
        if (printWriter == null) {
            return qualifiedBindingClassName;
        }
        ClassSourceFileComposerFactory composer = new ClassSourceFileComposerFactory(packageName, bindingClassName);
        composer.addImplementedInterface(SimpleBindingProcessorAdapter.class.getName() + "<" + classType.getQualifiedSourceName() + ">");
        SourceWriter sourceWriter = composer.createSourceWriter(context, printWriter);
        if (sourceWriter != null) {
            String variableName = VARIABLE_NAME_PREFIX + sourceClassName;
            sourceWriter.println();
            sourceWriter.println("// Public methods");
            sourceWriter.println();
            sourceWriter.println("public Object getProperty( " + classType.getQualifiedSourceName() + " " + variableName + ", String... names ) {");
            sourceWriter.indent();
            this.writeMethod(sourceWriter, classType, variableName, 0);
            sourceWriter.outdent();
            sourceWriter.println("}");
            sourceWriter.println();
            sourceWriter.println("public Class<?> getPropertyType( " + classType.getQualifiedSourceName() + " " + variableName + ", String... names ) {");
            sourceWriter.indent();
            this.writeMethod(sourceWriter, classType, variableName, 1);
            sourceWriter.outdent();
            sourceWriter.println("}");
            sourceWriter.println();
            sourceWriter.println("public void setProperty( " + classType.getQualifiedSourceName() + " " + variableName + ", Object value, String... names ) {");
            sourceWriter.indent();
            this.writeMethod(sourceWriter, classType, variableName, 2);
            sourceWriter.outdent();
            sourceWriter.println("}");
            sourceWriter.println();
            sourceWriter.println("public void invokeAction( " + classType.getQualifiedSourceName() + " " + variableName + ", String... names ) {");
            sourceWriter.indent();
            this.writeMethod(sourceWriter, classType, variableName, 3);
            sourceWriter.outdent();
            sourceWriter.println("}");
            sourceWriter.commit(logger);
        }
        return qualifiedBindingClassName;
    }

    private void writeMethod(SourceWriter sourceWriter, JClassType classType, String variableName, int writeType) {
        sourceWriter.println();
        sourceWriter.println("// Sanity check");
        sourceWriter.println();
        sourceWriter.println("if ( names == null || names.length == 0 ) throw new RuntimeException( \"No names specified\" );");
        this.writeSubtypes(sourceWriter, classType, variableName, 0, writeType, 0);
    }

    private void writeSubtypes(SourceWriter sourceWriter, JClassType classType, String variableName, int nameIndex, int writeType, int depth) {
        if (depth > 10) {
            return;
        }
        JClassType[] arr$ = classType.getSubtypes();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            JClassType subtype = arr$[i$];
            this.writeProperties(sourceWriter, subtype, variableName, nameIndex, true, classType, writeType, depth);
        }
        for (JClassType typeTraversal = classType; typeTraversal != null; typeTraversal = typeTraversal.getSuperclass()) {
            this.writeProperties(sourceWriter, typeTraversal, variableName, nameIndex, false, classType, writeType, depth);
        }
        sourceWriter.println();
        sourceWriter.println("// Unknown");
        sourceWriter.println();
        sourceWriter.println("throw new RuntimeException( \"Unknown property '\" + names[" + nameIndex + "] + \"' of " + classType.getParameterizedQualifiedSourceName() + "\" );");
    }

    private void writeProperties(SourceWriter sourceWriter, JClassType classType, String variableName, int nameIndex, boolean writeInstanceOf, JClassType parentType, int writeType, int depth) {
        String currentVariableName = variableName;
        boolean writtenAProperty = false;
        JMethod[] arr$ = classType.getMethods();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            String propertyName;
            JMethod method = arr$[i$];
            if (!method.isPublic()) continue;
            String methodName = method.getName();
            JType returnType = method.getReturnType();
            if (JPrimitiveType.VOID.equals((Object)returnType)) {
                if (writeType != 3 || method.getParameters().length != 0) continue;
                sourceWriter.println("if ( \"" + methodName + "\".equals( names[" + nameIndex + "] )) { " + currentVariableName + '.' + methodName + "(); return; }");
                continue;
            }
            if (methodName.startsWith("get")) {
                propertyName = methodName.substring("get".length());
            } else {
                if (!methodName.startsWith("is") || !"boolean".equals(method.getReturnType().getQualifiedSourceName())) continue;
                propertyName = methodName.substring("is".length());
            }
            String lowercasedPropertyName = StringUtils.lowercaseFirstLetter((String)propertyName);
            if (!writtenAProperty) {
                sourceWriter.println();
                sourceWriter.println("// " + classType.getSimpleSourceName() + " properties");
                sourceWriter.println();
                if (writeInstanceOf) {
                    sourceWriter.println("if ( " + currentVariableName + " instanceof " + classType.getName() + " ) {");
                    sourceWriter.indent();
                    String superclassVariableName = currentVariableName;
                    currentVariableName = VARIABLE_NAME_PREFIX + classType.getSimpleSourceName();
                    sourceWriter.println(classType.getParameterizedQualifiedSourceName() + " " + currentVariableName + " = (" + classType.getParameterizedQualifiedSourceName() + ") " + superclassVariableName + ";");
                }
                writtenAProperty = true;
            }
            sourceWriter.println("if ( \"" + lowercasedPropertyName + "\".equals( names[" + nameIndex + "] )) {");
            sourceWriter.indent();
            int nextNameIndex = nameIndex + 1;
            JClassType nestedClassType = returnType.isClass();
            if (nestedClassType != null && nestedClassType.getPackage().getName().startsWith(parentType.getPackage().getName())) {
                String nestedVariableName = VARIABLE_NAME_PREFIX + propertyName;
                if (depth > 0) {
                    nestedVariableName = nestedVariableName + (depth + 1);
                }
                sourceWriter.println(nestedClassType.getParameterizedQualifiedSourceName() + " " + nestedVariableName + " = " + currentVariableName + '.' + methodName + "();");
                switch (writeType) {
                    case 0: {
                        sourceWriter.println("if ( names.length == " + nextNameIndex + " ) return " + nestedVariableName + ";");
                        break;
                    }
                    case 1: {
                        sourceWriter.println("if ( names.length == " + nextNameIndex + " ) return " + this.getWrapperType(returnType).getQualifiedSourceName() + ".class;");
                        break;
                    }
                    case 2: {
                        try {
                            String setterMethodName = "set" + propertyName;
                            classType.getMethod(setterMethodName, new JType[]{returnType});
                            sourceWriter.println("if ( names.length == " + nextNameIndex + " ) { " + currentVariableName + '.' + setterMethodName + "( (" + this.getWrapperType(returnType).getParameterizedQualifiedSourceName() + ") value ); return; }");
                            break;
                        }
                        catch (NotFoundException e) {
                            sourceWriter.println("if ( names.length == " + nextNameIndex + " ) throw new RuntimeException( \"No setter for name '" + lowercasedPropertyName + "'\" );");
                        }
                    }
                }
                this.writeSubtypes(sourceWriter, nestedClassType, nestedVariableName, nextNameIndex, writeType, depth + 1);
                sourceWriter.outdent();
                sourceWriter.println("}");
                continue;
            }
            sourceWriter.println("if ( names.length > " + nextNameIndex + " ) throw new RuntimeException( \"Cannot traverse into property '" + lowercasedPropertyName + ".\" + names[" + nextNameIndex + "] + \"'\" );");
            switch (writeType) {
                case 0: {
                    sourceWriter.println("return " + currentVariableName + '.' + methodName + "();");
                    break;
                }
                case 1: {
                    sourceWriter.println("return " + this.getWrapperType(returnType).getQualifiedSourceName() + ".class;");
                    break;
                }
                case 2: {
                    try {
                        String setterMethodName = "set" + propertyName;
                        classType.getMethod(setterMethodName, new JType[]{returnType});
                        sourceWriter.println(currentVariableName + '.' + setterMethodName + "( (" + this.getWrapperType(returnType).getParameterizedQualifiedSourceName() + ") value );");
                        sourceWriter.println("return;");
                    }
                    catch (NotFoundException e) {
                        sourceWriter.println("throw new RuntimeException( \"No setter for property '" + lowercasedPropertyName + "'\" );");
                    }
                    break;
                }
                case 3: {
                    sourceWriter.println("if ( names.length == " + nextNameIndex + " ) throw new RuntimeException( \"Cannot execute '" + lowercasedPropertyName + "' - is a property, not an action\" );");
                }
            }
            sourceWriter.outdent();
            sourceWriter.println("}");
        }
        if (writtenAProperty && writeInstanceOf) {
            sourceWriter.outdent();
            sourceWriter.println("}");
        }
    }

    private JType getWrapperType(JType classType) {
        JPrimitiveType primitiveType = classType.isPrimitive();
        if (primitiveType == null) {
            return classType;
        }
        if (primitiveType.equals((Object)JPrimitiveType.BOOLEAN)) {
            return this.mTypeOracle.findType(Boolean.class.getName());
        }
        if (primitiveType.equals((Object)JPrimitiveType.BYTE)) {
            return this.mTypeOracle.findType(Byte.class.getName());
        }
        if (primitiveType.equals((Object)JPrimitiveType.CHAR)) {
            return this.mTypeOracle.findType(Character.class.getName());
        }
        if (primitiveType.equals((Object)JPrimitiveType.DOUBLE)) {
            return this.mTypeOracle.findType(Double.class.getName());
        }
        if (primitiveType.equals((Object)JPrimitiveType.FLOAT)) {
            return this.mTypeOracle.findType(Float.class.getName());
        }
        if (primitiveType.equals((Object)JPrimitiveType.INT)) {
            return this.mTypeOracle.findType(Integer.class.getName());
        }
        if (primitiveType.equals((Object)JPrimitiveType.LONG)) {
            return this.mTypeOracle.findType(Long.class.getName());
        }
        if (primitiveType.equals((Object)JPrimitiveType.SHORT)) {
            return this.mTypeOracle.findType(Short.class.getName());
        }
        throw new RuntimeException("No wrapper for " + primitiveType);
    }
}

