/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.faces.renderkit.html;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIParameter;
import javax.faces.component.html.HtmlInputHidden;
import javax.faces.component.html.HtmlMessage;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.metawidget.faces.FacesUtils;
import org.metawidget.faces.component.UIMetawidget;
import org.metawidget.faces.component.UIStub;
import org.metawidget.faces.renderkit.html.HtmlLayoutRenderer;
import org.metawidget.util.simple.StringUtils;

public class HtmlDivLayoutRenderer
extends HtmlLayoutRenderer {
    public void encodeBegin(FacesContext context, UIComponent metawidgetComponent) throws IOException {
        UIMetawidget metawidget = (UIMetawidget)metawidgetComponent;
        metawidget.putClientProperty(HtmlDivLayoutRenderer.class, null);
        super.encodeBegin(context, (UIComponent)metawidget);
        State state = this.getState((UIComponent)metawidget);
        state.outerStyle = metawidget.getParameter("outerStyle");
        state.labelStyle = metawidget.getParameter("labelStyle");
        state.componentStyle = metawidget.getParameter("componentStyle");
        state.requiredStyle = metawidget.getParameter("requiredStyle");
        String styleClassesParameter = metawidget.getParameter("divStyleClasses");
        if (styleClassesParameter != null) {
            state.divStyleClasses = styleClassesParameter.split(StringUtils.SEPARATOR_COMMA);
        }
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", (UIComponent)metawidget);
        writer.writeAttribute("id", (Object)metawidget.getClientId(context), "id");
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        List children = component.getChildren();
        Iterator i$ = children.iterator();
        while (i$.hasNext()) {
            UIComponent childComponent = (UIComponent)i$.next();
            if (childComponent instanceof UIStub && childComponent.getChildCount() == 0 || childComponent instanceof UIParameter || !childComponent.isRendered()) continue;
            if (childComponent instanceof HtmlInputHidden) {
                FacesUtils.render(context, childComponent);
                continue;
            }
            this.layoutBeforeChild(context, component, childComponent);
            this.layoutChild(context, component, childComponent);
            this.layoutAfterChild(context, component, childComponent);
        }
    }

    public void encodeEnd(FacesContext context, UIComponent metawidget) throws IOException {
        super.encodeEnd(context, metawidget);
        ResponseWriter writer = context.getResponseWriter();
        UIComponent componentFooter = metawidget.getFacet("footer");
        if (componentFooter != null) {
            writer.startElement("div", metawidget);
            this.writeStyleAndClass((UIMetawidget)metawidget, writer, "footer");
            FacesUtils.render(context, componentFooter);
            writer.endElement("div");
        }
        writer.endElement("div");
    }

    protected HtmlMessage createInlineMessage(FacesContext context, UIComponent metawidget, String messageFor) {
        HtmlMessage message = super.createInlineMessage(context, metawidget, messageFor);
        if (message.getStyleClass() == null) {
            State state = this.getState(metawidget);
            if (state.divStyleClasses != null && state.divStyleClasses.length > 4) {
                message.setStyleClass(state.divStyleClasses[4]);
            }
        }
        return message;
    }

    protected void layoutBeforeChild(FacesContext context, UIComponent metawidget, UIComponent componentChild) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        State state = this.getState(metawidget);
        writer.startElement("div", metawidget);
        if (state.outerStyle != null) {
            writer.writeAttribute("style", (Object)state.outerStyle, null);
        }
        this.writeStyleClass(metawidget, writer, 0);
        this.layoutLabel(context, metawidget, componentChild);
        writer.startElement("div", metawidget);
        if (state.componentStyle != null) {
            writer.writeAttribute("style", (Object)state.componentStyle, null);
        }
        this.writeStyleClass(metawidget, writer, 3);
    }

    protected boolean layoutLabel(FacesContext context, UIComponent metawidget, UIComponent componentNeedingLabel) throws IOException {
        if (this.getLabelText(componentNeedingLabel) == null) {
            return false;
        }
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", metawidget);
        State state = this.getState(metawidget);
        if (state.labelStyle != null) {
            writer.writeAttribute("style", (Object)state.labelStyle, null);
        }
        this.writeStyleClass(metawidget, writer, 1);
        super.layoutLabel(context, metawidget, componentNeedingLabel);
        this.layoutRequired(context, metawidget, componentNeedingLabel);
        writer.endElement("div");
        return true;
    }

    protected void layoutRequired(FacesContext context, UIComponent metawidget, UIComponent child) throws IOException {
        Map metadataAttributes = (Map)child.getAttributes().get("metawidget-metadata");
        if (metadataAttributes == null) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        if ("true".equals(metadataAttributes.get("required")) && !"true".equals(metadataAttributes.get("read-only")) && !((UIMetawidget)metawidget).isReadOnly()) {
            writer.startElement("span", metawidget);
            State state = this.getState(metawidget);
            String requiredStyle = (String)metadataAttributes.get(state.requiredStyle);
            if (requiredStyle != null) {
                writer.writeAttribute("style", (Object)requiredStyle, null);
            }
            this.writeStyleClass(metawidget, writer, 2);
            writer.write("*");
            writer.endElement("span");
        }
    }

    protected void layoutAfterChild(FacesContext context, UIComponent metawidget, UIComponent child) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.endElement("div");
        writer.endElement("div");
    }

    protected void writeStyleClass(UIComponent metawidget, ResponseWriter writer, int styleClass) throws IOException {
        State state = this.getState(metawidget);
        if (state.divStyleClasses == null || state.divStyleClasses.length <= styleClass) {
            return;
        }
        String columnClass = state.divStyleClasses[styleClass];
        if (columnClass.length() == 0) {
            return;
        }
        writer.writeAttribute("class", (Object)columnClass.trim(), null);
    }

    private State getState(UIComponent metawidget) {
        State state = (State)((UIMetawidget)metawidget).getClientProperty(HtmlDivLayoutRenderer.class);
        if (state == null) {
            state = new State();
            ((UIMetawidget)metawidget).putClientProperty(HtmlDivLayoutRenderer.class, state);
        }
        return state;
    }

    static class State {
        String outerStyle;
        String labelStyle;
        String requiredStyle;
        String componentStyle;
        String[] divStyleClasses;

        State() {
        }
    }
}

