/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.inspector.impl;

import java.io.InputStream;
import org.metawidget.config.NeedsResourceResolver;
import org.metawidget.config.ResourceResolver;
import org.metawidget.config.SimpleResourceResolver;
import org.metawidget.inspector.impl.propertystyle.PropertyStyle;
import org.metawidget.util.simple.ObjectUtils;

public class BaseXmlInspectorConfig
implements NeedsResourceResolver {
    private String mDefaultFile;
    private ResourceResolver mResourceResolver;
    private InputStream[] mInputStreams;
    private PropertyStyle mRestrictAgainstObject;

    public BaseXmlInspectorConfig setInputStreams(InputStream[] streams) {
        this.mInputStreams = streams;
        return this;
    }

    public BaseXmlInspectorConfig setInputStream(InputStream stream) {
        this.mDefaultFile = null;
        this.mInputStreams = new InputStream[]{stream};
        return this;
    }

    public void setResourceResolver(ResourceResolver resourceResolver) {
        this.mResourceResolver = resourceResolver;
    }

    public BaseXmlInspectorConfig setRestrictAgainstObject(PropertyStyle restrictAgainstObject) {
        this.mRestrictAgainstObject = restrictAgainstObject;
        return this;
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (!ObjectUtils.nullSafeClassEquals(this, that)) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals(this.mDefaultFile, ((BaseXmlInspectorConfig)that).mDefaultFile)) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals(this.mResourceResolver, ((BaseXmlInspectorConfig)that).mResourceResolver)) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals(this.mInputStreams, ((BaseXmlInspectorConfig)that).mInputStreams)) {
            return false;
        }
        return ObjectUtils.nullSafeEquals(this.mRestrictAgainstObject, ((BaseXmlInspectorConfig)that).mRestrictAgainstObject);
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ObjectUtils.nullSafeHashCode(this.mDefaultFile);
        hashCode = 31 * hashCode + ObjectUtils.nullSafeHashCode(this.mResourceResolver);
        hashCode = 31 * hashCode + ObjectUtils.nullSafeHashCode(this.mInputStreams);
        hashCode = 31 * hashCode + ObjectUtils.nullSafeHashCode(this.mRestrictAgainstObject);
        return hashCode;
    }

    protected void setDefaultFile(String defaultFile) {
        this.mDefaultFile = defaultFile;
    }

    protected InputStream[] getInputStreams() {
        if (this.mInputStreams == null && this.mDefaultFile != null) {
            return new InputStream[]{this.getResourceResolver().openResource(this.mDefaultFile)};
        }
        return this.mInputStreams;
    }

    protected ResourceResolver getResourceResolver() {
        if (this.mResourceResolver == null) {
            return new SimpleResourceResolver();
        }
        return this.mResourceResolver;
    }

    protected PropertyStyle getRestrictAgainstObject() {
        return this.mRestrictAgainstObject;
    }
}

