/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.util;

import java.lang.reflect.Array;
import java.util.List;
import java.util.regex.Pattern;
import org.metawidget.util.CollectionUtils;
import org.metawidget.util.simple.StringUtils;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ArrayUtils {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];

    public static String toString(Object array) {
        return ArrayUtils.toString(array, StringUtils.SEPARATOR_COMMA);
    }

    public static String toString(Object array, String separator) {
        return ArrayUtils.toString(array, separator, false, false);
    }

    public static String toString(Object array, String separator, boolean leadingSeparator, boolean trailingSeparator) {
        if (array == null) {
            return "";
        }
        if (!array.getClass().isArray()) {
            throw new UnsupportedOperationException("Not an array");
        }
        String separatorEscaped = separator;
        if (separatorEscaped.equals(".")) {
            separatorEscaped = "\\.";
        }
        Pattern patternSeparator = Pattern.compile(separatorEscaped, 16);
        String replacement = new StringBuffer().append("\\\\").append(separator).toString();
        StringBuffer buffer = new StringBuffer();
        int length = Array.getLength(array);
        for (int loop = 0; loop < length; ++loop) {
            String value = String.valueOf(Array.get(array, loop));
            if (buffer.length() > 0 || leadingSeparator) {
                buffer.append(separator);
            }
            value = patternSeparator.matcher(value).replaceAll(replacement);
            buffer.append(value);
        }
        if (trailingSeparator && buffer.length() > 0) {
            buffer.append(separator);
        }
        return buffer.toString();
    }

    public static String[] fromString(String array) {
        return ArrayUtils.fromString(array, ',');
    }

    public static String[] fromString(String array, char separator) {
        if (array == null) {
            return EMPTY_STRING_ARRAY;
        }
        List<String> list = CollectionUtils.fromString(array, separator);
        return list.toArray(new String[list.size()]);
    }

    public static <T> T[] add(T[] array, T[] arrayToAdd) {
        if (array == null) {
            return arrayToAdd;
        }
        return ArrayUtils.addAt(array, array.length, arrayToAdd);
    }

    public static <T> T[] addAt(T[] array, int index, T[] arrayToAdd) {
        if (array == null) {
            return arrayToAdd;
        }
        if (arrayToAdd == null) {
            return array;
        }
        int lengthToAdd = arrayToAdd.length;
        if (lengthToAdd == 0) {
            return array;
        }
        int originalLength = array.length;
        Object[] newArray = (Object[])Array.newInstance(array.getClass().getComponentType(), originalLength + lengthToAdd);
        if (index > 0) {
            System.arraycopy(array, 0, newArray, 0, index);
        }
        System.arraycopy(arrayToAdd, 0, newArray, index, lengthToAdd);
        if (index < array.length) {
            System.arraycopy(array, index, newArray, index + lengthToAdd, array.length - index);
        }
        return newArray;
    }

    public static <T> boolean contains(T[] array, T contains) {
        return ArrayUtils.indexOf(array, contains) != -1;
    }

    public static <T> int indexOf(T[] array, T contains) {
        if (array == null) {
            return -1;
        }
        for (int index = 0; index < array.length; ++index) {
            T object = array[index];
            if (!(object == null ? contains == null : object.equals(contains))) continue;
            return index;
        }
        return -1;
    }

    public static <T> T[] removeAt(T[] array, int index) {
        Object[] newArray = (Object[])Array.newInstance(array.getClass().getComponentType(), array.length - 1);
        if (index > 0) {
            System.arraycopy(array, 0, newArray, 0, index);
        }
        if (index < array.length - 1) {
            System.arraycopy(array, index + 1, newArray, index, array.length - (index + 1));
        }
        return newArray;
    }

    private ArrayUtils() {
    }
}

