/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.faces.renderkit.html;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.component.UIInput;
import javax.faces.component.UIParameter;
import javax.faces.component.html.HtmlInputHidden;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.el.ValueBinding;
import org.metawidget.faces.FacesUtils;
import org.metawidget.faces.component.UIMetawidget;
import org.metawidget.faces.component.UIStub;
import org.metawidget.faces.renderkit.html.HtmlLayoutRenderer;
import org.metawidget.layout.iface.LayoutException;
import org.metawidget.util.simple.SimpleLayoutUtils;
import org.metawidget.util.simple.StringUtils;

public class HtmlTableLayoutRenderer
extends HtmlLayoutRenderer {
    private static final String TABLE_PREFIX = "table-";
    private static final String ROW_SUFFIX = "-row";
    private static final String LABEL_CELL_SUFFIX = "-label-cell";
    private static final String COMPONENT_CELL_SUFFIX = "-cell";
    private static final int JUST_COMPONENT_AND_REQUIRED = 2;
    private static final int LABEL_AND_COMPONENT_AND_REQUIRED = 3;

    public void encodeBegin(FacesContext context, UIComponent metawidgetComponent) throws IOException {
        UIComponent componentFooter;
        UIComponent componentHeader;
        String columnsParameter;
        String rowClassesParameter;
        UIMetawidget metawidget = (UIMetawidget)metawidgetComponent;
        metawidget.putClientProperty(HtmlTableLayoutRenderer.class, null);
        super.encodeBegin(context, (UIComponent)metawidget);
        ResponseWriter writer = context.getResponseWriter();
        this.layoutHiddenChildren(context, (UIComponent)metawidget);
        writer.startElement("table", (UIComponent)metawidget);
        writer.writeAttribute("id", (Object)metawidget.getClientId(context), "id");
        this.writeStyleAndClass(metawidget, writer, "table");
        State state = this.getState((UIComponent)metawidget);
        state.labelStyle = metawidget.getParameter("labelStyle");
        state.componentStyle = metawidget.getParameter("componentStyle");
        state.requiredStyle = metawidget.getParameter("requiredStyle");
        String columnClassesParameter = metawidget.getParameter("columnClasses");
        if (columnClassesParameter != null) {
            state.columnClasses = columnClassesParameter.split(StringUtils.SEPARATOR_COMMA);
        }
        if ((rowClassesParameter = metawidget.getParameter("rowClasses")) != null) {
            state.rowClasses = rowClassesParameter.split(StringUtils.SEPARATOR_COMMA);
        }
        if ((columnsParameter = metawidget.getParameter("columns")) != null) {
            state.columns = Integer.parseInt(columnsParameter);
            if (state.columns < 0) {
                throw LayoutException.newException("columns must be >= 0");
            }
        }
        if ((componentHeader = metawidget.getFacet("header")) != null) {
            writer.startElement("thead", (UIComponent)metawidget);
            writer.startElement("tr", (UIComponent)metawidget);
            writer.startElement("td", (UIComponent)metawidget);
            int colspan = Math.max(2, state.columns * 3);
            writer.writeAttribute("colspan", (Object)String.valueOf(colspan), null);
            this.writeStyleAndClass(metawidget, writer, "header");
            FacesUtils.render(context, componentHeader);
            writer.endElement("td");
            writer.endElement("tr");
            writer.endElement("thead");
        }
        if ((componentFooter = metawidget.getFacet("footer")) != null) {
            writer.startElement("tfoot", (UIComponent)metawidget);
            writer.startElement("tr", (UIComponent)metawidget);
            writer.startElement("td", (UIComponent)metawidget);
            int colspan = Math.max(2, state.columns * 3);
            writer.writeAttribute("colspan", (Object)String.valueOf(colspan), null);
            this.writeStyleAndClass(metawidget, writer, "footer");
            FacesUtils.render(context, componentFooter);
            writer.endElement("td");
            writer.endElement("tr");
            writer.endElement("tfoot");
        }
        writer.startElement("tbody", (UIComponent)metawidget);
    }

    protected void layoutHiddenChildren(FacesContext context, UIComponent metawidget) throws IOException {
        List children = metawidget.getChildren();
        Iterator i$ = children.iterator();
        while (i$.hasNext()) {
            UIComponent componentChild = (UIComponent)i$.next();
            if (!(componentChild instanceof HtmlInputHidden)) continue;
            FacesUtils.render(context, componentChild);
        }
    }

    public void encodeChildren(FacesContext context, UIComponent metawidget) throws IOException {
        State state = this.getState(metawidget);
        if (state == null) {
            return;
        }
        List children = metawidget.getChildren();
        state.currentColumn = 0;
        state.currentRow = 0;
        Iterator i$ = children.iterator();
        while (i$.hasNext()) {
            UIComponent componentChild = (UIComponent)i$.next();
            if (componentChild instanceof UIStub) {
                boolean visibleChildren = false;
                Iterator i$2 = componentChild.getChildren().iterator();
                while (i$2.hasNext()) {
                    UIComponent stubChild = (UIComponent)i$2.next();
                    if (!stubChild.isRendered()) continue;
                    visibleChildren = true;
                    break;
                }
                if (!visibleChildren) continue;
            }
            if (componentChild instanceof UIParameter || componentChild instanceof HtmlInputHidden || !componentChild.isRendered()) continue;
            ++state.currentColumn;
            this.layoutBeforeChild(context, metawidget, componentChild);
            this.layoutChild(context, metawidget, componentChild);
            this.layoutAfterChild(context, metawidget, componentChild);
        }
    }

    public void encodeEnd(FacesContext context, UIComponent metawidget) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.endElement("tbody");
        writer.endElement("table");
    }

    protected void layoutBeforeChild(FacesContext context, UIComponent metawidget, UIComponent childComponent) throws IOException {
        int colspan;
        boolean labelWritten;
        ResponseWriter writer = context.getResponseWriter();
        String cssId = this.getCssId(childComponent);
        Map metadataAttributes = (Map)childComponent.getAttributes().get("metawidget-metadata");
        State state = this.getState(metawidget);
        if (metadataAttributes != null) {
            boolean largeComponent;
            boolean bl = largeComponent = metawidget instanceof UIData || "true".equals(metadataAttributes.get("large"));
            if (largeComponent && state.currentColumn != 1) {
                writer.endElement("tr");
                state.currentColumn = 1;
            }
        }
        if (state.currentColumn == 1 || state.currentColumn > state.columns) {
            state.currentColumn = 1;
            writer.startElement("tr", metawidget);
            if (cssId != null) {
                writer.writeAttribute("id", (Object)(TABLE_PREFIX + cssId + ROW_SUFFIX), null);
            }
            this.writeRowStyleClass(metawidget, writer, state.currentRow);
            ++state.currentRow;
        }
        if ((labelWritten = this.layoutLabel(context, metawidget, childComponent)) && state.columns == 0) {
            writer.endElement("tr");
            writer.startElement("tr", metawidget);
            if (cssId != null) {
                writer.writeAttribute("id", (Object)(TABLE_PREFIX + cssId + ROW_SUFFIX + "2"), null);
            }
            this.writeRowStyleClass(metawidget, writer, state.currentRow);
        }
        writer.startElement("td", metawidget);
        if (cssId != null) {
            writer.writeAttribute("id", (Object)(TABLE_PREFIX + cssId + COMPONENT_CELL_SUFFIX), null);
        }
        if (state.componentStyle != null) {
            writer.writeAttribute("style", (Object)state.componentStyle, null);
        }
        this.writeColumnStyleClass(metawidget, writer, 1);
        if (childComponent instanceof UIMetawidget || childComponent instanceof UIData || SimpleLayoutUtils.isSpanAllColumns(metadataAttributes)) {
            colspan = state.columns * 3 - 2;
            state.currentColumn = state.columns;
            if (!labelWritten) {
                ++colspan;
            }
            if (childComponent instanceof UIMetawidget && "table".equals(childComponent.getRendererType())) {
                ++colspan;
            }
        } else {
            colspan = !labelWritten ? 2 : 1;
        }
        if (colspan > 1) {
            writer.writeAttribute("colspan", (Object)String.valueOf(colspan), null);
        }
    }

    protected boolean layoutLabel(FacesContext context, UIComponent metawidget, UIComponent componentNeedingLabel) throws IOException {
        if (this.getLabelText(componentNeedingLabel) == null) {
            return false;
        }
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("th", metawidget);
        String cssId = this.getCssId(componentNeedingLabel);
        if (cssId != null) {
            writer.writeAttribute("id", (Object)(TABLE_PREFIX + cssId + LABEL_CELL_SUFFIX), null);
        }
        State state = this.getState(metawidget);
        if (state.labelStyle != null) {
            writer.writeAttribute("style", (Object)state.labelStyle, null);
        }
        this.writeColumnStyleClass(metawidget, writer, 0);
        super.layoutLabel(context, metawidget, componentNeedingLabel);
        writer.endElement("th");
        return true;
    }

    protected void layoutAfterChild(FacesContext context, UIComponent metawidget, UIComponent childComponent) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.endElement("td");
        State state = this.getState(metawidget);
        if (!(childComponent instanceof UIMetawidget && "table".equals(childComponent.getRendererType()) || !childComponent.getAttributes().containsKey("metawidget-metadata"))) {
            writer.startElement("td", metawidget);
            if (state.requiredStyle != null) {
                writer.writeAttribute("style", (Object)state.requiredStyle, null);
            }
            this.writeColumnStyleClass(metawidget, writer, 2);
            this.layoutRequired(context, metawidget, childComponent);
            writer.endElement("td");
        }
        if (state.currentColumn >= state.columns) {
            state.currentColumn = 0;
            writer.endElement("tr");
        }
    }

    protected void layoutRequired(FacesContext context, UIComponent metawidget, UIComponent child) throws IOException {
        Map attributes = (Map)child.getAttributes().get("metawidget-metadata");
        ResponseWriter writer = context.getResponseWriter();
        if (attributes != null && "true".equals(attributes.get("required")) && !"true".equals(attributes.get("read-only")) && !((UIMetawidget)metawidget).isReadOnly() && (child instanceof UIInput || child instanceof UIStub || child instanceof UIMetawidget)) {
            writer.write("*");
            return;
        }
        writer.startElement("div", metawidget);
        writer.endElement("div");
    }

    protected String getCssId(UIComponent metawidget) {
        ValueBinding binding = metawidget.getValueBinding("value");
        if (binding == null) {
            return null;
        }
        return StringUtils.camelCase(FacesUtils.unwrapExpression(binding.getExpressionString()), '.');
    }

    protected void writeColumnStyleClass(UIComponent metawidget, ResponseWriter writer, int columnStyleClass) throws IOException {
        State state = this.getState(metawidget);
        if (state.columnClasses == null || state.columnClasses.length <= columnStyleClass) {
            return;
        }
        String columnClass = state.columnClasses[columnStyleClass];
        if (columnClass.length() == 0) {
            return;
        }
        writer.writeAttribute("class", (Object)columnClass.trim(), null);
    }

    protected void writeRowStyleClass(UIComponent metawidget, ResponseWriter writer, int rowStyleClass) throws IOException {
        State state = this.getState(metawidget);
        if (state.rowClasses == null) {
            return;
        }
        String rowClass = state.rowClasses[rowStyleClass % state.rowClasses.length];
        if (rowClass.length() == 0) {
            return;
        }
        writer.writeAttribute("class", (Object)rowClass.trim(), null);
    }

    State getState(UIComponent metawidget) {
        State state = (State)((UIMetawidget)metawidget).getClientProperty(HtmlTableLayoutRenderer.class);
        if (state == null) {
            state = new State();
            ((UIMetawidget)metawidget).putClientProperty(HtmlTableLayoutRenderer.class, state);
        }
        return state;
    }

    static class State {
        int currentColumn;
        int columns = 1;
        int currentRow;
        String labelStyle;
        String componentStyle;
        String requiredStyle;
        String[] columnClasses;
        String[] rowClasses;

        State() {
        }
    }
}

