/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.inspector.impl.actionstyle;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.TreeMap;
import org.metawidget.inspector.impl.BaseTraitStyleConfig;
import org.metawidget.inspector.impl.actionstyle.Action;
import org.metawidget.inspector.impl.actionstyle.BaseAction;
import org.metawidget.inspector.impl.actionstyle.BaseActionStyle;
import org.metawidget.util.ClassUtils;
import org.metawidget.util.CollectionUtils;
import org.metawidget.util.Java5ClassUtils;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MethodActionStyle
extends BaseActionStyle {
    protected MethodActionStyle(BaseTraitStyleConfig config) {
        super(config);
    }

    @Override
    protected Map<String, Action> inspectActions(Class<?> clazz) {
        TreeMap<String, Action> actions = CollectionUtils.newTreeMap();
        for (Method method : clazz.getMethods()) {
            if (!this.matchAction(method)) continue;
            String methodName = method.getName();
            if (this.isExcluded(ClassUtils.getOriginalDeclaringClass(method), methodName, method.getReturnType())) continue;
            actions.put(methodName, new MethodAction(methodName, method));
        }
        return actions;
    }

    protected abstract boolean matchAction(Method var1);

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class MethodAction
    extends BaseAction {
        private Method mMethod;

        public MethodAction(String name, Method method) {
            super(name);
            this.mMethod = method;
            if (this.mMethod == null) {
                throw new NullPointerException("method");
            }
        }

        @Override
        public <T extends Annotation> T getAnnotation(Class<T> annotation) {
            return Java5ClassUtils.getOriginalAnnotation(this.mMethod, annotation);
        }
    }
}

