/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.inspector.hibernate.validator;

import java.util.HashMap;
import java.util.Map;
import org.hibernate.validator.Length;
import org.hibernate.validator.Max;
import org.hibernate.validator.Min;
import org.hibernate.validator.NotEmpty;
import org.hibernate.validator.NotNull;
import org.hibernate.validator.Range;
import org.metawidget.inspector.impl.BaseObjectInspector;
import org.metawidget.inspector.impl.BaseObjectInspectorConfig;
import org.metawidget.inspector.impl.propertystyle.Property;
import org.metawidget.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateValidatorInspector
extends BaseObjectInspector {
    public HibernateValidatorInspector() {
        this(new BaseObjectInspectorConfig());
    }

    public HibernateValidatorInspector(BaseObjectInspectorConfig config) {
        super(config);
    }

    @Override
    protected Map<String, String> inspectProperty(Property property) throws Exception {
        Length length;
        Range range;
        Max max;
        Min min;
        HashMap<String, String> attributes = CollectionUtils.newHashMap();
        try {
            Class<?> digitsClass = Class.forName("org.hibernate.validator.Digits");
            Object digitsAnnotation = property.getAnnotation(digitsClass);
            if (digitsAnnotation != null) {
                int fractionalDigits;
                int integerDigits = (Integer)digitsClass.getMethod("integerDigits", new Class[0]).invoke(digitsAnnotation, new Object[0]);
                if (integerDigits > 0) {
                    attributes.put("maximum-integer-digits", String.valueOf(integerDigits));
                }
                if ((fractionalDigits = ((Integer)digitsClass.getMethod("fractionalDigits", new Class[0]).invoke(digitsAnnotation, new Object[0])).intValue()) > 0) {
                    attributes.put("maximum-fractional-digits", String.valueOf(fractionalDigits));
                }
            }
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        if (property.isAnnotationPresent(NotNull.class)) {
            attributes.put("required", "true");
        }
        if (property.isAnnotationPresent(NotEmpty.class)) {
            attributes.put("required", "true");
        }
        if ((min = property.getAnnotation(Min.class)) != null) {
            attributes.put("minimum-value", String.valueOf(min.value()));
        }
        if ((max = property.getAnnotation(Max.class)) != null) {
            attributes.put("maximum-value", String.valueOf(max.value()));
        }
        if ((range = property.getAnnotation(Range.class)) != null) {
            attributes.put("minimum-value", String.valueOf(range.min()));
            attributes.put("maximum-value", String.valueOf(range.max()));
        }
        if ((length = property.getAnnotation(Length.class)) != null) {
            if (length.min() > 0) {
                attributes.put("minimum-length", String.valueOf(length.min()));
            }
            if (length.max() > 0) {
                attributes.put("maximum-length", String.valueOf(length.max()));
            }
        }
        return attributes;
    }
}

