/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.inspector.impl;

import java.util.Collections;
import java.util.Map;
import java.util.regex.Pattern;
import org.metawidget.inspector.impl.BaseTraitStyleConfig;
import org.metawidget.inspector.impl.Trait;
import org.metawidget.util.ArrayUtils;
import org.metawidget.util.CollectionUtils;
import org.metawidget.util.LogUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseTraitStyle<T extends Trait> {
    final Map<String, Map<String, T>> mCache;
    private Pattern mExcludeBaseType;
    private Class<?>[] mExcludeReturnType;
    private String[] mExcludeName;
    protected final LogUtils.Log mLog = LogUtils.getLog(this.getClass());

    protected BaseTraitStyle(BaseTraitStyleConfig config) {
        this.mCache = config.isCacheLookups() ? CollectionUtils.newWeakHashMap() : null;
        this.mExcludeBaseType = config.getExcludeBaseType();
        this.mExcludeReturnType = config.getExcludeReturnType();
        this.mExcludeName = config.getExcludeName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache() {
        if (this.mCache == null) {
            return;
        }
        Map<String, Map<String, T>> map = this.mCache;
        synchronized (map) {
            this.mCache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Map<String, T> getTraits(String type) {
        if (this.mCache == null) {
            return this.getUncachedTraits(type);
        }
        Map<String, Map<String, T>> map = this.mCache;
        synchronized (map) {
            Map<String, T> traits = this.getCachedTraits(type);
            if (traits == null) {
                traits = this.getUncachedTraits(type);
                this.cacheTraits(type, traits);
            }
            return traits;
        }
    }

    protected final Map<String, T> getCachedTraits(String type) {
        return this.mCache.get(type);
    }

    protected final void cacheTraits(String type, Map<String, T> traits) {
        this.mCache.put(type, Collections.unmodifiableMap(traits));
    }

    protected abstract Map<String, T> getUncachedTraits(String var1);

    protected final boolean isExcluded(Class<?> classToExclude, String name, Class<?> returnType) {
        if (this.isExcludedBaseType(classToExclude)) {
            return true;
        }
        if (this.isExcludedReturnType(returnType)) {
            return true;
        }
        return this.isExcludedName(name);
    }

    protected boolean isExcludedBaseType(Class<?> classToExclude) {
        String className = classToExclude.getName();
        return this.mExcludeBaseType != null && this.mExcludeBaseType.matcher(className).matches();
    }

    protected boolean isExcludedReturnType(Class<?> clazz) {
        if (this.mExcludeReturnType != null) {
            for (Class<?> excludedClass : this.mExcludeReturnType) {
                if (!excludedClass.isAssignableFrom(clazz)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean isExcludedName(String name) {
        return ArrayUtils.contains(this.mExcludeName, name);
    }
}

