/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.inspector.propertytype;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.metawidget.inspector.impl.BaseObjectInspector;
import org.metawidget.inspector.impl.BaseObjectInspectorConfig;
import org.metawidget.inspector.impl.propertystyle.Property;
import org.metawidget.util.ClassUtils;
import org.metawidget.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyTypeInspector
extends BaseObjectInspector {
    public PropertyTypeInspector() {
        this(new BaseObjectInspectorConfig());
    }

    public PropertyTypeInspector(BaseObjectInspectorConfig config) {
        super(config);
    }

    @Override
    protected boolean shouldInspectPropertyAsEntity(Property property) {
        return true;
    }

    @Override
    protected Map<String, String> inspectEntity(String declaredClass, String actualClass) throws Exception {
        Class<?> actualClazz;
        HashMap<String, String> attributes = CollectionUtils.newHashMap();
        attributes.put("type", declaredClass);
        if (!actualClass.equals(declaredClass)) {
            attributes.put("actual-class", actualClass);
        }
        if (Boolean.class.getName().equals(actualClass)) {
            attributes.put("lookup", "true, false");
            attributes.put("lookup-labels", "Yes, No");
        }
        if ((actualClazz = ClassUtils.niceForName(actualClass)) != null && Enum.class.isAssignableFrom(actualClazz)) {
            Method methodValues = actualClazz.getMethod("values", new Class[0]);
            Enum[] enums = (Enum[])methodValues.invoke(actualClazz, new Object[0]);
            ArrayList lookup = CollectionUtils.newArrayList();
            ArrayList lookupLabels = CollectionUtils.newArrayList();
            for (Enum anEnum : enums) {
                lookup.add(anEnum.name());
                lookupLabels.add(anEnum.toString());
            }
            attributes.put("lookup", CollectionUtils.toString(lookup));
            attributes.put("lookup-labels", CollectionUtils.toString(lookupLabels));
            if (actualClazz.isEnum()) {
                attributes.put("type", actualClazz.getName());
            } else {
                attributes.put("type", actualClazz.getSuperclass().getName());
            }
        }
        return attributes;
    }

    @Override
    protected Map<String, String> inspectProperty(Property property) throws Exception {
        String genericType;
        HashMap<String, String> attributes = CollectionUtils.newHashMap();
        if (!property.isWritable()) {
            attributes.put("no-setter", "true");
        }
        if (!property.isReadable()) {
            attributes.put("no-getter", "true");
        }
        if ((genericType = property.getGenericType()) != null) {
            attributes.put("parameterized-type", genericType);
        }
        return attributes;
    }
}

