/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.statically.jsp;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class StaticJspUtils {
    private static final Pattern PATTERN_EXPRESSION = Pattern.compile("\\$\\{([^\\}]+)\\}");
    private static final String EXPRESSION_START = "${";
    private static final String EXPRESSION_END = "}";

    private static boolean isExpression(String value) {
        return StaticJspUtils.matchExpression(value).matches();
    }

    private static Matcher matchExpression(String value) {
        return PATTERN_EXPRESSION.matcher(value);
    }

    public static String unwrapExpression(String value) {
        Matcher matcher = PATTERN_EXPRESSION.matcher(value);
        if (!matcher.matches()) {
            return value;
        }
        return matcher.group(1);
    }

    public static String wrapExpression(String value) {
        if (StaticJspUtils.isExpression(value)) {
            return value;
        }
        return EXPRESSION_START + value + EXPRESSION_END;
    }

    private StaticJspUtils() {
    }
}

