/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.statically.jsp.html.layout;

import java.util.Map;
import org.metawidget.layout.iface.AdvancedLayout;
import org.metawidget.layout.iface.LayoutException;
import org.metawidget.statically.StaticWidget;
import org.metawidget.statically.StaticXmlMetawidget;
import org.metawidget.statically.StaticXmlStub;
import org.metawidget.statically.StaticXmlWidget;
import org.metawidget.statically.jsp.html.layout.HtmlTableLayoutConfig;
import org.metawidget.statically.jsp.html.widgetbuilder.HtmlLabel;
import org.metawidget.statically.jsp.html.widgetbuilder.HtmlTable;
import org.metawidget.statically.jsp.html.widgetbuilder.HtmlTableBody;
import org.metawidget.statically.jsp.html.widgetbuilder.HtmlTableCell;
import org.metawidget.statically.jsp.html.widgetbuilder.HtmlTableHeader;
import org.metawidget.statically.jsp.html.widgetbuilder.HtmlTableRow;
import org.metawidget.util.simple.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlTableLayout
implements AdvancedLayout<StaticXmlWidget, StaticXmlWidget, StaticXmlMetawidget> {
    private static final String TABLE_PREFIX = "table-";
    private String mTableStyle;
    private String mTableStyleClass;

    public HtmlTableLayout() {
        this(new HtmlTableLayoutConfig());
    }

    public HtmlTableLayout(HtmlTableLayoutConfig config) {
        this.mTableStyle = config.getTableStyle();
        this.mTableStyleClass = config.getTableStyleClass();
    }

    @Override
    public void onStartBuild(StaticXmlMetawidget metawidget) {
    }

    @Override
    public void startContainerLayout(StaticXmlWidget container, StaticXmlMetawidget metawidget) {
        try {
            HtmlTable table = new HtmlTable();
            if (metawidget.getPath() != null) {
                String path = metawidget.getPath();
                path = path.replace('/', '.');
                String id = TABLE_PREFIX + StringUtils.camelCase(path, '.');
                table.putAttribute("id", id);
            }
            if (this.mTableStyle != null) {
                table.putAttribute("style", this.mTableStyle);
            }
            if (this.mTableStyleClass != null) {
                table.putAttribute("class", this.mTableStyleClass);
            }
            table.getChildren().add(new HtmlTableBody());
            container.getChildren().add(table);
        }
        catch (Exception e) {
            throw LayoutException.newException(e);
        }
    }

    @Override
    public void layoutWidget(StaticXmlWidget widget, String elementName, Map<String, String> attributes, StaticXmlWidget container, StaticXmlMetawidget metawidget) {
        try {
            if (widget instanceof StaticXmlStub) {
                return;
            }
            HtmlTableBody body = (HtmlTableBody)container.getChildren().get(0).getChildren().get(0);
            HtmlTableRow row = new HtmlTableRow();
            this.layoutLabel(row, widget, elementName, attributes, metawidget);
            HtmlTableCell cell = new HtmlTableCell();
            cell.getChildren().add(widget);
            row.getChildren().add(cell);
            HtmlTableCell requiredCell = new HtmlTableCell();
            if ("true".equals(attributes.get("required"))) {
                requiredCell.setTextContent("*");
            }
            row.getChildren().add(requiredCell);
            body.getChildren().add(row);
        }
        catch (Exception e) {
            throw LayoutException.newException(e);
        }
    }

    @Override
    public void endContainerLayout(StaticXmlWidget container, StaticXmlMetawidget metawidget) {
    }

    @Override
    public void onEndBuild(StaticXmlMetawidget metawidget) {
    }

    protected boolean layoutLabel(HtmlTableRow row, StaticXmlWidget widgetNeedingLabel, String elementName, Map<String, String> attributes, StaticXmlMetawidget metawidget) {
        HtmlLabel label = new HtmlLabel();
        String id = this.getWidgetId(widgetNeedingLabel);
        if (id != null) {
            label.putAttribute("for", id);
        }
        String labelText = metawidget.getLabelString(attributes);
        label.setTextContent(labelText);
        HtmlTableHeader labelCell = new HtmlTableHeader();
        labelCell.getChildren().add(label);
        row.getChildren().add(labelCell);
        return true;
    }

    protected String getWidgetId(StaticXmlWidget widget) {
        String id = widget.getAttribute("id");
        if (id != null) {
            return id;
        }
        for (StaticWidget child : widget.getChildren()) {
            id = this.getWidgetId((StaticXmlWidget)child);
            if (id == null) continue;
            return id;
        }
        return null;
    }
}

