/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.inspector.impl;

import java.io.InputStream;
import org.metawidget.config.iface.NeedsResourceResolver;
import org.metawidget.config.iface.ResourceResolver;
import org.metawidget.config.impl.SimpleResourceResolver;
import org.metawidget.inspector.impl.propertystyle.PropertyStyle;
import org.metawidget.util.simple.ObjectUtils;

public class BaseXmlInspectorConfig
implements NeedsResourceResolver {
    private String mDefaultFile;
    private ResourceResolver mResourceResolver;
    private InputStream[] mInputStreams;
    private PropertyStyle mRestrictAgainstObject;
    private boolean mInferInheritanceHierarchy;
    private PropertyStyle mValidateAgainstClasses;

    public BaseXmlInspectorConfig setInputStreams(InputStream ... streams) {
        this.mInputStreams = streams;
        return this;
    }

    public BaseXmlInspectorConfig setInputStream(InputStream stream) {
        this.mDefaultFile = null;
        this.mInputStreams = new InputStream[]{stream};
        return this;
    }

    public void setResourceResolver(ResourceResolver resourceResolver) {
        this.mResourceResolver = resourceResolver;
    }

    public BaseXmlInspectorConfig setRestrictAgainstObject(PropertyStyle restrictAgainstObject) {
        this.mRestrictAgainstObject = restrictAgainstObject;
        return this;
    }

    public BaseXmlInspectorConfig setInferInheritanceHierarchy(boolean inferInheritanceHierarchy) {
        this.mInferInheritanceHierarchy = inferInheritanceHierarchy;
        return this;
    }

    public BaseXmlInspectorConfig setValidateAgainstClasses(PropertyStyle validateAgainstClasses) {
        this.mValidateAgainstClasses = validateAgainstClasses;
        return this;
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (!ObjectUtils.nullSafeClassEquals(this, that)) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals(this.mDefaultFile, ((BaseXmlInspectorConfig)that).mDefaultFile)) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals(this.mResourceResolver, ((BaseXmlInspectorConfig)that).mResourceResolver)) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals(this.mInputStreams, ((BaseXmlInspectorConfig)that).mInputStreams)) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals(this.mRestrictAgainstObject, ((BaseXmlInspectorConfig)that).mRestrictAgainstObject)) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals(this.mInferInheritanceHierarchy, ((BaseXmlInspectorConfig)that).mInferInheritanceHierarchy)) {
            return false;
        }
        return ObjectUtils.nullSafeEquals(this.mValidateAgainstClasses, ((BaseXmlInspectorConfig)that).mValidateAgainstClasses);
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ObjectUtils.nullSafeHashCode(this.mDefaultFile);
        hashCode = 31 * hashCode + ObjectUtils.nullSafeHashCode(this.mResourceResolver);
        hashCode = 31 * hashCode + ObjectUtils.nullSafeHashCode(this.mInputStreams);
        hashCode = 31 * hashCode + ObjectUtils.nullSafeHashCode(this.mRestrictAgainstObject);
        hashCode = 31 * hashCode + ObjectUtils.nullSafeHashCode(this.mInferInheritanceHierarchy);
        hashCode = 31 * hashCode + ObjectUtils.nullSafeHashCode(this.mValidateAgainstClasses);
        return hashCode;
    }

    protected void setDefaultFile(String defaultFile) {
        this.mDefaultFile = defaultFile;
    }

    protected InputStream[] getInputStreams() {
        if (this.mInputStreams == null && this.mDefaultFile != null) {
            return new InputStream[]{this.getResourceResolver().openResource(this.mDefaultFile)};
        }
        return this.mInputStreams;
    }

    protected ResourceResolver getResourceResolver() {
        if (this.mResourceResolver == null) {
            return new SimpleResourceResolver();
        }
        return this.mResourceResolver;
    }

    protected PropertyStyle getRestrictAgainstObject() {
        return this.mRestrictAgainstObject;
    }

    protected boolean isInferInheritanceHierarchy() {
        return this.mInferInheritanceHierarchy;
    }

    protected PropertyStyle getValidateAgainstClasses() {
        return this.mValidateAgainstClasses;
    }
}

