/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.inspector.impl.propertystyle.javabean;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.metawidget.inspector.iface.InspectorException;
import org.metawidget.inspector.impl.propertystyle.BaseProperty;
import org.metawidget.inspector.impl.propertystyle.BasePropertyStyle;
import org.metawidget.inspector.impl.propertystyle.Property;
import org.metawidget.inspector.impl.propertystyle.javabean.JavaBeanPropertyStyleConfig;
import org.metawidget.util.ClassUtils;
import org.metawidget.util.CollectionUtils;
import org.metawidget.util.simple.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaBeanPropertyStyle
extends BasePropertyStyle {
    private boolean mSupportPublicFields;
    private MessageFormat mPrivateFieldConvention;
    private ClassLoader mAdditionalClassLoader;

    public JavaBeanPropertyStyle() {
        this(new JavaBeanPropertyStyleConfig());
    }

    public JavaBeanPropertyStyle(JavaBeanPropertyStyleConfig config) {
        super(config);
        this.mSupportPublicFields = config.isSupportPublicFields();
        this.mPrivateFieldConvention = config.getPrivateFieldConvention();
        this.mAdditionalClassLoader = config.getAdditionalClassLoader();
    }

    @Override
    protected Map<String, Property> inspectProperties(String type) {
        TreeMap<String, Property> properties = CollectionUtils.newTreeMap(StringUtils.CASE_INSENSITIVE_COMPARATOR);
        Class<?> clazz = ClassUtils.niceForName(type, this.mAdditionalClassLoader);
        if (clazz == null) {
            return properties;
        }
        this.lookupFields(properties, clazz);
        this.lookupGetters(properties, clazz);
        this.lookupSetters(properties, clazz);
        Iterator i = properties.entrySet().iterator();
        while (i.hasNext()) {
            if (i.next().getValue() != null) continue;
            i.remove();
        }
        return properties;
    }

    protected void lookupFields(Map<String, Property> properties, Class<?> clazz) {
        if (!this.mSupportPublicFields) {
            return;
        }
        for (Field field : clazz.getFields()) {
            int modifiers = field.getModifiers();
            if (Modifier.isStatic(modifiers)) continue;
            String fieldName = field.getName();
            Class<?> type = field.getType();
            if (this.isExcluded(field.getDeclaringClass(), fieldName, type)) {
                properties.put(fieldName, null);
                continue;
            }
            properties.put(fieldName, new FieldProperty(fieldName, field));
        }
    }

    protected void lookupGetters(Map<String, Property> properties, Class<?> clazz) {
        for (Method method : clazz.getMethods()) {
            JavaBeanProperty existingJavaBeanProperty;
            String propertyName;
            Class<?> type;
            if (Modifier.isStatic(method.getModifiers()) || method.getParameterTypes().length != 0 || Void.TYPE.equals(type = method.getReturnType()) || (propertyName = this.isGetter(method)) == null) continue;
            if (this.isExcluded(ClassUtils.getOriginalDeclaringClass(method), propertyName, type)) {
                properties.put(propertyName, null);
                continue;
            }
            Property existingProperty = properties.get(propertyName);
            if (existingProperty instanceof FieldProperty) {
                throw InspectorException.newException("JavaBeanProperty '" + ((FieldProperty)existingProperty).getField() + "' has both a public member variable and a public getter method. Should be one or the other");
            }
            if (existingProperty instanceof JavaBeanProperty && type.isAssignableFrom(ClassUtils.niceForName((existingJavaBeanProperty = (JavaBeanProperty)existingProperty).getType(), this.mAdditionalClassLoader)) || existingProperty == null && properties.containsKey(propertyName)) continue;
            properties.put(propertyName, new JavaBeanProperty(propertyName, type.getName(), method, null, this.getPrivateField(clazz, propertyName)));
        }
    }

    protected String isGetter(Method method) {
        String propertyName;
        String methodName = method.getName();
        if (methodName.startsWith("get")) {
            propertyName = methodName.substring("get".length());
        } else if (methodName.startsWith("is") && Boolean.TYPE.equals(method.getReturnType())) {
            propertyName = methodName.substring("is".length());
        } else {
            return null;
        }
        if (!StringUtils.isCapitalized(propertyName)) {
            return null;
        }
        return StringUtils.decapitalize(propertyName);
    }

    protected void lookupSetters(Map<String, Property> properties, Class<?> clazz) {
        for (Method method : clazz.getMethods()) {
            Class<?>[] parameters;
            if (Modifier.isStatic(method.getModifiers()) || (parameters = method.getParameterTypes()).length != 1) continue;
            Class<?> type = parameters[0];
            String propertyName = this.isSetter(method);
            if (propertyName == null) continue;
            if (this.isExcluded(ClassUtils.getOriginalDeclaringClass(method), propertyName, type)) {
                properties.put(propertyName, null);
                continue;
            }
            Property existingProperty = properties.get(propertyName);
            if (existingProperty instanceof FieldProperty) {
                throw InspectorException.newException("JavaBeanProperty '" + ((FieldProperty)existingProperty).getField() + "' has both a public member variable and a public setter method. Should be one or the other");
            }
            if (existingProperty instanceof JavaBeanProperty) {
                JavaBeanProperty existingJavaBeanProperty = (JavaBeanProperty)existingProperty;
                properties.put(propertyName, new JavaBeanProperty(propertyName, existingJavaBeanProperty.getType(), existingJavaBeanProperty.getReadMethod(), method, this.getPrivateField(clazz, propertyName)));
                continue;
            }
            if (existingProperty == null && properties.containsKey(propertyName)) continue;
            properties.put(propertyName, new JavaBeanProperty(propertyName, type.getName(), null, method, this.getPrivateField(clazz, propertyName)));
        }
    }

    protected String isSetter(Method method) {
        String methodName = method.getName();
        if (!methodName.startsWith("set")) {
            return null;
        }
        String propertyName = methodName.substring("set".length());
        if (!StringUtils.isCapitalized(propertyName)) {
            return null;
        }
        return StringUtils.decapitalize(propertyName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Field getPrivateField(Class<?> clazz, String propertyName) {
        String fieldName;
        if (this.mPrivateFieldConvention == null) {
            return null;
        }
        Object[] arguments = new String[]{propertyName, StringUtils.capitalize(propertyName)};
        MessageFormat messageFormat = this.mPrivateFieldConvention;
        synchronized (messageFormat) {
            fieldName = this.mPrivateFieldConvention.format(arguments, new StringBuffer(), (FieldPosition)null).toString();
        }
        for (Class<?> currentClass = clazz; currentClass != null && !this.isExcludedBaseType(currentClass); currentClass = currentClass.getSuperclass()) {
            try {
                return currentClass.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException e) {
                continue;
            }
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class JavaBeanProperty
    extends BaseProperty {
        private Method mReadMethod;
        private Method mWriteMethod;
        private Field mPrivateField;

        public JavaBeanProperty(String name, String type, Method readMethod, Method writeMethod, Field privateField) {
            super(name, type);
            this.mReadMethod = readMethod;
            this.mWriteMethod = writeMethod;
            if (this.mReadMethod == null && this.mWriteMethod == null) {
                throw InspectorException.newException("JavaBeanProperty '" + name + "' has no getter and no setter");
            }
            this.mPrivateField = privateField;
        }

        @Override
        public boolean isReadable() {
            return this.mReadMethod != null;
        }

        @Override
        public Object read(Object obj) {
            try {
                return this.mReadMethod.invoke(obj, new Object[0]);
            }
            catch (Exception e) {
                throw InspectorException.newException(e);
            }
        }

        @Override
        public boolean isWritable() {
            return this.mWriteMethod != null;
        }

        @Override
        public void write(Object obj, Object value) {
            try {
                this.mWriteMethod.invoke(obj, value);
            }
            catch (Exception e) {
                throw InspectorException.newException(e);
            }
        }

        @Override
        public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
            T annotation;
            if (this.mReadMethod != null && (annotation = ClassUtils.getOriginalAnnotation(this.mReadMethod, annotationClass)) != null) {
                return annotation;
            }
            if (this.mWriteMethod != null && (annotation = ClassUtils.getOriginalAnnotation(this.mWriteMethod, annotationClass)) != null) {
                return annotation;
            }
            if (this.mPrivateField != null) {
                annotation = this.mPrivateField.getAnnotation(annotationClass);
                if (annotation != null) {
                    return annotation;
                }
                return null;
            }
            return null;
        }

        @Override
        public String getGenericType() {
            Type type = this.mReadMethod != null ? ClassUtils.getOriginalGenericReturnType(this.mReadMethod) : ClassUtils.getOriginalGenericParameterTypes(this.mWriteMethod)[0];
            return ClassUtils.getGenericTypeAsString(type);
        }

        public Method getReadMethod() {
            return this.mReadMethod;
        }

        public Method getWriteMethod() {
            return this.mWriteMethod;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FieldProperty
    extends BaseProperty {
        private Field mField;

        public FieldProperty(String name, Field field) {
            super(name, field.getType().getName());
            this.mField = field;
        }

        @Override
        public boolean isReadable() {
            return true;
        }

        @Override
        public Object read(Object obj) {
            try {
                return this.mField.get(obj);
            }
            catch (Exception e) {
                throw InspectorException.newException(e);
            }
        }

        @Override
        public boolean isWritable() {
            return true;
        }

        @Override
        public void write(Object obj, Object value) {
            try {
                this.mField.set(obj, value);
            }
            catch (Exception e) {
                throw InspectorException.newException(e);
            }
        }

        @Override
        public <T extends Annotation> T getAnnotation(Class<T> annotation) {
            return this.mField.getAnnotation(annotation);
        }

        @Override
        public String getGenericType() {
            return ClassUtils.getGenericTypeAsString(this.mField.getGenericType());
        }

        public Field getField() {
            return this.mField;
        }
    }
}

