/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.gwt.client.ui.layout;

import com.google.gwt.user.client.ui.ComplexPanel;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.Widget;
import java.util.HashMap;
import java.util.Map;
import org.metawidget.gwt.client.ui.Facet;
import org.metawidget.gwt.client.ui.GwtMetawidget;
import org.metawidget.gwt.client.ui.Stub;
import org.metawidget.gwt.client.ui.layout.FlexTableLayoutConfig;
import org.metawidget.layout.iface.AdvancedLayout;
import org.metawidget.util.simple.SimpleLayoutUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlexTableLayout
implements AdvancedLayout<Widget, Panel, GwtMetawidget> {
    private static final int LABEL_AND_COMPONENT_AND_REQUIRED = 3;
    private final int mNumberOfColumns;
    private final String mTableStyleName;
    private final String[] mColumnStyleNames;
    private final String mFooterStyleName;

    public FlexTableLayout() {
        this(new FlexTableLayoutConfig());
    }

    public FlexTableLayout(FlexTableLayoutConfig config) {
        this.mNumberOfColumns = config.getNumberOfColumns();
        this.mTableStyleName = config.getTableStyleName();
        this.mColumnStyleNames = config.getColumnStyleNames();
        this.mFooterStyleName = config.getFooterStyleName();
    }

    @Override
    public void onStartBuild(GwtMetawidget metawidget) {
    }

    @Override
    public void startContainerLayout(Panel container, GwtMetawidget metawidget) {
        State state = this.getState((Widget)container, metawidget);
        FlexTable flexTable = new FlexTable();
        flexTable.setStyleName(this.mTableStyleName);
        container.add((Widget)flexTable);
        state.formatter = flexTable.getFlexCellFormatter();
    }

    @Override
    public void layoutWidget(Widget widget, String elementName, Map<String, String> attributes, Panel container, GwtMetawidget metawidget) {
        int colspan;
        String styleName;
        String labelText;
        int actualColumn;
        if (widget instanceof Stub && ((Stub)widget).getWidgetCount() == 0) {
            return;
        }
        FlexTable flexTable = (FlexTable)((ComplexPanel)container).getWidget(0);
        int row = flexTable.getRowCount();
        int numberOfColumns = this.getEffectiveNumberOfColumns((Widget)container);
        State state = this.getState((Widget)container, metawidget);
        if (state.currentColumn < numberOfColumns && row > 0) {
            actualColumn = flexTable.getCellCount(--row);
        } else {
            state.currentColumn = 0;
            actualColumn = 0;
        }
        boolean spanAllColumns = this.willFillHorizontally(widget, attributes);
        if (spanAllColumns && state.currentColumn > 0) {
            state.currentColumn = 0;
            actualColumn = 0;
            ++row;
        }
        if (SimpleLayoutUtils.needsLabel(labelText = metawidget.getLabelString(attributes), elementName)) {
            Label label = new Label(labelText + ":");
            String styleName2 = this.getStyleName(state.currentColumn * 3, metawidget);
            if (styleName2 != null) {
                state.formatter.setStyleName(row, actualColumn, styleName2);
            }
            flexTable.setWidget(row, actualColumn, (Widget)label);
        }
        if (labelText != null) {
            if (numberOfColumns == 0) {
                state.currentColumn = 0;
                actualColumn = 0;
                ++row;
            } else {
                ++actualColumn;
            }
        }
        if ((styleName = this.getStyleName(state.currentColumn * 3 + 1, metawidget)) != null) {
            state.formatter.setStyleName(row, actualColumn, styleName);
        }
        flexTable.setWidget(row, actualColumn, widget);
        if (spanAllColumns) {
            colspan = numberOfColumns * 3 - 2;
            state.currentColumn = numberOfColumns;
            if (labelText == null) {
                ++colspan;
            }
            if (widget instanceof GwtMetawidget) {
                ++colspan;
            }
        } else {
            colspan = labelText == null ? 2 : 1;
        }
        if (colspan > 1) {
            state.formatter.setColSpan(row, actualColumn, colspan);
        }
        if (!(widget instanceof GwtMetawidget)) {
            this.layoutRequired(attributes, (Widget)container, metawidget);
        }
        ++state.currentColumn;
    }

    @Override
    public void endContainerLayout(Panel container, GwtMetawidget metawidget) {
    }

    @Override
    public void onEndBuild(GwtMetawidget metawidget) {
        Facet facet = metawidget.getFacet("buttons");
        if (facet != null) {
            State state = this.getState((Widget)metawidget, metawidget);
            FlexTable flexTable = (FlexTable)metawidget.getWidget(0);
            int row = flexTable.getRowCount();
            int numberOfColumns = this.getEffectiveNumberOfColumns((Widget)metawidget);
            if (numberOfColumns > 0) {
                state.formatter.setColSpan(row, 0, numberOfColumns * 3);
            }
            if (this.mFooterStyleName != null) {
                state.formatter.setStyleName(row, 0, this.mFooterStyleName);
            }
            flexTable.setWidget(row, 0, (Widget)facet);
        }
    }

    protected void layoutRequired(Map<String, String> attributes, Widget container, GwtMetawidget metawidget) {
        State state = this.getState(container, metawidget);
        FlexTable flexTable = (FlexTable)((ComplexPanel)container).getWidget(0);
        int row = flexTable.getRowCount() - 1;
        int column = flexTable.getCellCount(row);
        state.formatter.setStyleName(row, column, this.getStyleName(state.currentColumn * 3 + 2, metawidget));
        if (attributes != null && "true".equals(attributes.get("required")) && !"true".equals(attributes.get("read-only")) && !metawidget.isReadOnly()) {
            flexTable.setText(row, column, "*");
            return;
        }
        flexTable.setHTML(row, column, "<div></div>");
    }

    protected String getStyleName(int styleName, GwtMetawidget metawidget) {
        if (this.mColumnStyleNames == null || this.mColumnStyleNames.length <= styleName) {
            return null;
        }
        return this.mColumnStyleNames[styleName];
    }

    protected boolean willFillHorizontally(Widget widget, Map<String, String> attributes) {
        if (widget instanceof GwtMetawidget) {
            return true;
        }
        return SimpleLayoutUtils.isSpanAllColumns(attributes);
    }

    private int getEffectiveNumberOfColumns(Widget container) {
        if (container.getParent() instanceof FlexTable && container.getParent().getParent() instanceof GwtMetawidget) {
            return 1;
        }
        return this.mNumberOfColumns;
    }

    private State getState(Widget container, GwtMetawidget metawidget) {
        State state;
        HashMap<Widget, State> stateMap = (HashMap<Widget, State>)metawidget.getClientProperty(this.getClass());
        if (stateMap == null) {
            stateMap = new HashMap<Widget, State>();
            metawidget.putClientProperty(this.getClass(), stateMap);
        }
        if ((state = (State)stateMap.get(container)) == null) {
            state = new State();
            stateMap.put(container, state);
        }
        return state;
    }

    static class State {
        FlexTable.FlexCellFormatter formatter;
        int currentColumn;

        State() {
        }
    }
}

