/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.statically;

import java.io.Writer;
import java.util.List;
import java.util.Map;
import org.metawidget.config.iface.ConfigReader;
import org.metawidget.iface.MetawidgetException;
import org.metawidget.inspectionresultprocessor.iface.InspectionResultProcessor;
import org.metawidget.inspector.iface.Inspector;
import org.metawidget.layout.iface.Layout;
import org.metawidget.pipeline.w3c.W3CPipeline;
import org.metawidget.statically.BaseStaticWidget;
import org.metawidget.statically.StaticUtils;
import org.metawidget.statically.StaticWidget;
import org.metawidget.util.simple.PathUtils;
import org.metawidget.util.simple.StringUtils;
import org.metawidget.widgetbuilder.iface.WidgetBuilder;
import org.metawidget.widgetprocessor.iface.WidgetProcessor;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StaticMetawidget
extends BaseStaticWidget {
    private String mPath;
    private Pipeline mPipeline = this.newPipeline();

    public void setPath(String path) {
        this.mPath = path;
    }

    public String getPath() {
        return this.mPath;
    }

    public ConfigReader getConfigReader() {
        return this.mPipeline.getConfigReader();
    }

    public void setConfigReader(ConfigReader configReader) {
        this.mPipeline.setConfigReader(configReader);
    }

    public String getConfig() {
        return (String)this.mPipeline.getConfig();
    }

    public void setConfig(String config) {
        this.mPipeline.setConfig(config);
    }

    public void setMaximumInspectionDepth(int maximumInspectionDepth) {
        this.mPipeline.setMaximumInspectionDepth(maximumInspectionDepth);
    }

    public String getLabelString(Map<String, String> attributes) {
        if (attributes == null) {
            return "";
        }
        String label = attributes.get("label");
        if (label != null) {
            if ("".equals(label)) {
                return null;
            }
            return label.trim();
        }
        String name = attributes.get("name");
        if (name != null) {
            return StringUtils.uncamelCase(name);
        }
        return "";
    }

    public boolean isReadOnly() {
        return this.mPipeline.isReadOnly();
    }

    public void setReadOnly(boolean readOnly) {
        this.mPipeline.setReadOnly(readOnly);
    }

    public Inspector getInspector() {
        return this.mPipeline.getInspector();
    }

    public void setInspector(Inspector inspector) {
        this.mPipeline.setInspector(inspector);
    }

    public String inspect(Object toInspect, String type, String ... names) {
        return this.mPipeline.inspect(toInspect, type, names);
    }

    public void initNestedMetawidget(StaticMetawidget nestedMetawidget, Map<String, String> attributes) {
        nestedMetawidget.setConfig(null);
        this.mPipeline.initNestedPipeline(nestedMetawidget.mPipeline, attributes);
        if (nestedMetawidget.getPath() == null) {
            nestedMetawidget.setPath(this.mPath + '/' + attributes.get("name"));
        }
    }

    public void setInspectionResultProcessors(InspectionResultProcessor<? extends StaticMetawidget> ... inspectionResultProcessors) {
        this.mPipeline.setInspectionResultProcessors(inspectionResultProcessors);
    }

    public WidgetBuilder<StaticWidget, StaticMetawidget> getWidgetBuilder() {
        return this.mPipeline.getWidgetBuilder();
    }

    public <W extends StaticWidget, M extends W> void setWidgetBuilder(WidgetBuilder<W, M> widgetBuilder) {
        this.mPipeline.setWidgetBuilder(widgetBuilder);
    }

    public <W extends StaticWidget, M extends W> void addWidgetProcessor(WidgetProcessor<W, M> widgetProcessor) {
        this.mPipeline.addWidgetProcessor(widgetProcessor);
    }

    public List<WidgetProcessor<StaticWidget, StaticMetawidget>> getWidgetProcessors() {
        return this.mPipeline.getWidgetProcessors();
    }

    public <W extends StaticWidget, M extends W> void setWidgetProcessors(WidgetProcessor<W, M> ... widgetProcessors) {
        this.mPipeline.setWidgetProcessors(widgetProcessors);
    }

    public <T> T getWidgetProcessor(Class<T> widgetProcessorClass) {
        return this.mPipeline.getWidgetProcessor(widgetProcessorClass);
    }

    public <W extends StaticWidget, M extends W> void removeWidgetProcessor(WidgetProcessor<W, M> widgetProcessor) {
        this.mPipeline.removeWidgetProcessor(widgetProcessor);
    }

    public Layout<StaticWidget, StaticWidget, StaticMetawidget> getLayout() {
        return this.mPipeline.getLayout();
    }

    public <W extends StaticWidget, C extends W, M extends C> void setLayout(Layout<W, C, M> layout) {
        this.mPipeline.setLayout(layout);
    }

    @Override
    public void write(Writer writer) {
        this.write(writer, -1);
    }

    public void write(Writer writer, int initialIndent) {
        try {
            this.mPipeline.buildWidgets(this.inspect());
            Writer writerToUse = writer;
            if (initialIndent >= 0) {
                writerToUse = new StaticUtils.IndentedWriter(writer, initialIndent);
            }
            super.write(writerToUse);
        }
        catch (Exception e) {
            throw MetawidgetException.newException(e);
        }
    }

    protected Pipeline newPipeline() {
        return new Pipeline();
    }

    protected void startBuild() {
        this.getChildren().clear();
    }

    protected void beforeBuildCompoundWidget(Element element) {
    }

    protected Element inspect() {
        if (this.mPath == null) {
            return null;
        }
        PathUtils.TypeAndNames typeAndNames = PathUtils.parsePath(this.mPath, '/');
        String type = typeAndNames.getType();
        return (Element)this.mPipeline.inspectAsDom(null, type, typeAndNames.getNamesAsArray());
    }

    protected abstract String getDefaultConfiguration();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class Pipeline
    extends W3CPipeline<StaticWidget, StaticWidget, StaticMetawidget> {
        protected Pipeline() {
        }

        @Override
        protected String getDefaultConfiguration() {
            return StaticMetawidget.this.getDefaultConfiguration();
        }

        @Override
        protected Map<String, String> getAdditionalAttributes(StaticWidget tag) {
            return null;
        }

        @Override
        protected void startBuild() {
            StaticMetawidget.this.startBuild();
            super.startBuild();
        }

        @Override
        protected void buildCompoundWidget(Element element) throws Exception {
            StaticMetawidget.this.beforeBuildCompoundWidget(element);
            super.buildCompoundWidget(element);
        }

        @Override
        protected StaticMetawidget buildNestedMetawidget(Map<String, String> attributes) throws Exception {
            StaticMetawidget metawidgetTag = (StaticMetawidget)StaticMetawidget.this.getClass().newInstance();
            StaticMetawidget.this.initNestedMetawidget(metawidgetTag, attributes);
            return metawidgetTag;
        }

        @Override
        protected StaticMetawidget getPipelineOwner() {
            return StaticMetawidget.this;
        }
    }
}

