/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.swing.layout;

import java.awt.Component;
import java.util.List;
import java.util.Map;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.metawidget.layout.iface.AdvancedLayout;
import org.metawidget.swing.Facet;
import org.metawidget.swing.Stub;
import org.metawidget.swing.SwingMetawidget;
import org.metawidget.util.CollectionUtils;
import org.metawidget.util.WidgetBuilderUtils;
import org.metawidget.util.simple.SimpleLayoutUtils;

public class GroupLayout
implements AdvancedLayout<JComponent, JComponent, SwingMetawidget> {
    private static final Component[] EMPTY_COMPONENTS_ARRAY = new Component[0];
    private static final int COMPONENT_GAP = 3;
    private static final String LABEL_NAME_SUFFIX = "_label";

    @Override
    public void onStartBuild(SwingMetawidget metawidget) {
    }

    @Override
    public void startContainerLayout(JComponent container, SwingMetawidget metawidget) {
        javax.swing.GroupLayout groupLayout = new javax.swing.GroupLayout(container);
        container.setLayout(groupLayout);
        container.putClientProperty(GroupLayout.class, null);
        State state = this.getState(container);
        state.groupHorizontal = groupLayout.createParallelGroup();
        groupLayout.setHorizontalGroup(state.groupHorizontal);
        state.labels = CollectionUtils.newArrayList();
        state.groupVertical = groupLayout.createSequentialGroup();
        groupLayout.setVerticalGroup(state.groupVertical);
    }

    @Override
    public void layoutWidget(JComponent component, String elementName, Map<String, String> attributes, JComponent container, SwingMetawidget metawidget) {
        String labelText;
        if (component instanceof Stub && ((Stub)component).getComponentCount() == 0) {
            return;
        }
        javax.swing.GroupLayout groupLayout = (javax.swing.GroupLayout)container.getLayout();
        GroupLayout.SequentialGroup sequentialGroup = groupLayout.createSequentialGroup();
        GroupLayout.ParallelGroup parallelGroup = groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE);
        State state = this.getState(container);
        state.groupHorizontal.addGroup(sequentialGroup);
        state.groupVertical.addGap(3, 3, 3);
        state.groupVertical.addGroup(parallelGroup);
        if (attributes != null && SimpleLayoutUtils.needsLabel(labelText = metawidget.getLabelString(attributes), elementName)) {
            JLabel label = new JLabel();
            label.setName(attributes.get("name") + LABEL_NAME_SUFFIX);
            SimpleLayoutUtils.StrippedMnemonicAndFirstIndex stripMnemonic = SimpleLayoutUtils.stripMnemonic(labelText);
            String labelTextToUse = stripMnemonic.getStrippedMnemonic();
            if ("true".equals(attributes.get("required")) && !WidgetBuilderUtils.isReadOnly(attributes) && !metawidget.isReadOnly()) {
                labelTextToUse = labelTextToUse + "*";
            }
            label.setText(labelTextToUse + ":");
            label.setLabelFor(component);
            int mnemonicIndex = stripMnemonic.getFirstIndex();
            if (mnemonicIndex != -1) {
                label.setDisplayedMnemonic(labelTextToUse.charAt(mnemonicIndex));
                label.setDisplayedMnemonicIndex(mnemonicIndex);
            }
            sequentialGroup.addComponent(label).addGap(3, 3, 3);
            parallelGroup.addComponent(label);
            state.labels.add(label);
        }
        sequentialGroup.addComponent(component);
        parallelGroup.addComponent(component);
    }

    @Override
    public void endContainerLayout(JComponent container, SwingMetawidget metawidget) {
        State state = this.getState(container);
        javax.swing.GroupLayout groupLayout = (javax.swing.GroupLayout)container.getLayout();
        if (!state.labels.isEmpty()) {
            groupLayout.linkSize(0, state.labels.toArray(EMPTY_COMPONENTS_ARRAY));
        }
    }

    @Override
    public void onEndBuild(SwingMetawidget metawidget) {
        Facet facetButtons = metawidget.getFacet("buttons");
        if (facetButtons != null) {
            State state = this.getState(metawidget);
            javax.swing.GroupLayout groupLayout = (javax.swing.GroupLayout)metawidget.getLayout();
            state.groupHorizontal.addGroup(groupLayout.createSequentialGroup().addComponent(facetButtons));
            state.groupVertical.addGap(3, 3, 3);
            state.groupVertical.addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(facetButtons));
        }
    }

    private State getState(JComponent container) {
        State state = (State)container.getClientProperty(GroupLayout.class);
        if (state == null) {
            state = new State();
            container.putClientProperty(GroupLayout.class, state);
        }
        return state;
    }

    static class State {
        GroupLayout.ParallelGroup groupHorizontal;
        GroupLayout.SequentialGroup groupVertical;
        List<JLabel> labels;

        State() {
        }
    }
}

