/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.config.impl;

import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Stack;
import java.util.regex.Pattern;
import javax.xml.parsers.SAXParserFactory;
import org.metawidget.config.iface.ConfigReader;
import org.metawidget.config.iface.NeedsResourceResolver;
import org.metawidget.config.iface.ResourceResolver;
import org.metawidget.config.impl.SimpleResourceResolver;
import org.metawidget.iface.Immutable;
import org.metawidget.iface.MetawidgetException;
import org.metawidget.inspector.iface.InspectorException;
import org.metawidget.util.ArrayUtils;
import org.metawidget.util.ClassUtils;
import org.metawidget.util.CollectionUtils;
import org.metawidget.util.LogUtils;
import org.metawidget.util.XmlUtils;
import org.metawidget.util.simple.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseConfigReader
implements ConfigReader {
    static final String IMMUTABLE_NO_CONFIG = "no-config";
    static final LogUtils.Log LOG = LogUtils.getLog(BaseConfigReader.class);
    static final String JAVA_NAMESPACE_PREFIX = "java:";
    protected final SAXParserFactory mFactory;
    private final ResourceResolver mResourceResolver;
    final Map<String, XmlUtils.CachingContentHandler> mResourceCache = CollectionUtils.newHashMap();
    final Map<String, Map<Integer, Immutable>> mImmutableByLocationCache = CollectionUtils.newHashMap();
    final Map<Class<?>, Map<Object, Immutable>> mImmutableByClassCache = CollectionUtils.newWeakHashMap();
    final Map<String, Immutable> mImmutableByIdCache = CollectionUtils.newHashMap();
    final Map<String, Pattern> mPatternCache = CollectionUtils.newHashMap();

    public BaseConfigReader() {
        this(new SimpleResourceResolver());
    }

    public BaseConfigReader(ResourceResolver resourceResolver) {
        this.mFactory = SAXParserFactory.newInstance();
        this.mFactory.setNamespaceAware(true);
        this.mResourceResolver = resourceResolver;
    }

    @Override
    public Object configure(String string, Object object, String ... stringArray) {
        ConfigHandler configHandler = new ConfigHandler(object, stringArray);
        String string2 = string + StringUtils.SEPARATOR_FORWARD_SLASH;
        if (object instanceof Class) {
            string2 = string2 + ((Class)object).getName();
        } else if (object != null) {
            string2 = string2 + object.getClass().getName();
        }
        string2 = string2 + ArrayUtils.toString(stringArray, StringUtils.SEPARATOR_FORWARD_SLASH, true, false);
        Map<String, Map<Integer, Immutable>> map = this.mImmutableByLocationCache;
        synchronized (map) {
            Map<Integer, Immutable> map2 = this.mImmutableByLocationCache.get(string2);
            if (map2 == null) {
                map2 = CollectionUtils.newHashMap();
            }
            configHandler.setImmutableForThisLocationCache(map2);
            try {
                XmlUtils.CachingContentHandler cachingContentHandler = this.mResourceCache.get(string2);
                if (cachingContentHandler != null) {
                    cachingContentHandler.replay(configHandler);
                } else {
                    LOG.debug("Reading resource from {0}", string2);
                    cachingContentHandler = new XmlUtils.CachingContentHandler(configHandler);
                    configHandler.setCachingContentHandler(cachingContentHandler);
                    this.mFactory.newSAXParser().parse(this.mResourceResolver.openResource(string), (DefaultHandler)cachingContentHandler);
                    this.mResourceCache.put(string2, cachingContentHandler);
                    this.mImmutableByLocationCache.put(string2, map2);
                }
                return configHandler.getConfigured();
            }
            catch (Exception exception) {
                throw MetawidgetException.newException(exception);
            }
        }
    }

    @Override
    public Object configure(InputStream inputStream, Object object, String ... stringArray) {
        if (inputStream == null) {
            throw MetawidgetException.newException("No input stream specified");
        }
        try {
            ConfigHandler configHandler = new ConfigHandler(object, stringArray);
            this.mFactory.newSAXParser().parse(inputStream, (DefaultHandler)configHandler);
            return configHandler.getConfigured();
        }
        catch (Exception exception) {
            throw MetawidgetException.newException(exception);
        }
    }

    public final ResourceResolver getResourceResolver() {
        return this.mResourceResolver;
    }

    protected boolean isNative(String string) {
        if ("null".equals(string)) {
            return true;
        }
        if ("string".equals(string)) {
            return true;
        }
        if ("class".equals(string)) {
            return true;
        }
        if ("instanceOf".equals(string)) {
            return true;
        }
        if ("pattern".equals(string)) {
            return true;
        }
        if ("format".equals(string)) {
            return true;
        }
        if ("int".equals(string)) {
            return true;
        }
        if ("boolean".equals(string)) {
            return true;
        }
        if ("resource".equals(string)) {
            return true;
        }
        if ("url".equals(string)) {
            return true;
        }
        if ("file".equals(string)) {
            return true;
        }
        if ("bundle".equals(string)) {
            return true;
        }
        return "constant".equals(string);
    }

    protected boolean isLazyResolvingNative(String string) {
        return "enum".equals(string);
    }

    protected Object createNative(String string, Class<?> clazz, String string2) throws Exception {
        if ("null".equals(string)) {
            return null;
        }
        if ("string".equals(string)) {
            return string2;
        }
        if ("class".equals(string)) {
            if ("".equals(string2)) {
                return null;
            }
            return Class.forName(string2);
        }
        if ("instanceOf".equals(string)) {
            if ("".equals(string2)) {
                return null;
            }
            return Class.forName(string2).newInstance();
        }
        if ("pattern".equals(string)) {
            Pattern pattern = this.mPatternCache.get(string2);
            if (pattern == null) {
                pattern = Pattern.compile(string2);
                this.mPatternCache.put(string2, pattern);
            }
            return pattern;
        }
        if ("format".equals(string)) {
            return new MessageFormat(string2);
        }
        if ("int".equals(string)) {
            return Integer.valueOf(string2);
        }
        if ("boolean".equals(string)) {
            return Boolean.valueOf(string2);
        }
        if ("bundle".equals(string)) {
            return ResourceBundle.getBundle(string2);
        }
        if ("enum".equals(string)) {
            return string2;
        }
        if ("constant".equals(string)) {
            int n = string2.lastIndexOf(46);
            if (n != -1) {
                return Class.forName(string2.substring(0, n)).getDeclaredField(string2.substring(n + 1)).get(null);
            }
            return clazz.getDeclaredField(string2).get(null);
        }
        if ("resource".equals(string)) {
            return this.mResourceResolver.openResource(string2);
        }
        if ("url".equals(string)) {
            return new URL(string2).openStream();
        }
        if ("file".equals(string)) {
            return new FileInputStream(string2);
        }
        throw MetawidgetException.newException("Don't know how to convert '" + string2 + "' to a " + string);
    }

    protected Object createNativeCollection(String string) {
        if ("array".equals(string)) {
            return new Object[0];
        }
        if ("list".equals(string)) {
            return CollectionUtils.newArrayList();
        }
        if ("set".equals(string)) {
            return CollectionUtils.newHashSet();
        }
        return null;
    }

    protected Object createLazyResolvingNative(Object object, Class<?> clazz) {
        if (clazz.isArray() && object.getClass().isArray()) {
            Object[] objectArray = (Object[])object;
            Object[] objectArray2 = (Object[])Array.newInstance(clazz.getComponentType(), objectArray.length);
            try {
                System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
                return objectArray2;
            }
            catch (ArrayStoreException arrayStoreException) {
                return null;
            }
        }
        if (clazz.isEnum() && object instanceof String) {
            try {
                Object obj = Enum.valueOf(clazz, (String)object);
                return obj;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return null;
            }
        }
        return null;
    }

    protected Class<?> lookupClass(String string, String string2, ClassLoader classLoader) throws SAXException {
        String string3;
        if (!string.startsWith(JAVA_NAMESPACE_PREFIX)) {
            throw new SAXException("Namespace '" + string + "' of element <" + string2 + "> must start with " + JAVA_NAMESPACE_PREFIX);
        }
        String string4 = string.substring(JAVA_NAMESPACE_PREFIX.length());
        String string5 = StringUtils.capitalize(string2);
        String string6 = string4 + '.' + string5;
        Class<?> clazz = this.lookupClass(string6, classLoader);
        if (clazz == null && (clazz = this.lookupClass(string3 = string4 + '$' + string5, classLoader)) == null) {
            throw MetawidgetException.newException("No such tag <" + string2 + "> or class " + string6 + " (is it on your CLASSPATH?)");
        }
        return clazz;
    }

    protected Class<?> lookupClass(String string, ClassLoader classLoader) {
        return ClassUtils.niceForName(string, classLoader);
    }

    protected boolean isImmutable(Class<?> clazz) {
        return Immutable.class.isAssignableFrom(clazz);
    }

    private static class ConfigAndId {
        private Object mConfig;
        private String mId;

        public ConfigAndId(Object object, String string) {
            this.mConfig = object;
            this.mId = string;
        }

        public Object getConfig() {
            return this.mConfig;
        }

        public String getId() {
            return this.mId;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ConfigHandler
    extends DefaultHandler {
        private Object mToConfigure;
        private String[] mNames;
        private int mLocationIndex;
        private Map<Integer, Immutable> mImmutableForThisLocationCache;
        private int mDepth;
        private int mIgnoreTypeAfterDepth = -1;
        private int mIgnoreNameAfterDepth = -1;
        private int mIgnoreImmutableAfterDepth = -1;
        private Stack<Object> mConstructing = CollectionUtils.newStack();
        private ExpectingState mExpecting = ExpectingState.ROOT;
        private Stack<EncounteredState> mEncountered = CollectionUtils.newStack();
        private StringBuilder mBuilderValue;
        private XmlUtils.CachingContentHandler mCachingContentHandler;

        public ConfigHandler(Object object, String ... stringArray) {
            this.mToConfigure = object;
            this.mNames = stringArray;
        }

        public void setImmutableForThisLocationCache(Map<Integer, Immutable> map) {
            this.mImmutableForThisLocationCache = map;
        }

        public void setCachingContentHandler(XmlUtils.CachingContentHandler cachingContentHandler) {
            this.mCachingContentHandler = cachingContentHandler;
        }

        public Object getConfigured() {
            if (this.mConstructing.isEmpty()) {
                if (this.mToConfigure instanceof Class) {
                    throw MetawidgetException.newException("No match for " + this.mToConfigure + " within config");
                }
                throw MetawidgetException.newException("No match for " + this.mToConfigure.getClass() + " within config");
            }
            if (this.mConstructing.size() > 1) {
                throw MetawidgetException.newException("Config still processing");
            }
            return this.mConstructing.peek();
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            ++this.mDepth;
            if (this.mIgnoreTypeAfterDepth != -1 && this.mDepth > this.mIgnoreTypeAfterDepth) {
                return;
            }
            if (this.mIgnoreNameAfterDepth != -1 && this.mDepth > this.mIgnoreNameAfterDepth) {
                return;
            }
            if (Character.isUpperCase(string2.charAt(0))) {
                throw MetawidgetException.newException("XML node '" + string2 + "' should start with a lowercase letter");
            }
            try {
                switch (this.mExpecting) {
                    case ROOT: {
                        if (this.mToConfigure == null) {
                            this.mExpecting = ExpectingState.OBJECT;
                            break;
                        }
                        this.mExpecting = ExpectingState.TO_CONFIGURE;
                        break;
                    }
                    case TO_CONFIGURE: {
                        if (this.mDepth != 2) {
                            return;
                        }
                        Class<?> clazz = BaseConfigReader.this.lookupClass(string, string2, this.mToConfigure.getClass().getClassLoader());
                        if (this.mToConfigure instanceof Class) {
                            if (!((Class)this.mToConfigure).isAssignableFrom(clazz)) {
                                this.mEncountered.push(EncounteredState.WRONG_TYPE);
                                this.mIgnoreTypeAfterDepth = 2;
                                if (this.mCachingContentHandler != null) {
                                    this.mCachingContentHandler.pause(false);
                                }
                                return;
                            }
                            if (!this.mConstructing.isEmpty()) {
                                throw MetawidgetException.newException("Already configured a " + this.mConstructing.peek().getClass() + ", ambiguous match with " + clazz);
                            }
                            this.handleNonNativeObject(string, string2, attributes);
                        } else {
                            if (!this.mConstructing.isEmpty() || !clazz.isAssignableFrom(this.mToConfigure.getClass())) {
                                this.mEncountered.push(EncounteredState.WRONG_TYPE);
                                this.mIgnoreTypeAfterDepth = 2;
                                if (this.mCachingContentHandler != null) {
                                    this.mCachingContentHandler.pause(false);
                                }
                                return;
                            }
                            this.mConstructing.push(this.mToConfigure);
                            this.mEncountered.push(EncounteredState.JAVA_OBJECT);
                        }
                        this.mExpecting = ExpectingState.METHOD;
                        break;
                    }
                    case OBJECT: {
                        if (this.mCachingContentHandler == null || !this.mCachingContentHandler.isPaused()) {
                            ++this.mLocationIndex;
                        }
                        if (BaseConfigReader.this.isNative(string2) || BaseConfigReader.this.isLazyResolvingNative(string2)) {
                            this.mEncountered.push(EncounteredState.NATIVE_TYPE);
                            this.startRecording();
                            this.mExpecting = ExpectingState.METHOD;
                            return;
                        }
                        Object object = BaseConfigReader.this.createNativeCollection(string2);
                        if (object != null) {
                            this.mConstructing.push(object);
                            this.mEncountered.push(EncounteredState.NATIVE_COLLECTION_TYPE);
                            this.mExpecting = ExpectingState.OBJECT;
                            return;
                        }
                        this.mExpecting = this.handleNonNativeObject(string, string2, attributes);
                        break;
                    }
                    case METHOD: {
                        String string4;
                        int n;
                        if (this.mNames != null && (n = this.mDepth - 3) < this.mNames.length && !string2.equals(string4 = this.mNames[n])) {
                            this.mEncountered.push(EncounteredState.WRONG_NAME);
                            this.mIgnoreNameAfterDepth = this.mDepth;
                            if (this.mCachingContentHandler != null) {
                                this.mCachingContentHandler.pause(false);
                            }
                            return;
                        }
                        this.mConstructing.push(new ArrayList());
                        this.mEncountered.push(EncounteredState.METHOD);
                        this.mExpecting = ExpectingState.OBJECT;
                        break;
                    }
                    case CLOSE_OBJECT_WITH_REFID: {
                        throw InspectorException.newException("<" + string3 + "> not expected here. Elements with a 'refId' must have an empty body");
                    }
                }
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new SAXException(exception);
            }
        }

        public void startRecording() {
            this.mBuilderValue = new StringBuilder();
        }

        @Override
        public void characters(char[] cArray, int n, int n2) {
            if (this.mBuilderValue == null) {
                return;
            }
            this.mBuilderValue.append(cArray, n, n2);
        }

        public String endRecording() {
            String string = this.mBuilderValue.toString();
            this.mBuilderValue = null;
            return string;
        }

        @Override
        public void endElement(String string, String string2, String string3) throws SAXException {
            --this.mDepth;
            if (this.mIgnoreTypeAfterDepth != -1) {
                if (this.mDepth >= this.mIgnoreTypeAfterDepth) {
                    return;
                }
                this.mIgnoreTypeAfterDepth = -1;
                if (this.mCachingContentHandler != null) {
                    this.mCachingContentHandler.unpause(false);
                }
            }
            if (this.mIgnoreNameAfterDepth != -1) {
                if (this.mDepth >= this.mIgnoreNameAfterDepth) {
                    return;
                }
                this.mIgnoreNameAfterDepth = -1;
                if (this.mCachingContentHandler != null) {
                    this.mCachingContentHandler.unpause(false);
                }
            }
            if (this.mDepth == 0) {
                return;
            }
            if (this.mConstructing.isEmpty()) {
                return;
            }
            try {
                EncounteredState encounteredState = this.mEncountered.pop();
                switch (encounteredState) {
                    case NATIVE_TYPE: {
                        Object object = this.mConstructing.pop();
                        Object object2 = this.mConstructing.peek();
                        if (object2 instanceof ConfigAndId) {
                            object2 = ((ConfigAndId)this.mConstructing.peek()).getConfig();
                        }
                        this.mConstructing.push(object);
                        this.addToConstructing(BaseConfigReader.this.createNative(string2, object2.getClass(), this.endRecording()));
                        this.mExpecting = ExpectingState.OBJECT;
                        return;
                    }
                    case NATIVE_COLLECTION_TYPE: {
                        Object object = this.mConstructing.pop();
                        Collection collection = (Collection)this.mConstructing.peek();
                        collection.add(object);
                        this.mExpecting = ExpectingState.OBJECT;
                        return;
                    }
                    case CONFIGURED_TYPE: 
                    case JAVA_OBJECT: {
                        Object object = this.mConstructing.pop();
                        if (encounteredState == EncounteredState.CONFIGURED_TYPE) {
                            Class<?> clazz = BaseConfigReader.this.lookupClass(string, string2, this.mToConfigure.getClass().getClassLoader());
                            String string4 = ((ConfigAndId)object).getId();
                            object = ((ConfigAndId)object).getConfig();
                            Object object3 = null;
                            if (BaseConfigReader.this.isImmutable(clazz)) {
                                object3 = this.getImmutableByClass(clazz, object);
                            }
                            if (object3 == null) {
                                Object object4;
                                try {
                                    object4 = clazz.getConstructor(object.getClass());
                                    object3 = ((Constructor)object4).newInstance(object);
                                }
                                catch (NoSuchMethodException noSuchMethodException) {
                                    String string5 = this.getLikelyConfig(clazz);
                                    if ("".equals(string5)) {
                                        throw MetawidgetException.newException(clazz + " does not have a constructor that takes a " + object.getClass() + ", as specified by your config attribute. It only has a config-less constructor");
                                    }
                                    if (string5 != null) {
                                        throw MetawidgetException.newException(clazz + " does not have a constructor that takes a " + object.getClass() + ", as specified by your config attribute. Did you mean config=\"" + string5 + "\"?");
                                    }
                                    throw MetawidgetException.newException(clazz + " does not have a constructor that takes a " + object.getClass() + ", as specified by your config attribute");
                                }
                                if (BaseConfigReader.this.isImmutable(clazz)) {
                                    LOG.debug("\tInstantiated immutable {0} (config hashCode {1})", clazz, object.hashCode());
                                    object4 = (Immutable)object3;
                                    this.putImmutableByClass((Immutable)object4, object);
                                    if (string4 != null) {
                                        this.putImmutableById(string4, (Immutable)object4);
                                    }
                                }
                            } else if (BaseConfigReader.this.isImmutable(clazz) && this.mCachingContentHandler != null && this.mDepth < this.mIgnoreImmutableAfterDepth) {
                                this.mCachingContentHandler.unpause(true);
                                this.mIgnoreImmutableAfterDepth = -1;
                                this.putImmutableByLocation((Immutable)object3);
                            }
                            object = object3;
                        }
                        if (this.mDepth == 1) {
                            this.mConstructing.push(object);
                            this.mExpecting = ExpectingState.TO_CONFIGURE;
                            return;
                        }
                        this.addToConstructing(object);
                        this.mExpecting = ExpectingState.OBJECT;
                        return;
                    }
                    case METHOD: {
                        List list = (List)this.mConstructing.pop();
                        Object object = this.mConstructing.peek();
                        if (object instanceof ConfigAndId) {
                            object = ((ConfigAndId)object).getConfig();
                        }
                        Class<?> clazz = object.getClass();
                        String string6 = "set" + StringUtils.capitalize(string2);
                        try {
                            Method method = this.classGetMethod(clazz, string6, list);
                            method.invoke(object, list.toArray());
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            for (Constructor<?> constructor : clazz.getConstructors()) {
                                String string7;
                                Class<?>[] classArray = constructor.getParameterTypes();
                                if (classArray.length != 1 || !(string7 = classArray[0].getClass().getSimpleName()).endsWith("Config")) continue;
                                throw MetawidgetException.newException("No such method " + string6 + " on " + clazz + ". Did you forget config=\"" + string7 + "\"?");
                            }
                            throw noSuchMethodException;
                        }
                        this.mExpecting = ExpectingState.METHOD;
                        return;
                    }
                    case WRONG_TYPE: {
                        return;
                    }
                    case WRONG_NAME: {
                        return;
                    }
                }
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                Exception exception2;
                if (exception instanceof InvocationTargetException) {
                    Throwable throwable = ((InvocationTargetException)exception).getTargetException();
                    if (!(throwable instanceof Exception)) {
                        throw new RuntimeException(throwable);
                    }
                    exception2 = (Exception)throwable;
                }
                throw new SAXException(exception2);
            }
        }

        @Override
        public void warning(SAXParseException sAXParseException) {
            LOG.warn(sAXParseException.getMessage(), new Object[0]);
        }

        @Override
        public void error(SAXParseException sAXParseException) {
            throw MetawidgetException.newException(sAXParseException);
        }

        private ExpectingState handleNonNativeObject(String string, String string2, Attributes attributes) throws Exception {
            String string3 = attributes.getValue("refId");
            String string4 = attributes.getValue("config");
            if (string3 != null) {
                if (string4 != null) {
                    throw InspectorException.newException("Elements with 'refId' attributes (refId=\"" + string3 + "\") cannot also have 'config' attributes (config=\"" + string4 + "\")");
                }
                Object object = this.getImmutableByRefId(string3);
                Class<?> clazz = object.getClass();
                if (!StringUtils.decapitalize(clazz.getSimpleName()).equals(string2)) {
                    throw InspectorException.newException("refId=\"" + string3 + "\" points to an object of " + clazz + ", not a <" + string2 + ">");
                }
                this.mConstructing.push(object);
                this.mEncountered.push(EncounteredState.JAVA_OBJECT);
                return ExpectingState.CLOSE_OBJECT_WITH_REFID;
            }
            Object object = null;
            Class<?> clazz = BaseConfigReader.this.lookupClass(string, string2, this.mToConfigure.getClass().getClassLoader());
            if (BaseConfigReader.this.isImmutable(clazz)) {
                object = this.getImmutableByLocation();
            }
            if (object == null && string4 != null) {
                String string5 = string4.indexOf(46) == -1 ? clazz.getPackage().getName() + '.' + string4 : string4;
                Class<?> clazz2 = BaseConfigReader.this.lookupClass(string5, this.mToConfigure.getClass().getClassLoader());
                if (clazz2 == null) {
                    throw MetawidgetException.newException("No such configuration class " + string5);
                }
                Object obj = clazz2.newInstance();
                if (obj instanceof NeedsResourceResolver) {
                    ((NeedsResourceResolver)obj).setResourceResolver(BaseConfigReader.this.getResourceResolver());
                }
                this.mConstructing.push(new ConfigAndId(obj, attributes.getValue("id")));
                this.mEncountered.push(EncounteredState.CONFIGURED_TYPE);
                if (this.mIgnoreImmutableAfterDepth == -1 && this.mCachingContentHandler != null && BaseConfigReader.this.isImmutable(clazz)) {
                    this.mCachingContentHandler.pause(true);
                    this.mIgnoreImmutableAfterDepth = this.mDepth;
                }
                return ExpectingState.METHOD;
            }
            if (object == null && BaseConfigReader.this.isImmutable(clazz)) {
                object = this.getImmutableByClass(clazz, BaseConfigReader.IMMUTABLE_NO_CONFIG);
            }
            if (object == null) {
                Object object2;
                try {
                    object2 = clazz.getConstructor(new Class[0]);
                    object = ((Constructor)object2).newInstance(new Object[0]);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    String string6 = this.getLikelyConfig(clazz);
                    if (string6 != null) {
                        throw MetawidgetException.newException(clazz + " does not have a default constructor. Did you mean config=\"" + string6 + "\"?");
                    }
                    throw MetawidgetException.newException(clazz + " does not have a default constructor");
                }
                if (BaseConfigReader.this.isImmutable(clazz)) {
                    LOG.debug("\tInstantiated immutable {0} (no config)", clazz);
                    object2 = (Immutable)object;
                    this.putImmutableByClass((Immutable)object2, null);
                    String string7 = attributes.getValue("id");
                    if (string7 != null) {
                        this.putImmutableById(string7, (Immutable)object2);
                    }
                }
            }
            this.mConstructing.push(object);
            this.mEncountered.push(EncounteredState.JAVA_OBJECT);
            return ExpectingState.METHOD;
        }

        private void addToConstructing(Object object) {
            Object object2 = this.mConstructing.peek();
            if (object2 instanceof Collection) {
                Collection collection = (Collection)object2;
                collection.add(object);
                return;
            }
            if (object2.getClass().isArray()) {
                Object[] objectArray = (Object[])this.mConstructing.pop();
                Object[] objectArray2 = new Object[objectArray.length + 1];
                System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
                objectArray2[objectArray.length] = object;
                this.mConstructing.push(objectArray2);
                return;
            }
            throw MetawidgetException.newException("Don't know how to add to a " + object2.getClass());
        }

        private Object getImmutableByLocation() {
            if (this.mImmutableForThisLocationCache == null) {
                return null;
            }
            return this.mImmutableForThisLocationCache.get(this.mLocationIndex);
        }

        private void putImmutableByLocation(Immutable immutable) {
            if (this.mImmutableForThisLocationCache == null) {
                return;
            }
            if (this.mImmutableForThisLocationCache.containsKey(this.mLocationIndex)) {
                throw InspectorException.newException("Location " + this.mLocationIndex + " already cached");
            }
            this.mImmutableForThisLocationCache.put(this.mLocationIndex, immutable);
        }

        private Object getImmutableByRefId(String string) {
            if (!BaseConfigReader.this.mImmutableByIdCache.containsKey(string)) {
                throw InspectorException.newException("Attribute refId=\"" + string + "\" refers to non-existent id");
            }
            return BaseConfigReader.this.mImmutableByIdCache.get(string);
        }

        private void putImmutableById(String string, Immutable immutable) {
            if (BaseConfigReader.this.mImmutableByIdCache.containsKey(string)) {
                throw InspectorException.newException("Attribute id=\"" + string + "\" appears more than once");
            }
            BaseConfigReader.this.mImmutableByIdCache.put(string, immutable);
        }

        private Object getImmutableByClass(Class<?> clazz, Object object) {
            Map<Object, Immutable> map = BaseConfigReader.this.mImmutableByClassCache.get(clazz);
            if (map == null) {
                return null;
            }
            Object object2 = object;
            if (object2 == null) {
                object2 = BaseConfigReader.IMMUTABLE_NO_CONFIG;
            }
            return map.get(object2);
        }

        private void putImmutableByClass(Immutable immutable, Object object) {
            Object object2;
            Map<Object, Immutable> map;
            Class<?> clazz;
            block16: {
                clazz = immutable.getClass();
                map = BaseConfigReader.this.mImmutableByClassCache.get(clazz);
                if (map == null) {
                    map = CollectionUtils.newHashMap();
                    BaseConfigReader.this.mImmutableByClassCache.put(clazz, map);
                }
                if ((object2 = object) == null) {
                    object2 = BaseConfigReader.IMMUTABLE_NO_CONFIG;
                } else {
                    try {
                        Method[] methodArray = object2.getClass();
                        Class<?> clazz2 = methodArray.getMethod("equals", Object.class).getDeclaringClass();
                        if (Object.class.equals(clazz2)) {
                            throw MetawidgetException.newException(methodArray + " does not override .equals(), so cannot cache reliably");
                        }
                        Class<?> clazz3 = methodArray.getMethod("hashCode", new Class[0]).getDeclaringClass();
                        if (Object.class.equals(clazz3)) {
                            throw MetawidgetException.newException(methodArray + " does not override .hashCode(), so cannot cache reliably");
                        }
                        if (System.identityHashCode(object2) == object2.hashCode()) {
                            LOG.warn("{0} overrides .hashCode(), but it returns the same as System.identityHashCode, so cannot be cached reliably", new Object[]{methodArray});
                        }
                        if (!clazz2.equals(clazz3)) {
                            throw MetawidgetException.newException(clazz2 + " implements .equals(), but .hashCode() is implemented by " + clazz3 + ", so cannot cache reliably");
                        }
                        if (methodArray.equals(clazz2)) break block16;
                        for (Method method : methodArray.getMethods()) {
                            if (!methodArray.equals(method.getDeclaringClass())) continue;
                            for (Method method2 : clazz2.getMethods()) {
                                if (!method2.getName().equals(method.getName())) {
                                    continue;
                                }
                                break block16;
                            }
                            LOG.warn("{0} does not override .equals() (only its super{1} does), so may not be cached reliably", methodArray, clazz2);
                            break;
                        }
                    }
                    catch (Exception exception) {
                        throw MetawidgetException.newException(exception);
                    }
                }
            }
            if (map.containsKey(object2)) {
                throw InspectorException.newException("Config '" + object2 + "' already cached");
            }
            for (Method method : clazz.getMethods()) {
                if (!method.getName().startsWith("set") || method.getParameterTypes().length <= 0) continue;
                LOG.warn("{0} must be immutable, but appears to have a setter method ({1})", clazz, method);
                break;
            }
            map.put(object2, immutable);
            if (this.mCachingContentHandler != null && this.mDepth < this.mIgnoreImmutableAfterDepth) {
                this.mCachingContentHandler.unpause(true);
                this.mIgnoreImmutableAfterDepth = -1;
                if (object != null) {
                    this.putImmutableByLocation(immutable);
                }
            }
        }

        private Method classGetMethod(Class<?> clazz, String string, List<Object> list) throws NoSuchMethodException {
            int n = list.size();
            Method method = null;
            block0: for (Method method2 : clazz.getMethods()) {
                if (!method2.getName().equals(string)) continue;
                method = method2;
                Class<?>[] classArray = method2.getParameterTypes();
                if (classArray.length != n) continue;
                ArrayList<Object> arrayList = CollectionUtils.newArrayList(list);
                for (int i = 0; i < n; ++i) {
                    Object e = arrayList.get(i);
                    Class<?> clazz2 = classArray[i];
                    if (clazz2.isPrimitive()) {
                        clazz2 = ClassUtils.getWrapperClass(clazz2);
                    } else if (e == null) continue;
                    if (clazz2.isInstance(e)) continue;
                    Object object = BaseConfigReader.this.createLazyResolvingNative(e, clazz2);
                    if (object == null) continue block0;
                    arrayList.remove(i);
                    arrayList.add(i, object);
                }
                list.clear();
                list.addAll(arrayList);
                return method2;
            }
            if (method != null) {
                throw new NoSuchMethodException(this.methodToString(clazz, string, list) + ". Did you mean " + this.methodToString(method) + "?");
            }
            throw new NoSuchMethodException(this.methodToString(clazz, string, list));
        }

        private String getLikelyConfig(Class<?> clazz) {
            Constructor<?>[] constructorArray = clazz.getConstructors();
            if (constructorArray.length != 1) {
                return null;
            }
            if (constructorArray[0].getParameterTypes().length == 0) {
                return "";
            }
            if (constructorArray[0].getParameterTypes().length > 1) {
                return null;
            }
            Class<?> clazz2 = constructorArray[0].getParameterTypes()[0];
            if (clazz2.getPackage().equals(clazz.getPackage())) {
                return clazz2.getSimpleName();
            }
            return clazz2.getName();
        }

        private String methodToString(Method method) {
            StringBuilder stringBuilder = new StringBuilder();
            for (Class<?> clazz : method.getParameterTypes()) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(", ");
                }
                if (clazz.isArray()) {
                    stringBuilder.append(clazz.getComponentType().getSimpleName());
                    stringBuilder.append("[]");
                    continue;
                }
                stringBuilder.append(clazz.getSimpleName());
            }
            stringBuilder.insert(0, "(");
            stringBuilder.insert(0, method.getName());
            stringBuilder.append(")");
            return stringBuilder.toString();
        }

        private String methodToString(Class<?> clazz, String string, List<Object> list) {
            StringBuilder stringBuilder = new StringBuilder();
            for (Object object : list) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(", ");
                }
                if (object == null) {
                    stringBuilder.append("null");
                    continue;
                }
                stringBuilder.append(object.getClass().getSimpleName());
            }
            stringBuilder.insert(0, "(");
            stringBuilder.insert(0, string);
            stringBuilder.insert(0, '.');
            stringBuilder.insert(0, clazz);
            stringBuilder.append(")");
            return stringBuilder.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ExpectingState {
        ROOT,
        TO_CONFIGURE,
        OBJECT,
        METHOD,
        CLOSE_OBJECT_WITH_REFID;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum EncounteredState {
        METHOD,
        NATIVE_TYPE,
        NATIVE_COLLECTION_TYPE,
        CONFIGURED_TYPE,
        JAVA_OBJECT,
        WRONG_TYPE,
        WRONG_NAME;

    }
}

