/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.faces;

import java.io.IOException;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FacesUtils {
    private static final Pattern PATTERN_EXPRESSION;
    private static final String EXPRESSION_START = "#{";
    private static final String EXPRESSION_END = "}";
    private static final String UNIQUE_ID_VIEW_ATTRIBUTE;
    private static final boolean IS_JSF_2;

    public static boolean isExpression(String string) {
        return FacesUtils.matchExpression(string).matches();
    }

    public static Matcher matchExpression(String string) {
        return PATTERN_EXPRESSION.matcher(string);
    }

    public static String unwrapExpression(String string) {
        Matcher matcher = PATTERN_EXPRESSION.matcher(string);
        if (!matcher.matches()) {
            return string;
        }
        return matcher.group(2);
    }

    public static String wrapExpression(String string) {
        if (FacesUtils.isExpression(string)) {
            return string;
        }
        return EXPRESSION_START + FacesUtils.unwrapExpression(string) + EXPRESSION_END;
    }

    public static void render(FacesContext facesContext, UIComponent uIComponent) throws IOException {
        if (uIComponent == null || !uIComponent.isRendered()) {
            return;
        }
        uIComponent.encodeBegin(facesContext);
        if (uIComponent.getRendersChildren()) {
            uIComponent.encodeChildren(facesContext);
        } else {
            FacesUtils.renderChildren(facesContext, uIComponent);
        }
        uIComponent.encodeEnd(facesContext);
    }

    public static boolean isJsf2() {
        return IS_JSF_2;
    }

    public static boolean isValidationFailed() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (FacesUtils.isJsf2()) {
            return FacesContext.getCurrentInstance().isValidationFailed();
        }
        return facesContext.getMaximumSeverity() != null;
    }

    public static boolean isPartialStateSavingDisabled() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        return "false".equals(facesContext.getExternalContext().getInitParameter("javax.faces.PARTIAL_STATE_SAVING"));
    }

    public static <T extends UIComponent> T createComponent(String string, String string2) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Application application = facesContext.getApplication();
        if (FacesUtils.isJsf2()) {
            return (T)application.createComponent(facesContext, string, string2);
        }
        return (T)application.createComponent(string);
    }

    public static void setStyleAndStyleClass(UIComponent uIComponent, String string, String string2) {
        String string3;
        Map map = uIComponent.getAttributes();
        if (string != null) {
            string3 = (String)map.get("style");
            if (string3 == null || "".equals(string3)) {
                map.put("style", string);
            } else if (!string3.contains(string)) {
                map.put("style", string3 + " " + string);
            }
        }
        if (string2 != null) {
            string3 = (String)map.get("styleClass");
            if (string3 == null || "".equals(string3)) {
                map.put("styleClass", string2);
            } else if (!string3.contains(string2)) {
                map.put("styleClass", string3 + " " + string2);
            }
        }
    }

    public static String createUniqueId() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Map map = facesContext.getViewRoot().getAttributes();
        Integer n = (Integer)map.get(UNIQUE_ID_VIEW_ATTRIBUTE);
        if (n == null) {
            n = 0;
        }
        map.put(UNIQUE_ID_VIEW_ATTRIBUTE, n + 1);
        return "j_idmw" + n;
    }

    private static void renderChildren(FacesContext facesContext, UIComponent uIComponent) throws IOException {
        for (UIComponent uIComponent2 : uIComponent.getChildren()) {
            FacesUtils.render(facesContext, uIComponent2);
        }
    }

    private FacesUtils() {
    }

    static {
        boolean bl;
        PATTERN_EXPRESSION = Pattern.compile("(#|\\$)\\{([^\\}]+)\\}");
        UNIQUE_ID_VIEW_ATTRIBUTE = FacesUtils.class.getName() + ".UNIQUE_ID";
        try {
            Class.forName("javax.faces.event.PreRenderViewEvent");
            bl = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            bl = false;
        }
        IS_JSF_2 = bl;
    }
}

