/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.faces.component.html.widgetbuilder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.faces.application.Application;
import javax.faces.component.UIColumn;
import javax.faces.component.UICommand;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.component.UISelectItem;
import javax.faces.component.UISelectItems;
import javax.faces.component.UISelectMany;
import javax.faces.component.ValueHolder;
import javax.faces.component.html.HtmlCommandLink;
import javax.faces.component.html.HtmlDataTable;
import javax.faces.component.html.HtmlInputSecret;
import javax.faces.component.html.HtmlInputText;
import javax.faces.component.html.HtmlInputTextarea;
import javax.faces.component.html.HtmlOutputText;
import javax.faces.component.html.HtmlSelectManyCheckbox;
import javax.faces.component.html.HtmlSelectOneMenu;
import javax.faces.component.html.HtmlSelectOneRadio;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.el.MethodBinding;
import javax.faces.model.DataModel;
import javax.faces.model.SelectItem;
import org.metawidget.faces.FacesUtils;
import org.metawidget.faces.component.UIMetawidget;
import org.metawidget.faces.component.html.HtmlMetawidget;
import org.metawidget.faces.component.html.widgetbuilder.HtmlWidgetBuilderConfig;
import org.metawidget.faces.component.widgetprocessor.ConverterProcessor;
import org.metawidget.faces.component.widgetprocessor.StandardBindingProcessor;
import org.metawidget.util.ArrayUtils;
import org.metawidget.util.CollectionUtils;
import org.metawidget.util.WidgetBuilderUtils;
import org.metawidget.util.XmlUtils;
import org.metawidget.util.simple.StringUtils;
import org.metawidget.widgetbuilder.iface.WidgetBuilder;
import org.metawidget.widgetbuilder.iface.WidgetBuilderException;
import org.metawidget.widgetprocessor.iface.WidgetProcessor;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlWidgetBuilder
implements WidgetBuilder<UIComponent, UIMetawidget> {
    private static final String DATATABLE_ROW_ACTION = "dataTableRowAction";
    private static final int SHORT_LOOKUP_SIZE = 3;
    private final String mDataTableStyleClass;
    private final String[] mDataTableColumnClasses;
    private final String[] mDataTableRowClasses;
    private final int mMaximumColumnsInDataTable;

    public HtmlWidgetBuilder() {
        this(new HtmlWidgetBuilderConfig());
    }

    public HtmlWidgetBuilder(HtmlWidgetBuilderConfig htmlWidgetBuilderConfig) {
        this.mDataTableStyleClass = htmlWidgetBuilderConfig.getDataTableStyleClass();
        this.mDataTableColumnClasses = htmlWidgetBuilderConfig.getDataTableColumnClasses();
        this.mDataTableRowClasses = htmlWidgetBuilderConfig.getDataTableRowClasses();
        this.mMaximumColumnsInDataTable = htmlWidgetBuilderConfig.getMaximumColumnsInDataTable();
    }

    @Override
    public UIComponent buildWidget(String string, Map<String, String> map, UIMetawidget uIMetawidget) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Application application = facesContext.getApplication();
        if ("true".equals(map.get("hidden"))) {
            return application.createComponent("org.metawidget.Stub");
        }
        UIComponent uIComponent = null;
        String string2 = map.get("faces-component");
        if (string2 != null) {
            uIComponent = application.createComponent(string2);
        }
        if ("action".equals(string)) {
            if (uIComponent == null) {
                uIComponent = application.createComponent("javax.faces.HtmlCommandButton");
            }
            ((UICommand)uIComponent).setValue((Object)uIMetawidget.getLabelString(map));
            return uIComponent;
        }
        Class<?> clazz = WidgetBuilderUtils.getActualClassOrType(map, String.class);
        String string3 = map.get("faces-lookup");
        if (string3 != null && !"".equals(string3)) {
            if (uIComponent == null) {
                uIComponent = clazz != null && (List.class.isAssignableFrom(clazz) || clazz.isArray()) ? application.createComponent("javax.faces.HtmlSelectManyCheckbox") : application.createComponent("javax.faces.HtmlSelectOneMenu");
            }
            this.initFacesSelect(uIComponent, string3, map, uIMetawidget);
            return uIComponent;
        }
        if (clazz != null) {
            if (uIComponent == null && Boolean.class.equals(clazz) && "true".equals(map.get("required"))) {
                return application.createComponent("javax.faces.HtmlSelectBooleanCheckbox");
            }
            String string4 = map.get("lookup");
            if (string4 != null && !"".equals(string4)) {
                if (uIComponent == null) {
                    uIComponent = List.class.isAssignableFrom(clazz) || clazz.isArray() ? application.createComponent("javax.faces.HtmlSelectManyCheckbox") : application.createComponent("javax.faces.HtmlSelectOneMenu");
                }
                this.initStaticSelect(uIComponent, string4, clazz, map, uIMetawidget);
            }
            if (uIComponent == null) {
                if (Boolean.TYPE.equals(clazz)) {
                    uIComponent = application.createComponent("javax.faces.HtmlSelectBooleanCheckbox");
                } else if (Character.TYPE.equals(clazz) || Character.class.isAssignableFrom(clazz)) {
                    uIComponent = application.createComponent("javax.faces.HtmlInputText");
                    ((HtmlInputText)uIComponent).setMaxlength(1);
                } else if (clazz.isPrimitive()) {
                    uIComponent = application.createComponent("javax.faces.HtmlInputText");
                } else if (Date.class.isAssignableFrom(clazz)) {
                    uIComponent = application.createComponent("javax.faces.HtmlInputText");
                } else if (Number.class.isAssignableFrom(clazz)) {
                    uIComponent = application.createComponent("javax.faces.HtmlInputText");
                } else if (String.class.equals(clazz)) {
                    if ("true".equals(map.get("masked"))) {
                        uIComponent = application.createComponent("javax.faces.HtmlInputSecret");
                    } else if ("true".equals(map.get("large"))) {
                        uIComponent = application.createComponent("javax.faces.HtmlInputTextarea");
                        ((HtmlInputTextarea)uIComponent).setCols(20);
                        ((HtmlInputTextarea)uIComponent).setRows(2);
                    } else {
                        uIComponent = application.createComponent("javax.faces.HtmlInputText");
                    }
                } else {
                    if (List.class.isAssignableFrom(clazz) || DataModel.class.isAssignableFrom(clazz) || clazz.isArray()) {
                        return this.createDataTableComponent(string, map, uIMetawidget);
                    }
                    if (Collection.class.isAssignableFrom(clazz)) {
                        return application.createComponent("org.metawidget.Stub");
                    }
                }
            }
            this.setMaximumLength(uIComponent, map);
            if (uIComponent != null) {
                return uIComponent;
            }
        }
        if ("true".equals(map.get("dont-expand"))) {
            return application.createComponent("javax.faces.HtmlInputText");
        }
        return null;
    }

    protected void initFacesSelect(UIComponent uIComponent, String string, Map<String, String> map, UIMetawidget uIMetawidget) {
        if (uIComponent instanceof HtmlSelectManyCheckbox) {
            ((HtmlSelectManyCheckbox)uIComponent).setLayout("pageDirection");
        } else if (uIComponent instanceof HtmlSelectOneRadio) {
            ((HtmlSelectOneRadio)uIComponent).setLayout("pageDirection");
        }
        this.addSelectItems(uIComponent, string, map, uIMetawidget);
    }

    protected void initStaticSelect(UIComponent uIComponent, String string, Class<?> clazz, Map<String, String> map, UIMetawidget uIMetawidget) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Application application = facesContext.getApplication();
        List<String> list = CollectionUtils.fromString(string);
        if (list.size() > 3) {
            if (uIComponent instanceof HtmlSelectManyCheckbox) {
                ((HtmlSelectManyCheckbox)uIComponent).setLayout("pageDirection");
            } else if (uIComponent instanceof HtmlSelectOneRadio) {
                ((HtmlSelectOneRadio)uIComponent).setLayout("pageDirection");
            }
        }
        List<String> list2 = list;
        if (uIComponent instanceof ValueHolder) {
            Converter converter = null;
            ConverterProcessor converterProcessor = uIMetawidget.getWidgetProcessor(ConverterProcessor.class);
            if (converterProcessor != null) {
                converter = converterProcessor.getConverter((ValueHolder)uIComponent, map);
            }
            if (converter == null && !(uIComponent instanceof UISelectMany)) {
                converter = application.createConverter(clazz);
            }
            if (converter != null) {
                int n = list2.size();
                ArrayList arrayList = CollectionUtils.newArrayList(n);
                for (int i = 0; i < n; ++i) {
                    Object object = converter.getAsObject(facesContext, uIComponent, list.get(i));
                    arrayList.add(object);
                }
                list2 = arrayList;
            }
        }
        this.addSelectItems(uIComponent, list2, CollectionUtils.fromString(map.get("lookup-labels")), map, uIMetawidget);
    }

    protected void setMaximumLength(UIComponent uIComponent, Map<String, String> map) {
        String string = map.get("maximum-length");
        if (string != null && !"".equals(string)) {
            if (uIComponent instanceof HtmlInputText) {
                ((HtmlInputText)uIComponent).setMaxlength(Integer.parseInt(string));
            } else if (uIComponent instanceof HtmlInputSecret) {
                ((HtmlInputSecret)uIComponent).setMaxlength(Integer.parseInt(string));
            }
        }
    }

    protected UIComponent createDataTableComponent(String string, Map<String, String> map, UIMetawidget uIMetawidget) {
        Object object;
        NodeList nodeList;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Application application = facesContext.getApplication();
        HtmlDataTable htmlDataTable = (HtmlDataTable)application.createComponent("javax.faces.HtmlDataTable");
        htmlDataTable.setVar("_item");
        htmlDataTable.setStyleClass(this.mDataTableStyleClass);
        htmlDataTable.setColumnClasses(ArrayUtils.toString(this.mDataTableColumnClasses));
        htmlDataTable.setRowClasses(ArrayUtils.toString(this.mDataTableRowClasses));
        String string2 = WidgetBuilderUtils.getComponentType(map);
        String string3 = null;
        if (string2 != null) {
            string3 = uIMetawidget.inspect(null, string2, new String[0]);
        }
        if (string3 == null) {
            nodeList = null;
        } else {
            object = XmlUtils.documentFromString(string3).getDocumentElement();
            nodeList = object.getFirstChild().getChildNodes();
        }
        if (nodeList == null || nodeList.getLength() == 0) {
            object = CollectionUtils.newHashMap();
            object.put("name", map.get("name"));
            this.addColumnComponent((UIData)htmlDataTable, map, "entity", (Map<String, String>)object, uIMetawidget);
        } else {
            this.addColumnComponents((UIData)htmlDataTable, map, nodeList, uIMetawidget);
        }
        object = uIMetawidget.getParameter(DATATABLE_ROW_ACTION);
        if (object != null) {
            HtmlCommandLink htmlCommandLink = (HtmlCommandLink)application.createComponent("javax.faces.HtmlCommandLink");
            htmlCommandLink.setId(FacesUtils.createUniqueId());
            if (FacesUtils.isExpression((String)object)) {
                throw WidgetBuilderException.newException("dataTableRowAction must be an unwrapped JSF expression (eg. foo.bar, not #{foo.bar})");
            }
            String string4 = StringUtils.substringAfterLast((String)object, ".");
            String string5 = uIMetawidget.getLocalizedKey(string4);
            if (string5 == null) {
                htmlCommandLink.setValue((Object)StringUtils.uncamelCase(string4));
            } else {
                htmlCommandLink.setValue((Object)string5);
            }
            MethodBinding methodBinding = application.createMethodBinding(FacesUtils.wrapExpression((String)object), null);
            htmlCommandLink.setAction(methodBinding);
            UIColumn uIColumn = (UIColumn)application.createComponent("javax.faces.HtmlColumn");
            uIColumn.setId(FacesUtils.createUniqueId());
            uIColumn.getChildren().add(htmlCommandLink);
            htmlDataTable.getChildren().add(uIColumn);
            HtmlOutputText htmlOutputText = (HtmlOutputText)application.createComponent("javax.faces.HtmlOutputText");
            htmlOutputText.setId(FacesUtils.createUniqueId());
            htmlOutputText.setValue((Object)"<div></div>");
            htmlOutputText.setEscape(false);
            uIColumn.setHeader((UIComponent)htmlOutputText);
        }
        return htmlDataTable;
    }

    protected void addColumnComponents(UIData uIData, Map<String, String> map, NodeList nodeList, UIMetawidget uIMetawidget) {
        boolean bl = true;
        while (true) {
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Element element;
                Node node = nodeList.item(i);
                if (!(node instanceof Element) || "action".equals((element = (Element)node).getNodeName()) || "true".equals(element.getAttribute("hidden")) || bl && !"true".equals(element.getAttribute("required"))) continue;
                this.addColumnComponent(uIData, map, "property", XmlUtils.getAttributesAsMap(element), uIMetawidget);
                if (uIData.getChildren().size() == this.mMaximumColumnsInDataTable) break;
            }
            if (!uIData.getChildren().isEmpty() || !bl) break;
            bl = false;
        }
    }

    protected void addColumnComponent(UIData uIData, Map<String, String> map, String string, Map<String, String> map2, UIMetawidget uIMetawidget) {
        WidgetProcessor widgetProcessor;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Application application = facesContext.getApplication();
        UIColumn uIColumn = (UIColumn)application.createComponent("javax.faces.HtmlColumn");
        uIColumn.setId(FacesUtils.createUniqueId());
        UIComponent uIComponent = application.createComponent("javax.faces.HtmlOutputText");
        uIComponent.setId(FacesUtils.createUniqueId());
        HtmlMetawidget htmlMetawidget = new HtmlMetawidget();
        htmlMetawidget.setValueBinding("value", application.createValueBinding(FacesUtils.wrapExpression(uIData.getVar())));
        WidgetProcessor widgetProcessor2 = uIMetawidget.getWidgetProcessor(StandardBindingProcessor.class);
        if (widgetProcessor2 != null) {
            widgetProcessor2.processWidget(uIComponent, string, map2, htmlMetawidget);
        }
        if ((widgetProcessor = (WidgetProcessor)((Object)uIMetawidget.getWidgetProcessor(ConverterProcessor.class))) != null) {
            widgetProcessor.processWidget(uIComponent, string, map2, htmlMetawidget);
        }
        uIColumn.getChildren().add(uIComponent);
        HtmlOutputText htmlOutputText = (HtmlOutputText)application.createComponent("javax.faces.HtmlOutputText");
        htmlOutputText.setId(FacesUtils.createUniqueId());
        htmlOutputText.setValue((Object)uIMetawidget.getLabelString(map2));
        uIColumn.setHeader((UIComponent)htmlOutputText);
        uIData.getChildren().add(uIColumn);
    }

    private void addSelectItems(UIComponent uIComponent, List<?> list, List<String> list2, Map<String, String> map, UIMetawidget uIMetawidget) {
        if (list == null) {
            return;
        }
        if (uIComponent instanceof HtmlSelectOneMenu && WidgetBuilderUtils.needsEmptyLookupItem(map)) {
            this.addSelectItem(uIComponent, null, null, uIMetawidget);
        }
        if (list2 != null && !list2.isEmpty() && list2.size() != list.size()) {
            throw WidgetBuilderException.newException("Labels list must be same size as values list");
        }
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Object obj = list.get(i);
            String string = null;
            if (list2 != null && !list2.isEmpty()) {
                string = list2.get(i);
            }
            this.addSelectItem(uIComponent, obj, string, uIMetawidget);
        }
    }

    private void addSelectItem(UIComponent uIComponent, Object object, String string, UIMetawidget uIMetawidget) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Application application = facesContext.getApplication();
        UISelectItem uISelectItem = (UISelectItem)application.createComponent("javax.faces.SelectItem");
        uISelectItem.setId(FacesUtils.createUniqueId());
        if (object == null) {
            try {
                UISelectItem.class.getMethod("getValueExpression", String.class);
                uISelectItem.setValue((Object)new SelectItem(null, ""));
            }
            catch (NoSuchMethodException noSuchMethodException) {
                uISelectItem.setItemValue((Object)"");
            }
        } else {
            uISelectItem.setItemValue(object);
        }
        if (string == null) {
            uISelectItem.setItemLabel(StringUtils.quietValueOf(object));
        } else if (FacesUtils.isExpression(string)) {
            uISelectItem.setValueBinding("itemLabel", application.createValueBinding(string));
        } else {
            String string2 = uIMetawidget.getLocalizedKey(StringUtils.camelCase(string));
            if (string2 != null) {
                uISelectItem.setItemLabel(string2);
            } else {
                uISelectItem.setItemLabel(string);
            }
        }
        uIComponent.getChildren().add(uISelectItem);
    }

    private void addSelectItems(UIComponent uIComponent, String string, Map<String, String> map, UIMetawidget uIMetawidget) {
        String string2;
        String string3;
        if (string == null) {
            return;
        }
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Application application = facesContext.getApplication();
        if (uIComponent instanceof HtmlSelectOneMenu && WidgetBuilderUtils.needsEmptyLookupItem(map)) {
            this.addSelectItem(uIComponent, null, null, uIMetawidget);
        }
        UISelectItems uISelectItems = (UISelectItems)application.createComponent("javax.faces.SelectItems");
        uISelectItems.setId(FacesUtils.createUniqueId());
        uIComponent.getChildren().add(uISelectItems);
        if (!FacesUtils.isExpression(string)) {
            throw WidgetBuilderException.newException("Lookup '" + string + "' is not of the form #{...}");
        }
        uISelectItems.setValueBinding("value", application.createValueBinding(string));
        String string4 = map.get("faces-lookup-var");
        if (string4 != null) {
            uISelectItems.getAttributes().put("var", string4);
        }
        if ((string3 = map.get("faces-lookup-item-label")) != null) {
            uISelectItems.setValueBinding("itemLabel", application.createValueBinding(string3));
        }
        if ((string2 = map.get("faces-lookup-item-value")) != null) {
            uISelectItems.setValueBinding("itemValue", application.createValueBinding(string2));
        }
    }
}

