/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.faces.component.widgetprocessor;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.component.ActionSource;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.el.MethodBinding;
import javax.faces.el.ValueBinding;
import org.metawidget.faces.FacesUtils;
import org.metawidget.faces.component.UIMetawidget;
import org.metawidget.faces.component.UIStub;
import org.metawidget.util.CollectionUtils;
import org.metawidget.util.simple.StringUtils;
import org.metawidget.widgetprocessor.iface.AdvancedWidgetProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReadableIdProcessor
implements AdvancedWidgetProcessor<UIComponent, UIMetawidget> {
    @Override
    public void onStartBuild(UIMetawidget uIMetawidget) {
        uIMetawidget.putClientProperty(ReadableIdProcessor.class, null);
    }

    @Override
    public UIComponent processWidget(UIComponent uIComponent, String string, Map<String, String> map, UIMetawidget uIMetawidget) {
        if (uIComponent.getId() != null) {
            return uIComponent;
        }
        if ("action".equals(string)) {
            MethodBinding methodBinding = ((ActionSource)uIComponent).getAction();
            if (methodBinding != null) {
                this.setUniqueId(uIComponent, methodBinding.getExpressionString(), uIMetawidget);
            } else {
                uIComponent.setId(FacesUtils.createUniqueId());
            }
        } else {
            ValueBinding valueBinding = uIComponent.getValueBinding("value");
            if (valueBinding != null) {
                this.setUniqueId(uIComponent, valueBinding.getExpressionString(), uIMetawidget);
            } else {
                uIComponent.setId(FacesUtils.createUniqueId());
            }
        }
        return uIComponent;
    }

    @Override
    public void onEndBuild(UIMetawidget uIMetawidget) {
    }

    protected void setUniqueId(UIComponent uIComponent, String string, UIMetawidget uIMetawidget) {
        String string2 = StringUtils.camelCase(FacesUtils.unwrapExpression(string), '.');
        this.setUniqueId(string2, uIComponent, uIMetawidget);
    }

    protected void setUniqueId(String string, UIComponent uIComponent, UIMetawidget uIMetawidget) {
        String string2 = string;
        if (uIComponent instanceof UIMetawidget) {
            string2 = string2 + "_Metawidget";
        }
        Set<String> set = this.getClientIds(uIMetawidget);
        String string3 = string2;
        int n = 1;
        while (!set.add(string3)) {
            string3 = string2 + '_' + ++n;
        }
        if (uIComponent instanceof UIStub) {
            List list = uIComponent.getChildren();
            if (!list.isEmpty()) {
                int n2 = 1;
                for (UIComponent uIComponent2 : list) {
                    if (uIComponent2.getId() != null) continue;
                    if (n2 > 1) {
                        uIComponent2.setId(string3 + '_' + n2);
                    } else {
                        uIComponent2.setId(string3);
                    }
                    ++n2;
                }
            }
            uIComponent.setId(FacesUtils.createUniqueId());
            return;
        }
        uIComponent.setId(string3);
    }

    private Set<String> getClientIds(UIMetawidget uIMetawidget) {
        HashSet<String> hashSet = (HashSet<String>)uIMetawidget.getClientProperty(ReadableIdProcessor.class);
        if (hashSet == null) {
            hashSet = CollectionUtils.newHashSet();
            uIMetawidget.putClientProperty(ReadableIdProcessor.class, hashSet);
            this.getClientIds((UIComponent)FacesContext.getCurrentInstance().getViewRoot(), hashSet);
        }
        return hashSet;
    }

    private void getClientIds(UIComponent uIComponent, Set<String> set) {
        Iterator iterator = uIComponent.getFacetsAndChildren();
        while (iterator.hasNext()) {
            UIComponent uIComponent2 = (UIComponent)iterator.next();
            String string = uIComponent2.getId();
            if (string != null) {
                set.add(string);
            }
            this.getClientIds(uIComponent2, set);
        }
    }
}

