/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.faces.component.widgetprocessor;

import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.faces.component.UIComponent;
import javax.faces.component.UISelectMany;
import javax.faces.component.UISelectOne;
import javax.faces.component.ValueHolder;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.DateTimeConverter;
import javax.faces.convert.NumberConverter;
import javax.faces.el.ValueBinding;
import org.metawidget.faces.FacesUtils;
import org.metawidget.faces.component.UIMetawidget;
import org.metawidget.faces.component.UIStub;
import org.metawidget.faces.component.widgetprocessor.ConverterProcessor;
import org.metawidget.util.ClassUtils;
import org.metawidget.util.WidgetBuilderUtils;
import org.metawidget.widgetprocessor.iface.WidgetProcessor;
import org.metawidget.widgetprocessor.iface.WidgetProcessorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandardConverterProcessor
implements WidgetProcessor<UIComponent, UIMetawidget>,
ConverterProcessor {
    @Override
    public UIComponent processWidget(UIComponent uIComponent, String string, Map<String, String> map, UIMetawidget uIMetawidget) {
        if ("action".equals(string)) {
            return uIComponent;
        }
        if (uIComponent instanceof UIStub) {
            ValueBinding valueBinding = uIComponent.getValueBinding("value");
            if (valueBinding != null) {
                String string2 = valueBinding.getExpressionString();
                List list = uIComponent.getChildren();
                for (UIComponent uIComponent2 : list) {
                    ValueBinding valueBinding2 = uIComponent2.getValueBinding("value");
                    if (valueBinding2 == null || !string2.equals(valueBinding2.getExpressionString())) continue;
                    this.processWidget(uIComponent2, string, map, uIMetawidget);
                }
            }
            return uIComponent;
        }
        if (!(uIComponent instanceof ValueHolder)) {
            return uIComponent;
        }
        ValueHolder valueHolder = (ValueHolder)uIComponent;
        String string3 = map.get("faces-converter");
        if (string3 != null && FacesUtils.isExpression(string3)) {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            uIComponent.setValueBinding("converter", facesContext.getApplication().createValueBinding(string3));
            return uIComponent;
        }
        valueHolder.setConverter(this.getConverter(valueHolder, map));
        return uIComponent;
    }

    @Override
    public Converter getConverter(ValueHolder valueHolder, Map<String, String> map) {
        Converter converter = valueHolder.getConverter();
        if (converter != null) {
            return converter;
        }
        FacesContext facesContext = FacesContext.getCurrentInstance();
        String string = map.get("faces-converter");
        if (string != null) {
            converter = facesContext.getApplication().createConverter(string);
        } else if (valueHolder instanceof UISelectOne || valueHolder instanceof UISelectMany) {
            Class<?> clazz;
            String string2 = WidgetBuilderUtils.getComponentType(map);
            if (string2 != null && (clazz = ClassUtils.niceForName(string2)) != null) {
                converter = facesContext.getApplication().createConverter(clazz);
            }
        } else {
            Class<Date> clazz;
            String string3 = map.get("type");
            if (string3 != null && (clazz = ClassUtils.niceForName(string3)) != null && clazz.isAssignableFrom(Date.class)) {
                converter = this.getDateTimeConverter(converter);
            }
        }
        if (map.containsKey("date-style")) {
            converter = this.getDateTimeConverter(converter);
            ((DateTimeConverter)converter).setDateStyle(map.get("date-style"));
        }
        if (map.containsKey("datetime-pattern")) {
            converter = this.getDateTimeConverter(converter);
            ((DateTimeConverter)converter).setPattern(map.get("datetime-pattern"));
        }
        if (map.containsKey("time-style")) {
            converter = this.getDateTimeConverter(converter);
            ((DateTimeConverter)converter).setTimeStyle(map.get("time-style"));
        }
        if (map.containsKey("time-zone")) {
            converter = this.getDateTimeConverter(converter);
            ((DateTimeConverter)converter).setTimeZone(TimeZone.getTimeZone(map.get("time-zone")));
        }
        if (map.containsKey("datetime-type")) {
            converter = this.getDateTimeConverter(converter);
            ((DateTimeConverter)converter).setType(map.get("datetime-type"));
        }
        if (map.containsKey("currency-code")) {
            converter = this.getNumberConverter(converter);
            ((NumberConverter)converter).setCurrencyCode(map.get("currency-code"));
        }
        if (map.containsKey("currency-symbol")) {
            converter = this.getNumberConverter(converter);
            ((NumberConverter)converter).setCurrencySymbol(map.get("currency-symbol"));
        }
        if (map.containsKey("number-uses-grouping-separators")) {
            converter = this.getNumberConverter(converter);
            ((NumberConverter)converter).setGroupingUsed(Boolean.parseBoolean(map.get("number-uses-grouping-separators")));
        }
        if (map.containsKey("minimum-integer-digits")) {
            converter = this.getNumberConverter(converter);
            ((NumberConverter)converter).setMinIntegerDigits(Integer.parseInt(map.get("minimum-integer-digits")));
        }
        if (map.containsKey("maximum-integer-digits")) {
            converter = this.getNumberConverter(converter);
            ((NumberConverter)converter).setMaxIntegerDigits(Integer.parseInt(map.get("maximum-integer-digits")));
        }
        if (map.containsKey("minimum-fractional-digits")) {
            converter = this.getNumberConverter(converter);
            ((NumberConverter)converter).setMinFractionDigits(Integer.parseInt(map.get("minimum-fractional-digits")));
        }
        if (map.containsKey("maximum-fractional-digits")) {
            converter = this.getNumberConverter(converter);
            ((NumberConverter)converter).setMaxFractionDigits(Integer.parseInt(map.get("maximum-fractional-digits")));
        }
        if (map.containsKey("number-pattern")) {
            converter = this.getNumberConverter(converter);
            ((NumberConverter)converter).setPattern(map.get("number-pattern"));
        }
        if (map.containsKey("number-type")) {
            converter = this.getNumberConverter(converter);
            ((NumberConverter)converter).setType(map.get("number-type"));
        }
        if (map.containsKey("locale")) {
            if (converter instanceof NumberConverter) {
                ((NumberConverter)converter).setLocale(new Locale(map.get("locale")));
            } else {
                converter = this.getDateTimeConverter(converter);
                ((DateTimeConverter)converter).setLocale(new Locale(map.get("locale")));
            }
        }
        return converter;
    }

    private DateTimeConverter getDateTimeConverter(Converter converter) {
        if (converter != null) {
            if (!(converter instanceof DateTimeConverter)) {
                throw WidgetProcessorException.newException("Unable to set date/time attributes on a " + converter.getClass());
            }
            return (DateTimeConverter)converter;
        }
        FacesContext facesContext = FacesContext.getCurrentInstance();
        DateTimeConverter dateTimeConverter = (DateTimeConverter)facesContext.getApplication().createConverter(Date.class);
        if (dateTimeConverter != null) {
            return dateTimeConverter;
        }
        return new DateTimeConverter();
    }

    private NumberConverter getNumberConverter(Converter converter) {
        if (converter != null) {
            if (!(converter instanceof NumberConverter)) {
                throw WidgetProcessorException.newException("Unable to set number attributes on a " + converter.getClass());
            }
            return (NumberConverter)converter;
        }
        FacesContext facesContext = FacesContext.getCurrentInstance();
        NumberConverter numberConverter = (NumberConverter)facesContext.getApplication().createConverter(Number.class);
        if (numberConverter != null) {
            return numberConverter;
        }
        return new NumberConverter();
    }
}

