/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.faces.renderkit.html;

import java.io.IOException;
import java.util.Map;
import javax.faces.component.UICommand;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UIOutput;
import javax.faces.component.UIParameter;
import javax.faces.component.html.HtmlInputHidden;
import javax.faces.component.html.HtmlMessage;
import javax.faces.component.html.HtmlOutputLabel;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;
import org.metawidget.faces.FacesUtils;
import org.metawidget.faces.component.UIMetawidget;
import org.metawidget.faces.component.UIStub;
import org.metawidget.util.simple.SimpleLayoutUtils;

public abstract class HtmlLayoutRenderer
extends Renderer {
    private static final String LABEL_ID_SUFFIX = "-label";

    public void encodeBegin(FacesContext facesContext, UIComponent uIComponent) throws IOException {
        UIMetawidget uIMetawidget = (UIMetawidget)uIComponent;
        uIMetawidget.putClientProperty(HtmlLayoutRenderer.class, null);
        super.encodeBegin(facesContext, (UIComponent)uIMetawidget);
        State state = this.getState((UIComponent)uIMetawidget);
        state.labelSuffix = uIMetawidget.getParameter("labelSuffix");
        String string = uIMetawidget.getParameter("inlineMessages");
        if (string != null) {
            state.inlineMessages = Boolean.valueOf(string);
        }
        state.messageStyle = uIMetawidget.getParameter("messageStyle");
        state.messageStyleClass = uIMetawidget.getParameter("messageStyleClass");
    }

    public boolean getRendersChildren() {
        return true;
    }

    protected String getLabelText(UIComponent uIComponent) {
        Map map = (Map)uIComponent.getAttributes().get("metawidget-metadata");
        return ((UIMetawidget)uIComponent.getParent()).getLabelString(map);
    }

    protected boolean layoutLabel(FacesContext facesContext, UIComponent uIComponent, UIComponent uIComponent2) throws IOException {
        if (uIComponent2 instanceof UICommand) {
            return false;
        }
        String string = this.getLabelText(uIComponent2);
        if (!SimpleLayoutUtils.needsLabel(string, null)) {
            return false;
        }
        UIOutput uIOutput = this.createLabel(facesContext, uIComponent2);
        State state = this.getState(uIComponent);
        if (state.labelSuffix == null) {
            state.labelSuffix = ":";
        }
        uIOutput.setValue((Object)(string + state.labelSuffix));
        FacesUtils.render(facesContext, (UIComponent)uIOutput);
        return true;
    }

    protected UIOutput createLabel(FacesContext facesContext, UIComponent uIComponent) {
        HtmlOutputLabel htmlOutputLabel = (HtmlOutputLabel)facesContext.getApplication().createComponent("javax.faces.HtmlOutputLabel");
        if (uIComponent instanceof UIStub) {
            if (uIComponent.getChildren().size() == 1) {
                htmlOutputLabel.setFor(((UIComponent)uIComponent.getChildren().get(0)).getId());
            }
        } else if (uIComponent.getId() != null) {
            htmlOutputLabel.setFor(uIComponent.getId());
        }
        if (htmlOutputLabel.getFor() != null) {
            htmlOutputLabel.setParent(uIComponent.getParent());
            htmlOutputLabel.setId(htmlOutputLabel.getFor() + LABEL_ID_SUFFIX);
        }
        return htmlOutputLabel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void layoutChild(FacesContext facesContext, UIComponent uIComponent, UIComponent uIComponent2) throws IOException {
        Object object2;
        Map map;
        FacesUtils.render(facesContext, uIComponent2);
        if (uIComponent2 instanceof HtmlInputHidden) {
            return;
        }
        String string = uIComponent2.getId();
        if (uIComponent2 instanceof UIMetawidget) {
            map = null;
            for (Object object2 : uIComponent2.getChildren()) {
                if (object2 instanceof UIParameter) continue;
                if (map != null) {
                    return;
                }
                map = object2;
            }
            if (map == null) {
                return;
            }
            string = map.getId();
        } else if (!(uIComponent2 instanceof UIInput)) {
            return;
        }
        map = (Map)uIComponent2.getAttributes().get("metawidget-metadata");
        if (map != null && ("true".equals(map.get("read-only")) || ((UIMetawidget)uIComponent).isReadOnly())) {
            return;
        }
        State state = this.getState(uIComponent);
        if (!state.inlineMessages) {
            return;
        }
        object2 = uIComponent.getChildren();
        UIComponent uIComponent3 = this.createInlineMessage(facesContext, uIComponent, string);
        try {
            object2.add(uIComponent3);
            FacesUtils.render(facesContext, uIComponent3);
        }
        finally {
            object2.remove(uIComponent3);
        }
    }

    protected UIComponent createInlineMessage(FacesContext facesContext, UIComponent uIComponent, String string) {
        HtmlMessage htmlMessage = (HtmlMessage)facesContext.getApplication().createComponent("javax.faces.HtmlMessage");
        htmlMessage.setId(FacesUtils.createUniqueId());
        htmlMessage.setFor(string);
        State state = this.getState(uIComponent);
        FacesUtils.setStyleAndStyleClass((UIComponent)htmlMessage, state.messageStyle, state.messageStyleClass);
        return htmlMessage;
    }

    protected void writeStyleAndClass(UIMetawidget uIMetawidget, ResponseWriter responseWriter, String string) throws IOException {
        String string2;
        String string3 = uIMetawidget.getParameter(string + "Style");
        if (string3 != null) {
            responseWriter.writeAttribute("style", (Object)string3, "style");
        }
        if ((string2 = uIMetawidget.getParameter(string + "StyleClass")) != null) {
            responseWriter.writeAttribute("class", (Object)string2, "class");
        }
    }

    private State getState(UIComponent uIComponent) {
        State state = (State)((UIMetawidget)uIComponent).getClientProperty(HtmlLayoutRenderer.class);
        if (state == null) {
            state = new State();
            ((UIMetawidget)uIComponent).putClientProperty(HtmlLayoutRenderer.class, state);
        }
        return state;
    }

    static class State {
        boolean inlineMessages = true;
        String messageStyle;
        String messageStyleClass;
        String labelSuffix;

        State() {
        }
    }
}

