/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.faces.renderkit.html;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.component.UIInput;
import javax.faces.component.UIParameter;
import javax.faces.component.html.HtmlInputHidden;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.el.ValueBinding;
import org.metawidget.faces.FacesUtils;
import org.metawidget.faces.component.UIMetawidget;
import org.metawidget.faces.component.UIStub;
import org.metawidget.faces.renderkit.html.HtmlLayoutRenderer;
import org.metawidget.layout.iface.LayoutException;
import org.metawidget.util.WidgetBuilderUtils;
import org.metawidget.util.simple.SimpleLayoutUtils;
import org.metawidget.util.simple.StringUtils;

public class HtmlTableLayoutRenderer
extends HtmlLayoutRenderer {
    private static final String TABLE_ID_PREFIX = "table-";
    private static final String ROW_ID_SUFFIX = "-row";
    private static final String LABEL_CELL_ID_SUFFIX = "-label-cell";
    private static final String COMPONENT_CELL_ID_SUFFIX = "-cell";
    private static final int JUST_COMPONENT_AND_REQUIRED = 2;
    private static final int LABEL_AND_COMPONENT_AND_REQUIRED = 3;

    public void encodeBegin(FacesContext facesContext, UIComponent uIComponent) throws IOException {
        UIComponent uIComponent2;
        UIComponent uIComponent3;
        String string;
        String string2;
        UIMetawidget uIMetawidget = (UIMetawidget)uIComponent;
        uIMetawidget.putClientProperty(HtmlTableLayoutRenderer.class, null);
        super.encodeBegin(facesContext, (UIComponent)uIMetawidget);
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        if (this.hasHtmlInputHiddenChildren((UIComponent)uIMetawidget)) {
            responseWriter.startElement("div", (UIComponent)uIMetawidget);
            responseWriter.writeAttribute("id", (Object)uIMetawidget.getClientId(facesContext), "id");
            this.layoutHtmlInputHiddenChildren(facesContext, (UIComponent)uIMetawidget);
            responseWriter.startElement("table", (UIComponent)uIMetawidget);
        } else {
            responseWriter.startElement("table", (UIComponent)uIMetawidget);
            responseWriter.writeAttribute("id", (Object)uIMetawidget.getClientId(facesContext), "id");
        }
        this.writeStyleAndClass(uIMetawidget, responseWriter, "table");
        State state = this.getState((UIComponent)uIMetawidget);
        state.labelStyle = uIMetawidget.getParameter("labelStyle");
        state.componentStyle = uIMetawidget.getParameter("componentStyle");
        state.requiredStyle = uIMetawidget.getParameter("requiredStyle");
        String string3 = uIMetawidget.getParameter("columnClasses");
        if (string3 != null) {
            state.columnClasses = string3.split(StringUtils.SEPARATOR_COMMA);
        }
        if ((string2 = uIMetawidget.getParameter("rowClasses")) != null) {
            state.rowClasses = string2.split(StringUtils.SEPARATOR_COMMA);
        }
        if ((string = uIMetawidget.getParameter("columns")) != null) {
            state.columns = Integer.parseInt(string);
            if (state.columns < 0) {
                throw LayoutException.newException("columns must be >= 0");
            }
        }
        if ((uIComponent3 = uIMetawidget.getFacet("header")) != null) {
            responseWriter.startElement("thead", (UIComponent)uIMetawidget);
            responseWriter.startElement("tr", (UIComponent)uIMetawidget);
            responseWriter.startElement("td", (UIComponent)uIMetawidget);
            int n = Math.max(2, state.columns * 3);
            responseWriter.writeAttribute("colspan", (Object)String.valueOf(n), null);
            this.writeStyleAndClass(uIMetawidget, responseWriter, "header");
            FacesUtils.render(facesContext, uIComponent3);
            responseWriter.endElement("td");
            responseWriter.endElement("tr");
            responseWriter.endElement("thead");
        }
        if ((uIComponent2 = uIMetawidget.getFacet("footer")) != null) {
            responseWriter.startElement("tfoot", (UIComponent)uIMetawidget);
            responseWriter.startElement("tr", (UIComponent)uIMetawidget);
            responseWriter.startElement("td", (UIComponent)uIMetawidget);
            int n = Math.max(2, state.columns * 3);
            responseWriter.writeAttribute("colspan", (Object)String.valueOf(n), null);
            this.writeStyleAndClass(uIMetawidget, responseWriter, "footer");
            FacesUtils.render(facesContext, uIComponent2);
            responseWriter.endElement("td");
            responseWriter.endElement("tr");
            responseWriter.endElement("tfoot");
        }
        responseWriter.startElement("tbody", (UIComponent)uIMetawidget);
    }

    protected boolean hasHtmlInputHiddenChildren(UIComponent uIComponent) {
        for (UIComponent uIComponent2 : uIComponent.getChildren()) {
            if (!(uIComponent2 instanceof HtmlInputHidden)) continue;
            return true;
        }
        return false;
    }

    protected void layoutHtmlInputHiddenChildren(FacesContext facesContext, UIComponent uIComponent) throws IOException {
        for (UIComponent uIComponent2 : uIComponent.getChildren()) {
            if (!(uIComponent2 instanceof HtmlInputHidden)) continue;
            FacesUtils.render(facesContext, uIComponent2);
        }
    }

    public void encodeChildren(FacesContext facesContext, UIComponent uIComponent) throws IOException {
        State state = this.getState(uIComponent);
        if (state == null) {
            return;
        }
        List list = uIComponent.getChildren();
        state.currentColumn = 0;
        state.currentRow = 0;
        for (UIComponent uIComponent2 : list) {
            if (uIComponent2 instanceof UIStub) {
                boolean bl = false;
                for (UIComponent uIComponent3 : uIComponent2.getChildren()) {
                    if (!uIComponent3.isRendered()) continue;
                    bl = true;
                    break;
                }
                if (!bl) continue;
            }
            if (uIComponent2 instanceof UIParameter || uIComponent2 instanceof HtmlInputHidden || !uIComponent2.isRendered()) continue;
            ++state.currentColumn;
            this.layoutBeforeChild(facesContext, uIComponent, uIComponent2);
            this.layoutChild(facesContext, uIComponent, uIComponent2);
            this.layoutAfterChild(facesContext, uIComponent, uIComponent2);
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uIComponent) throws IOException {
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        responseWriter.endElement("tbody");
        responseWriter.endElement("table");
        if (this.hasHtmlInputHiddenChildren(uIComponent)) {
            responseWriter.endElement("div");
        }
    }

    protected void layoutBeforeChild(FacesContext facesContext, UIComponent uIComponent, UIComponent uIComponent2) throws IOException {
        int n;
        boolean bl;
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        String string = this.getCssId(uIComponent2);
        Map map = (Map)uIComponent2.getAttributes().get("metawidget-metadata");
        State state = this.getState(uIComponent);
        if (map != null) {
            boolean bl2 = bl = uIComponent instanceof UIData || "true".equals(map.get("large"));
            if (bl && state.currentColumn != 1) {
                responseWriter.endElement("tr");
                state.currentColumn = 1;
            }
        }
        if (state.currentColumn == 1 || state.currentColumn > state.columns) {
            state.currentColumn = 1;
            responseWriter.startElement("tr", uIComponent);
            if (string != null) {
                responseWriter.writeAttribute("id", (Object)(TABLE_ID_PREFIX + string + ROW_ID_SUFFIX), null);
            }
            this.writeRowStyleClass(uIComponent, responseWriter, state.currentRow);
            ++state.currentRow;
        }
        if ((bl = this.layoutLabel(facesContext, uIComponent, uIComponent2)) && state.columns == 0) {
            responseWriter.endElement("tr");
            responseWriter.startElement("tr", uIComponent);
            if (string != null) {
                responseWriter.writeAttribute("id", (Object)(TABLE_ID_PREFIX + string + ROW_ID_SUFFIX + "2"), null);
            }
            this.writeRowStyleClass(uIComponent, responseWriter, state.currentRow);
        }
        responseWriter.startElement("td", uIComponent);
        if (string != null) {
            responseWriter.writeAttribute("id", (Object)(TABLE_ID_PREFIX + string + COMPONENT_CELL_ID_SUFFIX), null);
        }
        if (state.componentStyle != null) {
            responseWriter.writeAttribute("style", (Object)state.componentStyle, null);
        }
        this.writeColumnStyleClass(uIComponent, responseWriter, 1);
        if (uIComponent2 instanceof UIMetawidget || uIComponent2 instanceof UIData || SimpleLayoutUtils.isSpanAllColumns(map)) {
            n = state.columns * 3 - 2;
            state.currentColumn = state.columns;
            if (!bl) {
                ++n;
            }
            if (uIComponent2 instanceof UIMetawidget && "table".equals(uIComponent2.getRendererType())) {
                ++n;
            }
        } else {
            n = !bl ? 2 : 1;
        }
        if (n > 1) {
            responseWriter.writeAttribute("colspan", (Object)String.valueOf(n), null);
        }
    }

    protected boolean layoutLabel(FacesContext facesContext, UIComponent uIComponent, UIComponent uIComponent2) throws IOException {
        if (this.getLabelText(uIComponent2) == null) {
            return false;
        }
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        responseWriter.startElement("th", uIComponent);
        String string = this.getCssId(uIComponent2);
        if (string != null) {
            responseWriter.writeAttribute("id", (Object)(TABLE_ID_PREFIX + string + LABEL_CELL_ID_SUFFIX), null);
        }
        State state = this.getState(uIComponent);
        if (state.labelStyle != null) {
            responseWriter.writeAttribute("style", (Object)state.labelStyle, null);
        }
        this.writeColumnStyleClass(uIComponent, responseWriter, 0);
        super.layoutLabel(facesContext, uIComponent, uIComponent2);
        responseWriter.endElement("th");
        return true;
    }

    protected void layoutAfterChild(FacesContext facesContext, UIComponent uIComponent, UIComponent uIComponent2) throws IOException {
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        responseWriter.endElement("td");
        State state = this.getState(uIComponent);
        if (!(uIComponent2 instanceof UIMetawidget && "table".equals(uIComponent2.getRendererType()) || !uIComponent2.getAttributes().containsKey("metawidget-metadata"))) {
            responseWriter.startElement("td", uIComponent);
            if (state.requiredStyle != null) {
                responseWriter.writeAttribute("style", (Object)state.requiredStyle, null);
            }
            this.writeColumnStyleClass(uIComponent, responseWriter, 2);
            this.layoutRequired(facesContext, uIComponent, uIComponent2);
            responseWriter.endElement("td");
        }
        if (state.currentColumn >= state.columns) {
            state.currentColumn = 0;
            responseWriter.endElement("tr");
        }
    }

    protected void layoutRequired(FacesContext facesContext, UIComponent uIComponent, UIComponent uIComponent2) throws IOException {
        Map map = (Map)uIComponent2.getAttributes().get("metawidget-metadata");
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        if (map != null && "true".equals(map.get("required")) && !WidgetBuilderUtils.isReadOnly(map) && !((UIMetawidget)uIComponent).isReadOnly() && (uIComponent2 instanceof UIInput || uIComponent2 instanceof UIStub || uIComponent2 instanceof UIMetawidget)) {
            responseWriter.write("*");
            return;
        }
        responseWriter.startElement("div", uIComponent);
        responseWriter.endElement("div");
    }

    protected String getCssId(UIComponent uIComponent) {
        ValueBinding valueBinding = uIComponent.getValueBinding("value");
        if (valueBinding == null) {
            return null;
        }
        return StringUtils.camelCase(FacesUtils.unwrapExpression(valueBinding.getExpressionString()), '.');
    }

    protected void writeColumnStyleClass(UIComponent uIComponent, ResponseWriter responseWriter, int n) throws IOException {
        State state = this.getState(uIComponent);
        if (state.columnClasses == null || state.columnClasses.length <= n) {
            return;
        }
        String string = state.columnClasses[n];
        if (string.length() == 0) {
            return;
        }
        responseWriter.writeAttribute("class", (Object)string.trim(), null);
    }

    protected void writeRowStyleClass(UIComponent uIComponent, ResponseWriter responseWriter, int n) throws IOException {
        State state = this.getState(uIComponent);
        if (state.rowClasses == null) {
            return;
        }
        String string = state.rowClasses[n % state.rowClasses.length];
        if (string.length() == 0) {
            return;
        }
        responseWriter.writeAttribute("class", (Object)string.trim(), null);
    }

    State getState(UIComponent uIComponent) {
        State state = (State)((UIMetawidget)uIComponent).getClientProperty(HtmlTableLayoutRenderer.class);
        if (state == null) {
            state = new State();
            ((UIMetawidget)uIComponent).putClientProperty(HtmlTableLayoutRenderer.class, state);
        }
        return state;
    }

    static class State {
        int currentColumn;
        int columns = 1;
        int currentRow;
        String labelStyle;
        String componentStyle;
        String requiredStyle;
        String[] columnClasses;
        String[] rowClasses;

        State() {
        }
    }
}

