/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.gwt.client.ui;

import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.ListBox;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GwtUtils {
    public static boolean isPrimitive(String string) {
        if (GwtUtils.isIntegerPrimitive(string)) {
            return true;
        }
        if ("float".equals(string) || "double".equals(string)) {
            return true;
        }
        if ("boolean".equals(string)) {
            return true;
        }
        return "char".equals(string);
    }

    public static boolean isIntegerPrimitive(String string) {
        if ("byte".equals(string) || "short".equals(string)) {
            return true;
        }
        return "int".equals(string) || "long".equals(string);
    }

    public static boolean isPrimitiveWrapper(String string) {
        if (Byte.class.getName().equals(string) || Short.class.getName().equals(string)) {
            return true;
        }
        if (Integer.class.getName().equals(string) || Long.class.getName().equals(string)) {
            return true;
        }
        if (Float.class.getName().equals(string) || Double.class.getName().equals(string)) {
            return true;
        }
        if (Boolean.class.getName().equals(string)) {
            return true;
        }
        return Character.class.getName().equals(string);
    }

    public static boolean isCollection(String string) {
        if (Collection.class.getName().equals(string)) {
            return true;
        }
        if (List.class.getName().equals(string) || ArrayList.class.getName().equals(string)) {
            return true;
        }
        if (Set.class.getName().equals(string) || HashSet.class.getName().equals(string)) {
            return true;
        }
        return Map.class.getName().equals(string) || HashMap.class.getName().equals(string);
    }

    public static List<String> fromString(String string, char c) {
        if (string == null || "".equals(string)) {
            return Collections.emptyList();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : string.split(String.valueOf(c))) {
            arrayList.add(string2.trim());
        }
        if (string.charAt(string.length() - 1) == c) {
            arrayList.add("");
        }
        return arrayList;
    }

    public static String toString(String[] stringArray, char c) {
        if (stringArray == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : stringArray) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(c);
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public static String toString(Collection<?> collection, char c) {
        if (collection == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (Object obj : collection) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(c);
            }
            stringBuilder.append(obj);
        }
        return stringBuilder.toString();
    }

    public static void setListBoxSelectedItem(ListBox listBox, String string) {
        int n = listBox.getItemCount();
        for (int i = 0; i < n; ++i) {
            if (!string.equals(listBox.getValue(i))) continue;
            listBox.setSelectedIndex(i);
            return;
        }
    }

    public static void alert(Throwable throwable) {
        StringBuilder stringBuilder = new StringBuilder(throwable.getClass().getName());
        if (throwable.getMessage() != null) {
            stringBuilder.append(": ");
            stringBuilder.append(throwable.getMessage());
        }
        for (StackTraceElement stackTraceElement : throwable.getStackTrace()) {
            stringBuilder.append("\n\t");
            stringBuilder.append(stackTraceElement);
        }
        Window.alert((String)stringBuilder.toString());
    }

    public static boolean isReadOnly(Map<String, String> map) {
        if ("true".equals(map.get("read-only"))) {
            return true;
        }
        return "true".equals(map.get("no-setter"));
    }

    public static String getActualClassOrType(Map<String, String> map) {
        String string = map.get("actual-class");
        if (string != null && !"".equals(string)) {
            return string;
        }
        string = map.get("type");
        if ("".equals(string)) {
            return null;
        }
        return string;
    }

    public static boolean needsEmptyLookupItem(Map<String, String> map) {
        if ("true".equals(map.get("lookup-has-empty-choice"))) {
            return true;
        }
        if ("true".equals(map.get("required"))) {
            return false;
        }
        String string = GwtUtils.getActualClassOrType(map);
        return string == null || !GwtUtils.isPrimitive(string);
    }

    public static String stripSection(Map<String, String> map) {
        String string = map.remove("section");
        if (string == null) {
            return null;
        }
        List<String> list = GwtUtils.fromString(string, ',');
        switch (list.size()) {
            case 0: {
                return "";
            }
            case 1: {
                return list.get(0);
            }
        }
        String string2 = list.remove(0);
        map.put("section", GwtUtils.toString(list, ','));
        return string2;
    }

    private GwtUtils() {
    }
}

