/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.gwt.client.ui.layout;

import org.metawidget.layout.iface.LayoutException;
import org.metawidget.util.simple.ObjectUtils;

public class FlexTableLayoutConfig {
    private int mNumberOfColumns = 1;
    private String mTableStyleName;
    private String[] mColumnStyleNames;
    private String mFooterStyleName;

    public FlexTableLayoutConfig setNumberOfColumns(int n) {
        if (n < 0) {
            throw LayoutException.newException("numberOfColumns must be >= 0");
        }
        this.mNumberOfColumns = n;
        return this;
    }

    public FlexTableLayoutConfig setTableStyleName(String string) {
        this.mTableStyleName = string;
        return this;
    }

    public FlexTableLayoutConfig setColumnStyleNames(String ... stringArray) {
        this.mColumnStyleNames = stringArray;
        return this;
    }

    public FlexTableLayoutConfig setFooterStyleName(String string) {
        this.mFooterStyleName = string;
        return this;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!ObjectUtils.nullSafeClassEquals(this, object)) {
            return false;
        }
        if (this.mNumberOfColumns != ((FlexTableLayoutConfig)object).mNumberOfColumns) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals(this.mTableStyleName, ((FlexTableLayoutConfig)object).mTableStyleName)) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals(this.mColumnStyleNames, ((FlexTableLayoutConfig)object).mColumnStyleNames)) {
            return false;
        }
        return ObjectUtils.nullSafeEquals(this.mFooterStyleName, ((FlexTableLayoutConfig)object).mFooterStyleName);
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + this.mNumberOfColumns;
        n = 31 * n + ObjectUtils.nullSafeHashCode(this.mTableStyleName);
        n = 31 * n + ObjectUtils.nullSafeHashCode(this.mColumnStyleNames);
        n = 31 * n + ObjectUtils.nullSafeHashCode(this.mFooterStyleName);
        return n;
    }

    protected int getNumberOfColumns() {
        return this.mNumberOfColumns;
    }

    protected String getTableStyleName() {
        return this.mTableStyleName;
    }

    protected String[] getColumnStyleNames() {
        return this.mColumnStyleNames;
    }

    protected String getFooterStyleName() {
        return this.mFooterStyleName;
    }
}

